/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.query.inmemory;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.store.query.inmemory.InvocationEvaluator;
import org.datanucleus.util.Localiser;

public class RectangleContainsMethod
implements InvocationEvaluator {
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        List args = expr.getArguments();
        if (args == null || args.size() != 1) {
            throw new NucleusException("Should have 1 argument to Rectangle.contains(...)");
        }
        Object argVal = null;
        Object argExpr = expr.getArguments().get(0);
        if (argExpr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)argExpr;
            argVal = eval.getValueForPrimaryExpression(primExpr);
        } else if (argExpr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)argExpr;
            argVal = QueryUtils.getValueForParameterExpression((Map)eval.getParameterValues(), (ParameterExpression)paramExpr);
        } else if (argExpr instanceof Literal) {
            argVal = ((Literal)argExpr).getLiteral();
        } else if (argExpr instanceof InvokeExpression) {
            argVal = eval.getValueForInvokeExpression((InvokeExpression)argExpr);
        } else {
            throw new NucleusException(method + "(arg) where arg is instanceof " + argExpr.getClass().getName() + " not supported");
        }
        if (invokedValue == null) {
            return null;
        }
        if (invokedValue instanceof Rectangle) {
            if (argVal instanceof Point) {
                return ((Rectangle)invokedValue).contains((Point)argVal);
            }
            if (argVal instanceof Rectangle) {
                return ((Rectangle)invokedValue).contains((Rectangle)argVal);
            }
            throw new NucleusException(method + "(arg) where arg is instanceof " + argVal.getClass().getName() + " not supported");
        }
        throw new NucleusException(Localiser.msg((String)"021011", (Object[])new Object[]{method, invokedValue.getClass().getName()}));
    }
}

