/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.expression.GeometryExpression;

public class OracleSdoOrdinateArrayMethod
implements SQLMethod {
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression ignore, List args) {
        if (args == null || args.size() != 1) {
            throw new NucleusUserException("Cannot invoke Oracle.sdo_ordinate_array without 1 argument");
        }
        SQLExpression numbersExpr = (SQLExpression)args.get(0);
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        if (numbersExpr instanceof StringLiteral) {
            JavaTypeMapping m = stmt.getSQLExpressionFactory().getMappingForType(Double.class);
            String[] token = ((String)((StringLiteral)numbersExpr).getValue()).split(",");
            try {
                SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
                for (int i = 0; i < token.length; ++i) {
                    SQLExpression numberLit = exprFactory.newLiteral(stmt, m, (Object)Double.valueOf(token[i]));
                    funcArgs.add(numberLit);
                }
            }
            catch (NumberFormatException e) {
                throw new NucleusUserException("Impossible to convert input to Oracle.sdo_ordinate_array into list of doubles");
            }
        }
        return new GeometryExpression(stmt, null, "SDO_ORDINATE_ARRAY", funcArgs, null);
    }
}

