/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;

public class SpatialBboxTestMethod3
implements SQLMethod {
    private static final String RELATE_MASK_FOR_BBOXTEST = "MASK=OVERLAPBDYINTERSECT QUERYTYPE=WINDOW";

    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List args) {
        if (args == null) {
            throw new NucleusUserException("Cannot invoke Spatial.bboxTest without arguments");
        }
        if (expr == null && args.size() != 3) {
            throw new NucleusUserException("Cannot invoke Spatial.bboxTest without 3 arguments");
        }
        if (expr != null && args.size() != 2) {
            throw new NucleusUserException("Cannot invoke geom.bboxTest() without 2 arguments");
        }
        SQLExpression argExpr1 = null;
        SQLExpression argExpr2 = null;
        SQLExpression argTol = null;
        if (expr == null) {
            argExpr1 = (SQLExpression)args.get(0);
            argExpr2 = (SQLExpression)args.get(1);
            argTol = (SQLExpression)args.get(2);
        } else {
            argExpr1 = expr;
            argExpr2 = (SQLExpression)args.get(0);
            argTol = (SQLExpression)args.get(1);
        }
        StringLiteral mask = new StringLiteral(stmt, null, (Object)RELATE_MASK_FOR_BBOXTEST, null);
        ArrayList<Object> funcArgs = new ArrayList<Object>();
        funcArgs.add(argExpr1);
        funcArgs.add(mask);
        funcArgs.add(argExpr2);
        funcArgs.add(argTol);
        JavaTypeMapping m = stmt.getSQLExpressionFactory().getMappingForType(String.class, true);
        StringExpression relateExp = new StringExpression(stmt, m, "SDO_GEOM.RELATE", funcArgs);
        return relateExp.eq((SQLExpression)mask);
    }
}

