/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.adapter;

import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import oracle.spatial.geometry.JGeometry;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.OracleAdapter;
import org.datanucleus.store.rdbms.adapter.OracleTypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.types.geospatial.rdbms.adapter.SpatialRDBMSAdapter;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jgeom2oracle.JGeometryRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jts2oracle.GeometryRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.mapping.jts2oracle.LinearRingRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.OracleSdoElemInfoArrayMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.OracleSdoGeometryMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.OracleSdoOrdinateArrayMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.OracleSdoPointTypeMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialAreaMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialAsBinaryMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialAsTextMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialBboxTestMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialBoundaryMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialBufferMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialCentroidMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialContainsMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialConvexHullMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialCrossesMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDifferenceMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDimensionMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDisjointMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialDistanceMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialEndPointMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialEnvelopeMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialEqualsMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialExteriorRingMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomCollFromTextMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomCollFromWKBMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomFromTextMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeomFromWKBMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeometryNMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialGeometryTypeMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialInteriorRingNMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIntersectionMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIntersectsMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsClosedMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsEmptyMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsRingMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialIsSimpleMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialLengthMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialLineFromTextMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialLineFromWKBMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMLineFromTextMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMLineFromWKBMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMPointFromTextMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMPointFromWKBMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMPolyFromTextMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMPolyFromWKBMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialNumGeometriesMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialNumInteriorRingMethod3;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialNumPointsMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialOverlapsMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPointFromTextMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPointFromWKBMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPointNMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPointOnSurfaceMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPolyFromTextMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialPolyFromWKBMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialRelateMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialSridMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialStartPointMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialSymDifferenceMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialTouchesMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialUnionMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialWithinMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialXMethod2;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialYMethod2;
import org.datanucleus.util.NucleusLogger;
import org.postgis.Geometry;
import org.postgis.Point;

public class OracleSpatialAdapter
extends OracleAdapter
implements SpatialRDBMSAdapter {
    public OracleSpatialAdapter(DatabaseMetaData metadata) {
        super(metadata);
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        OracleTypeInfo sqlType = new OracleTypeInfo("SDO_GEOMETRY", 2002, 0, null, null, null, 1, false, 0, false, false, false, "SDO_GEOMETRY", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-123, (SQLTypeInfo)sqlType, true);
    }

    protected void loadDatastoreMappings(PluginManager mgr, ClassLoaderResolver clr) {
        Class cls;
        try {
            cls = clr.classForName("oracle.spatial.geometry.JGeometry");
            if (cls != null) {
                this.registerDatastoreMapping(JGeometry.class.getName(), JGeometryRDBMSMapping.class, JDBCType.STRUCT, "SDO_GEOMETRY", true);
            }
        }
        catch (Throwable thr) {
            NucleusLogger.DATASTORE.warn((Object)"Not loading RDBMS support for Oracle JGeometry since not present");
        }
        try {
            cls = clr.classForName("com.vividsolutions.jts.geom.Geometry");
            if (cls != null) {
                this.registerDatastoreMapping(com.vividsolutions.jts.geom.Geometry.class.getName(), GeometryRDBMSMapping.class, JDBCType.STRUCT, "SDO_GEOMETRY", true);
                this.registerDatastoreMapping(GeometryCollection.class.getName(), GeometryRDBMSMapping.class, JDBCType.STRUCT, "SDO_GEOMETRY", true);
                this.registerDatastoreMapping(LinearRing.class.getName(), LinearRingRDBMSMapping.class, JDBCType.STRUCT, "SDO_GEOMETRY", true);
                this.registerDatastoreMapping(LineString.class.getName(), GeometryRDBMSMapping.class, JDBCType.STRUCT, "SDO_GEOMETRY", true);
                this.registerDatastoreMapping(MultiLineString.class.getName(), GeometryRDBMSMapping.class, JDBCType.STRUCT, "SDO_GEOMETRY", true);
                this.registerDatastoreMapping(MultiPolygon.class.getName(), GeometryRDBMSMapping.class, JDBCType.STRUCT, "SDO_GEOMETRY", true);
                this.registerDatastoreMapping(MultiPoint.class.getName(), GeometryRDBMSMapping.class, JDBCType.STRUCT, "SDO_GEOMETRY", true);
                this.registerDatastoreMapping(com.vividsolutions.jts.geom.Point.class.getName(), GeometryRDBMSMapping.class, JDBCType.STRUCT, "SDO_GEOMETRY", true);
                this.registerDatastoreMapping(Polygon.class.getName(), GeometryRDBMSMapping.class, JDBCType.STRUCT, "SDO_GEOMETRY", true);
            }
        }
        catch (Throwable thr) {
            NucleusLogger.DATASTORE.warn((Object)"Not loading RDBMS support for Vividsolutions JTS types since not present");
        }
        super.loadDatastoreMappings(mgr, clr);
    }

    @Override
    public boolean isGeometryColumn(Column c) {
        return String.valueOf(c.getTypeInfo().getDataType()).matches("[2-4][0,3,4][0-9][0-9]");
    }

    @Override
    public String getRetrieveCrsNameStatement(Table table, int srid) {
        return "SELECT CS_NAME FROM MDSYS.CS_SRS WHERE SRID = #srid".replace("#srid", "" + srid);
    }

    @Override
    public String getRetrieveCrsWktStatement(Table table, int srid) {
        return "SELECT WKTEXT FROM MDSYS.CS_SRS WHERE SRID = #srid".replace("#srid", "" + srid);
    }

    @Override
    public String getCalculateBoundsStatement(Table table, Column column) {
        return "SELECT SDO_GEOM.SDO_MIN_MBR_ORDINATE(SDO_AGGR_MBR(#column), 1), SDO_GEOM.SDO_MIN_MBR_ORDINATE(SDO_AGGR_MBR(#column), 2), SDO_GEOM.SDO_MAX_MBR_ORDINATE(SDO_AGGR_MBR(#column), 1), SDO_GEOM.SDO_MAX_MBR_ORDINATE(SDO_AGGR_MBR(#column), 2) " + "FROM #table".replace("#column", column.getIdentifier().getName()).replace("#table", table.getIdentifier().getName());
    }

    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("Oracle.sdo_elem_info_array".equals(methodName)) {
                return OracleSdoElemInfoArrayMethod.class;
            }
            if ("Oracle.sdo_geometry".equals(methodName)) {
                return OracleSdoGeometryMethod.class;
            }
            if ("Oracle.sdo_ordinate_array".equals(methodName)) {
                return OracleSdoOrdinateArrayMethod.class;
            }
            if ("Oracle.sdo_point_type".equals(methodName)) {
                return OracleSdoPointTypeMethod.class;
            }
            if ("Spatial.bboxTest".equals(methodName)) {
                return SpatialBboxTestMethod3.class;
            }
            if ("Spatial.dimension".equals(methodName)) {
                return SpatialDimensionMethod2.class;
            }
            if ("Spatial.srid".equals(methodName)) {
                return SpatialSridMethod2.class;
            }
            if ("Spatial.x".equals(methodName)) {
                return SpatialXMethod2.class;
            }
            if ("Spatial.y".equals(methodName)) {
                return SpatialYMethod2.class;
            }
            if ("Spatial.area".equals(methodName)) {
                return SpatialAreaMethod2.class;
            }
            if ("Spatial.length".equals(methodName)) {
                return SpatialLengthMethod3.class;
            }
            if ("Spatial.distance".equals(methodName)) {
                return SpatialDistanceMethod2.class;
            }
            if ("Spatial.numPoints".equals(methodName)) {
                return SpatialNumPointsMethod2.class;
            }
            if ("Spatial.numInteriorRing".equals(methodName)) {
                return SpatialNumInteriorRingMethod3.class;
            }
            if ("Spatial.numGeometries".equals(methodName)) {
                return SpatialNumGeometriesMethod2.class;
            }
            if ("Spatial.asBinary".equals(methodName)) {
                return SpatialAsBinaryMethod2.class;
            }
            if ("Spatial.asText".equals(methodName)) {
                return SpatialAsTextMethod2.class;
            }
            if ("Spatial.geometryType".equals(methodName)) {
                return SpatialGeometryTypeMethod2.class;
            }
            if ("Spatial.geomFromText".equals(methodName)) {
                return SpatialGeomFromTextMethod2.class;
            }
            if ("Spatial.pointFromText".equals(methodName)) {
                return SpatialPointFromTextMethod2.class;
            }
            if ("Spatial.lineFromText".equals(methodName)) {
                return SpatialLineFromTextMethod2.class;
            }
            if ("Spatial.polyFromText".equals(methodName)) {
                return SpatialPolyFromTextMethod2.class;
            }
            if ("Spatial.mLineFromText".equals(methodName)) {
                return SpatialMLineFromTextMethod2.class;
            }
            if ("Spatial.mPointFromText".equals(methodName)) {
                return SpatialMPointFromTextMethod2.class;
            }
            if ("Spatial.mPolyFromText".equals(methodName)) {
                return SpatialMPolyFromTextMethod2.class;
            }
            if ("Spatial.geomCollFromText".equals(methodName)) {
                return SpatialGeomCollFromTextMethod2.class;
            }
            if ("Spatial.envelope".equals(methodName)) {
                return SpatialEnvelopeMethod2.class;
            }
            if ("Spatial.boundary".equals(methodName)) {
                return SpatialBoundaryMethod2.class;
            }
            if ("Spatial.convexHull".equals(methodName)) {
                return SpatialConvexHullMethod2.class;
            }
            if ("Spatial.startPoint".equals(methodName)) {
                return SpatialStartPointMethod2.class;
            }
            if ("Spatial.endPoint".equals(methodName)) {
                return SpatialEndPointMethod2.class;
            }
            if ("Spatial.centroid".equals(methodName)) {
                return SpatialCentroidMethod2.class;
            }
            if ("Spatial.pointOnSurface".equals(methodName)) {
                return SpatialPointOnSurfaceMethod2.class;
            }
            if ("Spatial.exteriorRing".equals(methodName)) {
                return SpatialExteriorRingMethod2.class;
            }
            if ("Spatial.equals".equals(methodName)) {
                return SpatialEqualsMethod2.class;
            }
            if ("Spatial.disjoint".equals(methodName)) {
                return SpatialDisjointMethod2.class;
            }
            if ("Spatial.intersects".equals(methodName)) {
                return SpatialIntersectsMethod2.class;
            }
            if ("Spatial.touches".equals(methodName)) {
                return SpatialTouchesMethod2.class;
            }
            if ("Spatial.crosses".equals(methodName)) {
                return SpatialCrossesMethod2.class;
            }
            if ("Spatial.within".equals(methodName)) {
                return SpatialWithinMethod2.class;
            }
            if ("Spatial.contains".equals(methodName)) {
                return SpatialContainsMethod2.class;
            }
            if ("Spatial.overlaps".equals(methodName)) {
                return SpatialOverlapsMethod2.class;
            }
            if ("Spatial.relate".equals(methodName)) {
                return SpatialRelateMethod2.class;
            }
            if ("Spatial.isClosed".equals(methodName)) {
                return SpatialIsClosedMethod2.class;
            }
            if ("Spatial.isEmpty".equals(methodName)) {
                return SpatialIsEmptyMethod2.class;
            }
            if ("Spatial.isRing".equals(methodName)) {
                return SpatialIsRingMethod2.class;
            }
            if ("Spatial.isSimple".equals(methodName)) {
                return SpatialIsSimpleMethod2.class;
            }
            if ("Spatial.buffer".equals(methodName)) {
                return SpatialBufferMethod2.class;
            }
            if ("Spatial.difference".equals(methodName)) {
                return SpatialDifferenceMethod2.class;
            }
            if ("Spatial.intersection".equals(methodName)) {
                return SpatialIntersectionMethod2.class;
            }
            if ("Spatial.union".equals(methodName)) {
                return SpatialUnionMethod2.class;
            }
            if ("Spatial.symDifference".equals(methodName)) {
                return SpatialSymDifferenceMethod2.class;
            }
            if ("Spatial.interiorRingN".equals(methodName)) {
                return SpatialInteriorRingNMethod2.class;
            }
            if ("Spatial.pointN".equals(methodName)) {
                return SpatialPointNMethod2.class;
            }
            if ("Spatial.geometryN".equals(methodName)) {
                return SpatialGeometryNMethod2.class;
            }
            if ("Spatial.geomFromWKB".equals(methodName)) {
                return SpatialGeomFromWKBMethod2.class;
            }
            if ("Spatial.geomCollFromWKB".equals(methodName)) {
                return SpatialGeomCollFromWKBMethod2.class;
            }
            if ("Spatial.pointFromWKB".equals(methodName)) {
                return SpatialPointFromWKBMethod2.class;
            }
            if ("Spatial.mPointFromWKB".equals(methodName)) {
                return SpatialMPointFromWKBMethod2.class;
            }
            if ("Spatial.lineFromWKB".equals(methodName)) {
                return SpatialLineFromWKBMethod2.class;
            }
            if ("Spatial.mLineFromWKB".equals(methodName)) {
                return SpatialMLineFromWKBMethod2.class;
            }
            if ("Spatial.polyFromWKB".equals(methodName)) {
                return SpatialPolyFromWKBMethod2.class;
            }
            if ("Spatial.mPolyFromWKB".equals(methodName)) {
                return SpatialMPolyFromWKBMethod2.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("com.vividsolutions.jts.geom.Point".equals(className) || cls != null && com.vividsolutions.jts.geom.Point.class.isAssignableFrom(cls)) {
                if ("getX".equals(methodName)) {
                    return SpatialXMethod2.class;
                }
                if ("getY".equals(methodName)) {
                    return SpatialYMethod2.class;
                }
            }
            if ("com.vividsolutions.jts.geom.Geometry".equals(className) || cls != null && com.vividsolutions.jts.geom.Geometry.class.isAssignableFrom(cls)) {
                if ("getNumPoints".equals(methodName)) {
                    return SpatialNumPointsMethod2.class;
                }
                if ("getArea".equals(methodName)) {
                    return SpatialAreaMethod2.class;
                }
                if ("contains".equals(methodName)) {
                    return SpatialContainsMethod2.class;
                }
                if ("getEnvelope".equals(methodName)) {
                    return SpatialEnvelopeMethod2.class;
                }
                if ("getDimension".equals(methodName)) {
                    return SpatialDimensionMethod2.class;
                }
                if ("getLength".equals(methodName)) {
                    return SpatialLengthMethod3.class;
                }
                if ("getBoundary".equals(methodName)) {
                    return SpatialBoundaryMethod2.class;
                }
                if ("getSRID".equals(methodName)) {
                    return SpatialSridMethod2.class;
                }
                if ("isSimple".equals(methodName)) {
                    return SpatialIsSimpleMethod2.class;
                }
                if ("isEmpty".equals(methodName)) {
                    return SpatialIsEmptyMethod2.class;
                }
                if ("overlaps".equals(methodName)) {
                    return SpatialOverlapsMethod2.class;
                }
                if ("touches".equals(methodName)) {
                    return SpatialTouchesMethod2.class;
                }
                if ("crosses".equals(methodName)) {
                    return SpatialCrossesMethod2.class;
                }
                if ("within".equals(methodName)) {
                    return SpatialWithinMethod2.class;
                }
                if ("intersects".equals(methodName)) {
                    return SpatialIntersectsMethod2.class;
                }
                if ("intersection".equals(methodName)) {
                    return SpatialIntersectionMethod2.class;
                }
                if ("equals".equals(methodName)) {
                    return SpatialEqualsMethod2.class;
                }
                if ("disjoint".equals(methodName)) {
                    return SpatialDisjointMethod2.class;
                }
                if ("relate".equals(methodName)) {
                    return SpatialRelateMethod2.class;
                }
                if ("difference".equals(methodName)) {
                    return SpatialDifferenceMethod2.class;
                }
                if ("symDifference".equals(methodName)) {
                    return SpatialSymDifferenceMethod2.class;
                }
                if ("getCentroid".equals(methodName)) {
                    return SpatialCentroidMethod2.class;
                }
                if ("toText".equals(methodName)) {
                    return SpatialAsTextMethod2.class;
                }
                if ("union".equals(methodName)) {
                    return SpatialUnionMethod2.class;
                }
                if ("getGeometryType".equals(methodName)) {
                    return SpatialGeometryTypeMethod2.class;
                }
                if ("distance".equals(methodName)) {
                    return SpatialDistanceMethod2.class;
                }
                if ("buffer".equals(methodName)) {
                    return SpatialBufferMethod2.class;
                }
                if ("convexHull".equals(methodName)) {
                    return SpatialConvexHullMethod2.class;
                }
            }
            if ("com.vividsolutions.jts.geom.LineString".equals(className) || cls != null && LineString.class.isAssignableFrom(cls)) {
                if ("isRing".equals(methodName)) {
                    return SpatialIsRingMethod2.class;
                }
                if ("isClosed".equals(methodName)) {
                    return SpatialIsClosedMethod2.class;
                }
                if ("getStartPoint".equals(methodName)) {
                    return SpatialStartPointMethod2.class;
                }
                if ("getEndPoint".equals(methodName)) {
                    return SpatialEndPointMethod2.class;
                }
                if ("getPointN".equals(methodName)) {
                    return SpatialPointNMethod2.class;
                }
            }
            if ("com.vividsolutions.jts.geom.Polygon".equals(className) || cls != null && Polygon.class.isAssignableFrom(cls)) {
                if ("getExteriorRing".equals(methodName)) {
                    return SpatialExteriorRingMethod2.class;
                }
                if ("getInteriorRingN".equals(methodName)) {
                    return SpatialInteriorRingNMethod2.class;
                }
                if ("getNumInteriorRing".equals(methodName)) {
                    return SpatialNumInteriorRingMethod3.class;
                }
            }
            if ("com.vividsolutions.jts.geom.GeometryCollection".equals(className) || cls != null && GeometryCollection.class.isAssignableFrom(cls)) {
                if ("getNumGeometries".equals(methodName)) {
                    return SpatialNumGeometriesMethod2.class;
                }
                if ("getGeometryN".equals(methodName)) {
                    return SpatialGeometryNMethod2.class;
                }
            }
            if ("org.postgis.Point".equals(className) || cls != null && Point.class.isAssignableFrom(cls)) {
                if ("getX".equals(methodName)) {
                    return SpatialXMethod2.class;
                }
                if ("getY".equals(methodName)) {
                    return SpatialYMethod2.class;
                }
            }
            if ("org.postgis.Geometry".equals(className) || cls != null && Geometry.class.isAssignableFrom(cls)) {
                if ("numPoints".equals(methodName)) {
                    return SpatialNumPointsMethod2.class;
                }
                if ("getDimension".equals(methodName)) {
                    return SpatialDimensionMethod2.class;
                }
                if ("getSrid".equals(methodName)) {
                    return SpatialSridMethod2.class;
                }
                if ("equals".equals(methodName)) {
                    return SpatialEqualsMethod2.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }
}

