/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping;

import java.awt.Polygon;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class PolygonMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        super.initialize(mmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.INT_ARRAY);
        this.addColumns(ClassNameConstants.INT_ARRAY);
        this.addColumns(ClassNameConstants.INT);
    }

    public Class getJavaType() {
        return Polygon.class;
    }

    public Object getValueForDatastoreMapping(NucleusContext nucleusCtx, int index, Object value) {
        Polygon poly = (Polygon)value;
        if (index == 0) {
            return poly.xpoints;
        }
        if (index == 1) {
            return poly.ypoints;
        }
        if (index == 2) {
            return poly.npoints;
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        Polygon poly = (Polygon)value;
        if (poly == null) {
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], null);
            this.getDatastoreMapping(1).setObject(ps, exprIndex[1], null);
            this.getDatastoreMapping(2).setObject(ps, exprIndex[2], null);
        } else {
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], (Object)poly.xpoints);
            this.getDatastoreMapping(1).setObject(ps, exprIndex[1], (Object)poly.ypoints);
            this.getDatastoreMapping(2).setInt(ps, exprIndex[2], poly.npoints);
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        int[] xpoints = (int[])this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
        int[] ypoints = (int[])this.getDatastoreMapping(1).getObject(resultSet, exprIndex[1]);
        int npoints = this.getDatastoreMapping(2).getInt(resultSet, exprIndex[2]);
        return new Polygon(xpoints, ypoints, npoints);
    }
}

