/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.expression.GeometryExpression;

public class SpatialNumGeometriesMethod2
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (expr == null && (args == null || args.size() != 1)) {
            throw new NucleusUserException("Cannot invoke Spatial.numGeometries without 1 argument");
        }
        if (expr != null && args != null && args.size() != 0) {
            throw new NucleusUserException("Cannot invoke geom.getNumGeometries() with an argument");
        }
        SQLExpression argExpr = expr;
        if (expr == null) {
            argExpr = (SQLExpression)args.get(0);
        }
        ArrayList<SQLExpression> geomFuncArgs = new ArrayList<SQLExpression>();
        geomFuncArgs.add(argExpr);
        GeometryExpression geomExpr = new GeometryExpression(this.stmt, null, "geometry.from_sdo_geom", geomFuncArgs, null);
        ArrayList<GeometryExpression> treatFuncArgs = new ArrayList<GeometryExpression>();
        treatFuncArgs.add(geomExpr);
        ArrayList<String> treatFuncTypeArgs = new ArrayList<String>();
        treatFuncTypeArgs.add("GeometryCollection");
        GeometryExpression treatExpr = new GeometryExpression(this.stmt, null, "treat", treatFuncArgs, treatFuncTypeArgs);
        ArrayList<GeometryExpression> funcArgs = new ArrayList<GeometryExpression>();
        funcArgs.add(treatExpr);
        JavaTypeMapping m = this.getMappingForClass(Integer.TYPE);
        return new NumericExpression(this.stmt, m, "numGeometries", funcArgs);
    }
}

