/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping.jts2oracle;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.oracle.OraReader;
import com.vividsolutions.jts.io.oracle.OraWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.sql.STRUCT;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class GeometryRDBMSMapping
extends AbstractDatastoreMapping {
    public GeometryRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public SQLTypeInfo getTypeInfo() {
        return this.storeMgr.getSQLTypeInfoForJDBCType(-123);
    }

    public Object getObject(ResultSet rs, int exprIndex) {
        Geometry value;
        try {
            Object st = rs.getObject(exprIndex);
            value = rs.wasNull() || st == null ? null : new OraReader().read((STRUCT)st);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("getObject", exprIndex, e), (Throwable)e);
        }
        return value;
    }

    public void setObject(PreparedStatement ps, int exprIndex, Object value) {
        try {
            if (value == null) {
                ps.setNull(exprIndex, this.getTypeInfo().getDataType(), this.getTypeInfo().getTypeName());
            } else {
                OracleConnection conn = (OracleConnection)ps.getConnection();
                STRUCT obj = new OraWriter(conn).write((Geometry)value);
                ps.setObject(exprIndex, obj);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("setObject", value, e), (Throwable)e);
        }
    }
}

