/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.converters;

import java.awt.Polygon;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class PolygonStringConverter
implements TypeConverter<Polygon, String> {
    public Polygon toMemberType(String str) {
        int y;
        int x;
        if (str == null) {
            return null;
        }
        Polygon p = new Polygon();
        if (str.length() <= 2) {
            return p;
        }
        String tmpStr = str.substring(1, str.length() - 1);
        StringTokenizer tokeniser = new StringTokenizer(tmpStr.substring(1, tmpStr.length() - 1), "(");
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            token = token.substring(0, token.indexOf(")"));
            String xStr = token.substring(0, token.indexOf(","));
            String yStr = token.substring(token.indexOf(",") + 1);
            x = 0;
            y = 0;
            try {
                x = Integer.valueOf(xStr);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Polygon.class.getName()), (Throwable)nfe);
            }
            try {
                y = Integer.valueOf(yStr);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Polygon.class.getName()), (Throwable)nfe);
            }
        }
        return null;
        p.addPoint(x, y);
        return p;
    }

    public String toDatastoreType(Polygon poly) {
        if (poly == null) {
            return null;
        }
        StringBuffer str = new StringBuffer("[");
        for (int i = 0; i < poly.npoints; ++i) {
            str.append("(").append(poly.xpoints[i]).append(",").append(poly.ypoints[i]).append(")");
            if (i >= poly.npoints - 1) continue;
            str.append(",");
        }
        str.append("]");
        return str.toString();
    }
}

