/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.converters;

import java.awt.geom.Point2D;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class Point2dDoubleStringConverter
implements TypeConverter<Point2D.Double, String> {
    public Point2D.Double toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Point2D.Double p = new Point2D.Double();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        double x = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = Double.valueOf(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Point2D.Double.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        double y = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = Double.valueOf(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Point2D.Double.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        p.setLocation(x, y);
        return p;
    }

    public String toDatastoreType(Point2D.Double p) {
        return p != null ? "(" + p.getX() + "," + p.getY() + ")" : null;
    }
}

