/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.awt.geom.Line2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class Line2dFloatMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return Line2D.Float.class;
    }

    public Object getValueForDatastoreMapping(NucleusContext nucleusCtx, int index, Object value) {
        Line2D.Float line = (Line2D.Float)value;
        if (index == 0) {
            return line.getX1();
        }
        if (index == 1) {
            return line.getY1();
        }
        if (index == 2) {
            return line.getX2();
        }
        if (index == 3) {
            return line.getY2();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        Line2D.Float line = (Line2D.Float)value;
        if (line == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getDatastoreMapping(i).setObject(ps, exprIndex[i], null);
            }
        } else {
            this.getDatastoreMapping(0).setFloat(ps, exprIndex[0], line.x1);
            this.getDatastoreMapping(1).setFloat(ps, exprIndex[1], line.y1);
            this.getDatastoreMapping(2).setFloat(ps, exprIndex[2], line.x2);
            this.getDatastoreMapping(3).setFloat(ps, exprIndex[3], line.y2);
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        float x1 = this.getDatastoreMapping(0).getFloat(resultSet, exprIndex[0]);
        float y1 = this.getDatastoreMapping(1).getFloat(resultSet, exprIndex[1]);
        float x2 = this.getDatastoreMapping(2).getFloat(resultSet, exprIndex[2]);
        float y2 = this.getDatastoreMapping(3).getFloat(resultSet, exprIndex[3]);
        return new Line2D.Float(x1, y1, x2, y2);
    }
}

