/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.valuegenerator.AUIDGenerator;
import org.datanucleus.store.valuegenerator.AbstractConnectedGenerator;
import org.datanucleus.store.valuegenerator.AbstractGenerator;
import org.datanucleus.store.valuegenerator.TimestampGenerator;
import org.datanucleus.store.valuegenerator.TimestampValueGenerator;
import org.datanucleus.store.valuegenerator.UUIDGenerator;
import org.datanucleus.store.valuegenerator.UUIDHexGenerator;
import org.datanucleus.store.valuegenerator.UUIDObjectGenerator;
import org.datanucleus.store.valuegenerator.UUIDStringGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ValueGenerationManagerImpl
implements ValueGenerationManager {
    protected final StoreManager storeMgr;
    protected Map<String, ValueGenerator> generatorsByMemberKey = new ConcurrentHashMap<String, ValueGenerator>();
    protected Map<String, ValueGenerator> uniqueGeneratorsByName = new ConcurrentHashMap<String, ValueGenerator>();

    public ValueGenerationManagerImpl(StoreManager storeMgr) {
        this.storeMgr = storeMgr;
        ValueGenerator<Timestamp> generator = new TimestampGenerator(storeMgr, "timestamp");
        this.uniqueGeneratorsByName.put("timestamp", generator);
        generator = new TimestampValueGenerator(storeMgr, "timestamp-value");
        this.uniqueGeneratorsByName.put("timestamp-value", generator);
        generator = new AUIDGenerator(storeMgr, "timestamp-value");
        this.uniqueGeneratorsByName.put("auid", generator);
        generator = new UUIDGenerator(storeMgr, "uuid");
        this.uniqueGeneratorsByName.put("uuid", generator);
        generator = new UUIDObjectGenerator(storeMgr, "uuid-object");
        this.uniqueGeneratorsByName.put("uuid-object", generator);
        generator = new UUIDHexGenerator(storeMgr, "uuid-hex");
        this.uniqueGeneratorsByName.put("uuid-hex", generator);
        generator = new UUIDStringGenerator(storeMgr, "uuid-string");
        this.uniqueGeneratorsByName.put("uuid-string", generator);
        try {
            ConfigurationElement[] elems = storeMgr.getNucleusContext().getPluginManager().getConfigurationElementsForExtension("org.datanucleus.store_valuegenerator", "unique", "true");
            if (elems != null) {
                for (ConfigurationElement elem : elems) {
                    String valueGeneratorName = elem.getAttribute("name");
                    generator = (ValueGenerator)storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{elem.getName(), "true"}, "class-name", new Class[]{StoreManager.class, String.class}, new Object[]{storeMgr, valueGeneratorName});
                    this.uniqueGeneratorsByName.put(valueGeneratorName, generator);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void clear() {
        this.generatorsByMemberKey.clear();
        this.uniqueGeneratorsByName.clear();
    }

    @Override
    public ValueGenerator getValueGeneratorForMemberKey(String memberKey) {
        return this.generatorsByMemberKey.get(memberKey);
    }

    @Override
    public void registerValueGeneratorForMemberKey(String memberKey, ValueGenerator generator) {
        this.generatorsByMemberKey.put(memberKey, generator);
    }

    @Override
    public ValueGenerator getUniqueValueGeneratorByName(String name) {
        return this.uniqueGeneratorsByName.get(name);
    }

    @Override
    public String getMemberKey(AbstractClassMetaData cmd) {
        return cmd.getFullClassName() + " (datastore id)";
    }

    @Override
    public String getMemberKey(AbstractMemberMetaData mmd) {
        return mmd.getFullFieldName();
    }

    @Override
    public Class getTypeForValueGeneratorForMember(String strategyName, String memberKey) {
        Class<?> generatorClass = null;
        ValueGenerator generator = this.generatorsByMemberKey.get(memberKey);
        if (generator == null) {
            generator = this.uniqueGeneratorsByName.get(strategyName);
        }
        if (generator != null) {
            generatorClass = generator.getClass();
        } else {
            try {
                ConfigurationElement elem = this.storeMgr.getNucleusContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeMgr.getStoreManagerKey()});
                generatorClass = elem != null ? this.storeMgr.getNucleusContext().getPluginManager().loadClass(elem.getExtension().getPlugin().getSymbolicName(), elem.getAttribute("class-name")) : null;
            }
            catch (Exception elem) {
                // empty catch block
            }
        }
        if (generatorClass != null) {
            Class valueGeneratedType;
            block8: {
                valueGeneratedType = null;
                try {
                    valueGeneratedType = (Class)generatorClass.getMethod("getStorageClass", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    if (!(generatorClass.getGenericSuperclass() instanceof ParameterizedType)) break block8;
                    ParameterizedType parameterizedType = (ParameterizedType)generatorClass.getGenericSuperclass();
                    valueGeneratedType = (Class)parameterizedType.getActualTypeArguments()[0];
                }
            }
            return valueGeneratedType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueGenerator createAndRegisterValueGenerator(String memberKey, String strategyName, Properties props) {
        AbstractGenerator generator = null;
        ValueGenerationManagerImpl valueGenerationManagerImpl = this;
        synchronized (valueGenerationManagerImpl) {
            try {
                generator = (AbstractGenerator)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeMgr.getStoreManagerKey()}, "class-name", new Class[]{StoreManager.class, String.class, Properties.class}, new Object[]{this.storeMgr, memberKey, props});
                this.registerValueGeneratorForMemberKey(memberKey, generator);
            }
            catch (Exception e) {
                NucleusLogger.VALUEGENERATION.error("Exception thrown trying to create value generator for strategy=" + strategyName + " datastore=" + this.storeMgr.getStoreManagerKey(), e);
            }
        }
        return generator;
    }

    @Override
    public boolean supportsStrategy(String strategy) {
        if (StringUtils.isWhitespace(strategy)) {
            return false;
        }
        if ("timestamp".equalsIgnoreCase(strategy) || "timestamp-value".equalsIgnoreCase(strategy) || "auid".equalsIgnoreCase(strategy) || "uuid".equalsIgnoreCase(strategy) || "uuid-object".equalsIgnoreCase(strategy) || "uuid-hex".equalsIgnoreCase(strategy) || "uuid-string".equalsIgnoreCase(strategy)) {
            return true;
        }
        PluginManager pluginMgr = this.storeMgr.getNucleusContext().getPluginManager();
        ConfigurationElement elem = pluginMgr.getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategy, "true"});
        if (elem != null) {
            return true;
        }
        elem = pluginMgr.getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategy, this.storeMgr.getStoreManagerKey()});
        return elem != null;
    }

    @Override
    public ValueGenerator createValueGenerator(String strategyName, String seqName, Properties props, ValueGenerationConnectionProvider connectionProvider) {
        ValueGenerator generator;
        Class generatorClass;
        PluginManager pluginMgr = this.storeMgr.getNucleusContext().getPluginManager();
        ConfigurationElement elem = pluginMgr.getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeMgr.getStoreManagerKey()});
        Class clazz = generatorClass = elem != null ? pluginMgr.loadClass(elem.getExtension().getPlugin().getSymbolicName(), elem.getAttribute("class-name")) : null;
        if (generatorClass == null) {
            throw new NucleusException("Cannot create ValueGenerator for strategy " + seqName);
        }
        try {
            if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                NucleusLogger.VALUEGENERATION.debug(Localiser.msg("040001", generatorClass.getName(), seqName));
            }
            Class[] argTypes = new Class[]{StoreManager.class, String.class, Properties.class};
            Object[] args = new Object[]{this.storeMgr, seqName, props};
            Constructor ctor = generatorClass.getConstructor(argTypes);
            generator = (ValueGenerator)ctor.newInstance(args);
        }
        catch (Exception e) {
            NucleusLogger.VALUEGENERATION.error(e);
            throw new ValueGenerationException(Localiser.msg("040000", generatorClass.getName(), e), e);
        }
        if (generator instanceof AbstractConnectedGenerator) {
            ((AbstractConnectedGenerator)generator).setConnectionProvider(connectionProvider);
        }
        return generator;
    }
}

