/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.datanucleus.FetchPlanState;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.flush.ListAddAtOperation;
import org.datanucleus.flush.ListRemoveAtOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.types.SCOList;
import org.datanucleus.store.types.SCOListIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ArrayList<E>
extends java.util.ArrayList<E>
implements SCOList<java.util.ArrayList<E>, E> {
    protected transient DNStateManager ownerSM;
    protected transient AbstractMemberMetaData ownerMmd;
    protected java.util.ArrayList<E> delegate;
    protected boolean sorting = false;

    public ArrayList(DNStateManager sm, AbstractMemberMetaData mmd) {
        this.ownerSM = sm;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise(java.util.ArrayList<E> newValue, Object oldValue) {
        this.initialise(newValue);
    }

    @Override
    public void initialise(java.util.ArrayList c) {
        this.delegate = c != null ? c : new java.util.ArrayList();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("023003", this.getClass().getName(), this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + this.size(), SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    @Override
    public void initialise() {
        this.initialise(null);
    }

    @Override
    public java.util.ArrayList<E> getValue() {
        return this.delegate;
    }

    @Override
    public void setValue(java.util.ArrayList<E> value) {
        this.delegate = value;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public void updateEmbeddedElement(E element, int fieldNumber, Object value, boolean makeDirty) {
        if (makeDirty) {
            this.makeDirty();
        }
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    @Override
    public Object getOwner() {
        return this.ownerSM != null ? this.ownerSM.getObject() : null;
    }

    @Override
    public void unsetOwner() {
        if (this.ownerSM != null) {
            this.ownerSM = null;
            this.ownerMmd = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
        }
    }

    @Override
    public java.util.ArrayList detachCopy(FetchPlanState state) {
        java.util.ArrayList detached = new java.util.ArrayList();
        SCOUtils.detachCopyForCollection(this.ownerSM.getExecutionContext(), this.toArray(), state, detached);
        return detached;
    }

    @Override
    public void attachCopy(java.util.ArrayList value) {
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(this.ownerMmd);
        java.util.ArrayList attachedElements = new java.util.ArrayList(value.size());
        SCOUtils.attachCopyForCollection(this.ownerSM, value.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.updateListWithListElements(this, attachedElements);
    }

    @Override
    public Object clone() {
        return this.delegate.clone();
    }

    @Override
    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object element) {
        return this.delegate.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return new SCOListIterator<E>(this, this.ownerSM, this.delegate, null, true, -1);
    }

    @Override
    public ListIterator listIterator() {
        return new SCOListIterator<E>(this, this.ownerSM, this.delegate, null, true, -1);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new SCOListIterator<E>(this, this.ownerSM, this.delegate, null, true, index);
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.delegate.lastIndexOf(element);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<E> subList(int from, int to) {
        return this.delegate.subList(from, to);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public void add(int index, E element) {
        this.delegate.add(index, element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
            this.ownerSM.getExecutionContext().addOperationToQueue(new ListAddAtOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), index, element));
        }
        this.makeDirty();
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public boolean add(E element) {
        boolean success = this.delegate.add(element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), element));
            }
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (Object elem : elements) {
                relMgr.relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (Object element : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), element));
                }
            }
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean addAll(int index, Collection elements) {
        boolean success = this.delegate.addAll(index, elements);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (Object elem : elements) {
                relMgr.relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                int pos = index;
                for (Object element : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new ListAddAtOperation(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), pos++, element));
                }
            }
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public void clear() {
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (E elem : this.delegate) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        if (this.ownerSM != null && !this.delegate.isEmpty()) {
            Iterator iter;
            java.util.ArrayList<E> copy;
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                copy = new java.util.ArrayList<E>(this.delegate);
                iter = copy.iterator();
                while (iter.hasNext()) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), iter.next(), true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                copy = new java.util.ArrayList<E>(this.delegate);
                iter = copy.iterator();
                while (iter.hasNext()) {
                    this.ownerSM.getExecutionContext().deleteObjectInternal(iter.next());
                }
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (this.ownerSM != null && allowCascadeDelete) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation<Object>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), element, allowCascadeDelete));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(element);
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public E remove(int index) {
        E element = this.delegate.remove(index);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (this.ownerSM != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new ListRemoveAtOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), index, element));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(element);
            }
        }
        this.makeDirty();
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return element;
    }

    @Override
    public boolean removeAll(Collection elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.isEmpty()) {
            return true;
        }
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerSM != null) {
            if (this.ownerSM.getExecutionContext().getManageRelations()) {
                RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
                for (Object elem : elements) {
                    relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), elem);
                }
            }
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (Object elem : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), elem, true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                for (Object elem : elements) {
                    this.ownerSM.getExecutionContext().deleteObjectInternal(elem);
                }
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public E set(int index, E element, boolean allowDependentField) {
        E prevElement = this.delegate.set(index, element);
        if (this.ownerSM != null && allowDependentField && !this.delegate.contains(prevElement)) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new ListRemoveAtOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), index, prevElement));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(prevElement);
            }
        }
        this.makeDirty();
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return prevElement;
    }

    @Override
    public E set(int index, E element) {
        return this.set(index, element, !this.sorting);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.ArrayList<E>(this.delegate);
    }

    @Override
    public Stream stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream parallelStream() {
        return this.delegate.parallelStream();
    }

    @Override
    public void trimToSize() {
        this.delegate.trimToSize();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.delegate.ensureCapacity(minCapacity);
    }

    @Override
    public void forEach(Consumer action) {
        this.delegate.forEach(action);
    }

    @Override
    public Spliterator spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public void sort(Comparator<? super E> comp) {
        this.sorting = true;
        super.sort(comp);
        this.sorting = false;
    }
}

