/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema;

import java.util.Properties;
import java.util.Set;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.schema.StoreSchemaData;
import org.datanucleus.store.schema.StoreSchemaHandler;

public abstract class AbstractStoreSchemaHandler
implements StoreSchemaHandler {
    protected StoreManager storeMgr;
    protected boolean autoCreateDatabase;
    protected boolean autoCreateTables;
    protected boolean autoCreateColumns;
    protected boolean autoCreateConstraints;
    protected final boolean autoCreateWarnOnError;
    protected final boolean autoDeleteColumns;
    protected final boolean validateTables;
    protected final boolean validateColumns;
    protected final boolean validateConstraints;

    public AbstractStoreSchemaHandler(StoreManager storeMgr) {
        this.storeMgr = storeMgr;
        this.resetSchemaGeneration();
        this.autoCreateWarnOnError = storeMgr.getBooleanProperty("datanucleus.schema.autoCreateWarnOnError");
        this.autoDeleteColumns = storeMgr.getBooleanProperty("datanucleus.schema.autoDeleteColumns");
        boolean validateAll = storeMgr.getBooleanProperty("datanucleus.schema.validateAll");
        if (validateAll) {
            this.validateTables = true;
            this.validateColumns = true;
            this.validateConstraints = true;
        } else {
            this.validateTables = storeMgr.getBooleanProperty("datanucleus.schema.validateTables");
            this.validateColumns = !this.validateTables ? false : storeMgr.getBooleanProperty("datanucleus.schema.validateColumns");
            this.validateConstraints = storeMgr.getBooleanProperty("datanucleus.schema.validateConstraints");
        }
    }

    @Override
    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    @Override
    public boolean isAutoCreateDatabase() {
        return this.autoCreateDatabase;
    }

    @Override
    public boolean isAutoCreateTables() {
        return this.autoCreateTables;
    }

    @Override
    public boolean isAutoCreateColumns() {
        return this.autoCreateColumns;
    }

    @Override
    public boolean isAutoCreateConstraints() {
        return this.autoCreateConstraints;
    }

    @Override
    public boolean isAutoCreateWarnOnError() {
        return this.autoCreateWarnOnError;
    }

    @Override
    public boolean isAutoDeleteColumns() {
        return this.autoDeleteColumns;
    }

    @Override
    public boolean isValidateTables() {
        return this.validateTables;
    }

    @Override
    public boolean isValidateColumns() {
        return this.validateColumns;
    }

    @Override
    public boolean isValidateConstraints() {
        return this.validateConstraints;
    }

    @Override
    public void clear() {
    }

    @Override
    public void createDatabase(String catalogName, String schemaName, Properties props, Object connection) {
        throw new UnsupportedOperationException("This datastore doesn't support creation of database");
    }

    @Override
    public void deleteDatabase(String catalogName, String schemaName, Properties props, Object connection) {
        throw new UnsupportedOperationException("This datastore doesn't support deletion of database");
    }

    @Override
    public void createSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        throw new UnsupportedOperationException("This datastore doesn't support creation of schema for classes");
    }

    @Override
    public void deleteSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        throw new UnsupportedOperationException("This datastore doesn't support deletion of schema for classes");
    }

    @Override
    public void validateSchema(Set<String> classNames, Properties props, Object connection) {
        throw new UnsupportedOperationException("This datastore doesn't support validation of schema");
    }

    @Override
    public StoreSchemaData getSchemaData(Object connection, String name, Object[] values) {
        return null;
    }

    @Override
    public void enableSchemaGeneration() {
        this.autoCreateDatabase = true;
        this.autoCreateTables = true;
        this.autoCreateColumns = true;
        this.autoCreateConstraints = true;
    }

    @Override
    public void resetSchemaGeneration() {
        boolean readOnlyDatastore = this.storeMgr.getBooleanProperty("datanucleus.readOnlyDatastore");
        if (readOnlyDatastore) {
            this.autoCreateDatabase = false;
            this.autoCreateTables = false;
            this.autoCreateColumns = false;
            this.autoCreateConstraints = false;
        } else {
            boolean autoCreateAll = this.storeMgr.getBooleanProperty("datanucleus.schema.autoCreateAll");
            if (autoCreateAll) {
                this.autoCreateDatabase = true;
                this.autoCreateTables = true;
                this.autoCreateColumns = true;
                this.autoCreateConstraints = true;
            } else {
                this.autoCreateDatabase = this.storeMgr.getBooleanProperty("datanucleus.schema.autoCreateDatabase");
                this.autoCreateTables = this.storeMgr.getBooleanProperty("datanucleus.schema.autoCreateTables");
                this.autoCreateColumns = this.storeMgr.getBooleanProperty("datanucleus.schema.autoCreateColumns");
                this.autoCreateConstraints = this.storeMgr.getBooleanProperty("datanucleus.schema.autoCreateConstraints");
            }
        }
    }
}

