/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.autostart;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.DatastoreInitialisationException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.autostart.AutoStartMechanism;
import org.datanucleus.store.autostart.ClassesAutoStarter;
import org.datanucleus.store.autostart.MetaDataAutoStarter;
import org.datanucleus.store.autostart.XMLAutoStarter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class AutoStartMechanismUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AutoStartMechanism createAutoStartMechanism(PersistenceNucleusContext nucCtx, ClassLoaderResolver clr, String mechanism, String mode) throws DatastoreInitialisationException {
        AutoStartMechanism starter = null;
        StoreManager storeMgr = nucCtx.getStoreManager();
        PluginManager pluginMgr = nucCtx.getPluginManager();
        if ("Classes".equalsIgnoreCase(mechanism)) {
            starter = new ClassesAutoStarter(storeMgr, clr);
        } else {
            if ("XML".equalsIgnoreCase(mechanism)) {
                try {
                    starter = new XMLAutoStarter(storeMgr, clr);
                }
                catch (MalformedURLException mue) {
                    NucleusLogger.PERSISTENCE.warn("Unable to create XML AutoStarter due to ", mue);
                    return null;
                }
            }
            if ("MetaData".equalsIgnoreCase(mechanism)) {
                starter = new MetaDataAutoStarter(storeMgr, clr);
            } else {
                String autoStarterClassName = pluginMgr.getAttributeValueForExtension("org.datanucleus.autostart", "name", mechanism, "class-name");
                if (autoStarterClassName != null) {
                    Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.CLASS_LOADER_RESOLVER};
                    Object[] args = new Object[]{storeMgr, clr};
                    try {
                        starter = (AutoStartMechanism)pluginMgr.createExecutableExtension("org.datanucleus.autostart", "name", mechanism, "class-name", argsClass, args);
                    }
                    catch (Exception e) {
                        NucleusLogger.PERSISTENCE.error(StringUtils.getStringFromStackTrace(e));
                    }
                }
            }
        }
        if (starter == null) {
            return null;
        }
        if (mode.equalsIgnoreCase("None")) {
            starter.setMode(AutoStartMechanism.Mode.NONE);
        } else if (mode.equalsIgnoreCase("Checked")) {
            starter.setMode(AutoStartMechanism.Mode.CHECKED);
        } else if (mode.equalsIgnoreCase("Quiet")) {
            starter.setMode(AutoStartMechanism.Mode.QUIET);
        } else if (mode.equalsIgnoreCase("Ignored")) {
            starter.setMode(AutoStartMechanism.Mode.IGNORED);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("034005", mechanism));
        }
        boolean illegalState = false;
        try {
            Collection<StoreData> existingData;
            if (!starter.isOpen()) {
                starter.open();
            }
            if ((existingData = starter.getAllClassData()) != null && !existingData.isEmpty()) {
                ArrayList<String> classesNeedingAdding = new ArrayList<String>();
                for (StoreData data : existingData) {
                    Class classFound;
                    block41: {
                        if (!data.isFCO()) continue;
                        classFound = null;
                        try {
                            classFound = clr.classForName(data.getName());
                        }
                        catch (ClassNotResolvedException cnre) {
                            if (data.getInterfaceName() == null) break block41;
                            try {
                                nucCtx.getImplementationCreator().newInstance(clr.classForName(data.getInterfaceName()), clr);
                                classFound = clr.classForName(data.getName());
                            }
                            catch (ClassNotResolvedException classNotResolvedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (classFound != null) {
                        NucleusLogger.PERSISTENCE.info(Localiser.msg("032003", data.getName()));
                        classesNeedingAdding.add(data.getName());
                        if (data.getMetaData() != null) continue;
                        AbstractClassMetaData acmd = nucCtx.getMetaDataManager().getMetaDataForClass(classFound, clr);
                        if (acmd != null) {
                            data.setMetaData(acmd);
                            continue;
                        }
                        String msg = Localiser.msg("034004", data.getName());
                        if (starter.getMode() == AutoStartMechanism.Mode.CHECKED) {
                            NucleusLogger.PERSISTENCE.error(msg);
                            throw new DatastoreInitialisationException(msg);
                        }
                        if (starter.getMode() == AutoStartMechanism.Mode.IGNORED) {
                            NucleusLogger.PERSISTENCE.warn(msg);
                            continue;
                        }
                        if (starter.getMode() != AutoStartMechanism.Mode.QUIET) continue;
                        NucleusLogger.PERSISTENCE.warn(msg);
                        NucleusLogger.PERSISTENCE.warn(Localiser.msg("034001", data.getName()));
                        starter.deleteClass(data.getName());
                        continue;
                    }
                    String msg = Localiser.msg("034000", data.getName());
                    if (starter.getMode() == AutoStartMechanism.Mode.CHECKED) {
                        NucleusLogger.PERSISTENCE.error(msg);
                        throw new DatastoreInitialisationException(msg);
                    }
                    if (starter.getMode() == AutoStartMechanism.Mode.IGNORED) {
                        NucleusLogger.PERSISTENCE.warn(msg);
                        continue;
                    }
                    if (starter.getMode() != AutoStartMechanism.Mode.QUIET) continue;
                    NucleusLogger.PERSISTENCE.warn(msg);
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("034001", data.getName()));
                    starter.deleteClass(data.getName());
                }
                String[] classesToLoad = new String[classesNeedingAdding.size()];
                Iterator classesNeedingAddingIter = classesNeedingAdding.iterator();
                int n = 0;
                while (classesNeedingAddingIter.hasNext()) {
                    classesToLoad[n++] = (String)classesNeedingAddingIter.next();
                }
                try {
                    storeMgr.manageClasses(clr, classesToLoad);
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("034002", e));
                    illegalState = true;
                }
            }
            if (starter.isOpen()) {
                starter.close();
            }
            if (illegalState) {
                NucleusLogger.PERSISTENCE.warn(Localiser.msg("034003"));
                starter = null;
            }
            if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) return starter;
        }
        catch (Throwable throwable) {
            if (starter.isOpen()) {
                starter.close();
            }
            if (illegalState) {
                NucleusLogger.PERSISTENCE.warn(Localiser.msg("034003"));
                starter = null;
            }
            if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) throw throwable;
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("034006", mechanism));
            throw throwable;
        }
        NucleusLogger.PERSISTENCE.debug(Localiser.msg("034006", mechanism));
        return starter;
    }
}

