/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.datanucleus.ExecutionContextImpl;
import org.datanucleus.FetchPlanState;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.query.Extent;

public class ExecutionContextThreadedImpl
extends ExecutionContextImpl {
    protected Lock lock;
    int lockCounter = 0;

    public ExecutionContextThreadedImpl(PersistenceNucleusContext ctx, Object owner, Map<String, Object> options) {
        super(ctx, owner, options);
    }

    protected final Lock getLock() {
        if (this.lock == null) {
            this.lock = new ReentrantLock();
        }
        return this.lock;
    }

    @Override
    public synchronized void threadLock() {
        if (this.lockCounter == 0) {
            this.getLock().lock();
        }
        ++this.lockCounter;
    }

    @Override
    public synchronized void threadUnlock() {
        --this.lockCounter;
        if (this.lockCounter == 0) {
            this.getLock().unlock();
        }
    }

    @Override
    public boolean getMultithreaded() {
        return true;
    }

    @Override
    public void processNontransactionalUpdate() {
        try {
            this.getLock().lock();
            super.processNontransactionalUpdate();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void enlistInTransaction(DNStateManager sm) {
        try {
            this.getLock().lock();
            super.enlistInTransaction(sm);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void evictFromTransaction(DNStateManager sm) {
        try {
            this.getLock().lock();
            super.evictFromTransaction(sm);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void addStateManagerToCache(DNStateManager sm) {
        try {
            this.getLock().lock();
            super.addStateManagerToCache(sm);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void removeStateManagerFromCache(DNStateManager sm) {
        try {
            this.getLock().lock();
            super.removeStateManagerFromCache(sm);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public DNStateManager findStateManager(Object pc) {
        try {
            this.getLock().lock();
            DNStateManager dNStateManager = super.findStateManager(pc);
            return dNStateManager;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.getLock().lock();
            super.close();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void evictObject(Object obj) {
        try {
            this.getLock().lock();
            super.evictObject(obj);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void refreshObject(Object obj) {
        try {
            this.getLock().lock();
            super.refreshObject(obj);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void retrieveObjects(boolean useFetchPlan, Object ... pcs) {
        try {
            this.getLock().lock();
            super.retrieveObjects(useFetchPlan, pcs);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object persistObject(Object obj, boolean merging) {
        try {
            this.getLock().lock();
            Object object = super.persistObject(obj, merging);
            return object;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public Object[] persistObjects(Object ... objs) {
        try {
            this.getLock().lock();
            Object[] objectArray = super.persistObjects(objs);
            return objectArray;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void deleteObject(Object obj) {
        try {
            this.getLock().lock();
            super.deleteObject(obj);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void deleteObjects(Object ... objs) {
        try {
            this.getLock().lock();
            super.deleteObjects(objs);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void makeObjectTransient(Object obj, FetchPlanState state) {
        try {
            this.getLock().lock();
            super.makeObjectTransient(obj, state);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void makeObjectTransactional(Object obj) {
        try {
            this.getLock().lock();
            super.makeObjectTransactional(obj);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachObject(DNStateManager ownerSM, Object pc, boolean sco) {
        try {
            this.getLock().lock();
            super.attachObject(ownerSM, pc, sco);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attachObjectCopy(DNStateManager ownerSM, Object pc, boolean sco) {
        try {
            this.getLock().lock();
            Object object = super.attachObjectCopy(ownerSM, pc, sco);
            return object;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void detachObject(FetchPlanState state, Object obj) {
        try {
            this.getLock().lock();
            super.detachObject(state, obj);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void detachObjects(FetchPlanState state, Object ... objs) {
        try {
            this.getLock().lock();
            super.detachObjects(state, objs);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detachObjectCopy(Object pc, FetchPlanState state) {
        try {
            this.getLock().lock();
            Object object = super.detachObjectCopy(state, pc);
            return object;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void clearDirty(DNStateManager sm) {
        try {
            this.getLock().lock();
            super.clearDirty(sm);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void clearDirty() {
        try {
            this.getLock().lock();
            super.clearDirty();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void evictAllObjects() {
        this.assertIsOpen();
        try {
            this.getLock().lock();
            super.evictAllObjects();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void markDirty(DNStateManager sm, boolean directUpdate) {
        try {
            this.getLock().lock();
            super.markDirty(sm, directUpdate);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void flush() {
        try {
            this.getLock().lock();
            super.flush();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void flushInternal(boolean flushToDatastore) {
        try {
            this.getLock().lock();
            super.flushInternal(flushToDatastore);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceObjectId(Persistable pc, Object oldID, Object newID) {
        try {
            this.getLock().lock();
            super.replaceObjectId(pc, oldID, newID);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extent getExtent(Class pcClass, boolean subclasses) {
        try {
            this.getLock().lock();
            Extent extent = super.getExtent(pcClass, subclasses);
            return extent;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void evictObjects(Class cls, boolean subclasses) {
        try {
            this.getLock().lock();
            super.evictObjects(cls, subclasses);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void refreshAllObjects() {
        try {
            this.getLock().lock();
            super.refreshAllObjects();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public List<DNStateManager> getObjectsToBeFlushed() {
        try {
            this.getLock().lock();
            List<DNStateManager> list = super.getObjectsToBeFlushed();
            return list;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void postBegin() {
        try {
            this.getLock().lock();
            super.postBegin();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void preCommit() {
        try {
            this.getLock().lock();
            super.preCommit();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void postCommit() {
        try {
            this.getLock().lock();
            super.postCommit();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void preRollback() {
        try {
            this.getLock().lock();
            super.preRollback();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void postRollback() {
        try {
            this.getLock().lock();
            super.postRollback();
        }
        finally {
            this.getLock().unlock();
        }
    }
}

