/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers.backed;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionClearOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.SetStore;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Set<E>
extends org.datanucleus.store.types.wrappers.Set<E>
implements BackedSCO {
    protected transient SetStore<E> backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;
    protected transient boolean initialising = false;

    public Set(DNStateManager sm, AbstractMemberMetaData mmd) {
        this(sm, mmd, false, null);
    }

    public Set(DNStateManager ownerSM, AbstractMemberMetaData mmd, boolean allowNulls, SetStore backingStore) {
        super(ownerSM, mmd);
        this.allowNulls = allowNulls;
        this.delegate = new HashSet();
        allowNulls = SCOUtils.allowNullsInContainer(allowNulls, mmd);
        this.useCache = SCOUtils.useContainerCache(ownerSM, mmd);
        if (backingStore != null) {
            this.backingStore = backingStore;
        } else if (!SCOUtils.collectionHasSerialisedElements(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            ClassLoaderResolver clr = ownerSM.getExecutionContext().getClassLoaderResolver();
            this.backingStore = (SetStore)((BackedSCOStoreManager)((Object)ownerSM.getStoreManager())).getBackingStoreForField(clr, mmd, java.util.Set.class);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerSM, this.ownerMmd.getName(), this, this.useCache, allowNulls, SCOUtils.useCachedLazyLoading(ownerSM, this.ownerMmd)));
        }
    }

    @Override
    public void initialise(java.util.Set<E> newValue, Object oldValue) {
        if (newValue != null) {
            Collection oldColl;
            if (SCOUtils.collectionHasSerialisedElements(this.ownerMmd) && this.ownerMmd.getCollection().elementIsPersistent()) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (E pc : newValue) {
                    DNStateManager<E> objSM = ec.findStateManager(pc);
                    if (objSM != null) continue;
                    objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, pc, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023008", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + newValue.size()));
            }
            this.initialising = true;
            if (this.useCache) {
                oldColl = (Collection)oldValue;
                if (oldColl != null) {
                    this.delegate.addAll(oldColl);
                }
                this.isCacheLoaded = true;
                SCOUtils.updateCollectionWithCollection(this.ownerSM.getExecutionContext().getApiAdapter(), this, newValue);
            } else {
                oldColl = (Collection)oldValue;
                if (oldColl instanceof SCOCollection) {
                    oldColl = (Collection)((SCOCollection)((Object)oldColl)).getValue();
                }
                for (E elem : newValue) {
                    if (oldColl != null && oldColl.contains(elem)) continue;
                    this.add(elem);
                }
                if (oldColl != null) {
                    for (E elem : oldColl) {
                        if (newValue.contains(elem)) continue;
                        this.remove(elem);
                    }
                }
            }
            this.initialising = false;
        }
    }

    @Override
    public void initialise(java.util.Set c) {
        if (c != null) {
            if (SCOUtils.collectionHasSerialisedElements(this.ownerMmd) && this.ownerMmd.getCollection().elementIsPersistent()) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (Object pc : c) {
                    DNStateManager objSM = ec.findStateManager(pc);
                    if (objSM != null) continue;
                    objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, pc, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023007", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + c.size()));
            }
            this.delegate.clear();
            this.delegate.addAll(c);
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    @Override
    public java.util.Set getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023006", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName()));
            }
            this.delegate.clear();
            Iterator iter = this.backingStore.iterator(this.ownerSM);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    @Override
    public Store getBackingStore() {
        return this.backingStore;
    }

    @Override
    public void updateEmbeddedElement(E element, int fieldNumber, Object value, boolean makeDirty) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerSM, element, fieldNumber, value);
        }
    }

    @Override
    public void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return ((HashSet)this.delegate).clone();
    }

    @Override
    public boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerSM, element);
        }
        return this.delegate.contains(element);
    }

    @Override
    public boolean containsAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            HashSet h = new HashSet(c);
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                h.remove(iter.next());
            }
            return h.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof java.util.Set)) {
            return false;
        }
        java.util.Set c = (java.util.Set)o;
        return c.size() == this.size() && this.containsAll((Collection)c);
    }

    @Override
    public void forEach(Consumer action) {
        Objects.requireNonNull(action);
        for (E t : this) {
            action.accept(t);
        }
    }

    @Override
    public int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOCollectionIterator<E>(this, this.ownerSM, this.delegate, this.backingStore, this.useCache);
    }

    @Override
    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerSM);
        }
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM);
        }
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM, a);
        }
        return this.delegate.toArray(a);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        int i = 0;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                s.append(',');
            }
            s.append(iter.next());
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    @Override
    public boolean add(E element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.ownerMmd.getName() + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.contains(element)) {
            return false;
        }
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations() && !this.initialising) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.backingStore, element));
            } else {
                try {
                    backingSuccess = this.backingStore.add(this.ownerSM, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    throw new IllegalArgumentException(Localiser.msg("023013", "add", this.ownerMmd.getName(), dse), dse);
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean addAll(Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations() && !this.initialising) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (Object elem : elements) {
                relMgr.relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (Object element : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.backingStore, element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, elements, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    throw new IllegalArgumentException(Localiser.msg("023013", "addAll", this.ownerMmd.getName(), dse), dse);
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(elements);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public void clear() {
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations() && !this.initialising) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (Object elem : this.delegate) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionClearOperation(this.ownerSM, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public boolean remove(Object element, boolean allowCascadeDelete) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean contained = this.delegate.contains(element);
        boolean delegateSuccess = this.delegate.remove(element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations() && !this.initialising) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                backingSuccess = contained;
                if (backingSuccess) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation<Object>(this.ownerSM, this.backingStore, element, allowCascadeDelete));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerSM, element, size, allowCascadeDelete);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "remove", this.ownerMmd.getName(), dse));
                    backingSuccess = false;
                }
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean removeAll(Collection elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.isEmpty()) {
            return true;
        }
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        HashSet contained = null;
        if (this.backingStore != null && SCOUtils.useQueuedUpdate(this.ownerSM)) {
            contained = new HashSet();
            for (Object elem : elements) {
                if (!this.contains(elem)) continue;
                contained.add(elem);
            }
        }
        boolean delegateSuccess = this.delegate.removeAll(elements);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations() && !this.initialising) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (Object elem : elements) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        if (this.backingStore != null && this.ownerSM != null) {
            boolean backingSuccess = false;
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                if (contained != null && !contained.isEmpty()) {
                    backingSuccess = false;
                    for (Object element : contained) {
                        backingSuccess = true;
                        this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation<E>(this.ownerSM, this.backingStore, element, true));
                    }
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerSM, elements, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "removeAll", this.ownerMmd.getName(), dse));
                    backingSuccess = false;
                }
            }
            if (!this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
            return backingSuccess;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return delegateSuccess;
    }

    @Override
    public boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            E element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return modified;
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new HashSet(this.delegate);
        }
        return new HashSet(this.delegate);
    }

    @Override
    public Spliterator spliterator() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.spliterator();
    }

    @Override
    public Stream stream() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.stream();
    }

    @Override
    public Stream parallelStream() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.parallelStream();
    }
}

