/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers.backed;

import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.datanucleus.ExecutionContext;
import org.datanucleus.flush.MapClearOperation;
import org.datanucleus.flush.MapPutOperation;
import org.datanucleus.flush.MapRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.MapStore;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.store.types.wrappers.backed.Collection;
import org.datanucleus.store.types.wrappers.backed.Set;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Map<K, V>
extends org.datanucleus.store.types.wrappers.Map<K, V>
implements BackedSCO {
    protected transient boolean allowNulls = true;
    protected transient MapStore<K, V> backingStore;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;

    public Map(DNStateManager sm, AbstractMemberMetaData mmd) {
        super(sm, mmd);
        this.delegate = new HashMap();
        this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, mmd);
        this.useCache = SCOUtils.useContainerCache(this.ownerSM, mmd);
        if (!SCOUtils.mapHasSerialisedKeysAndValues(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            this.backingStore = (MapStore)((BackedSCOStoreManager)((Object)this.ownerSM.getStoreManager())).getBackingStoreForField(this.ownerSM.getExecutionContext().getClassLoaderResolver(), mmd, java.util.Map.class);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(this.ownerSM, this.ownerMmd.getName(), this, this.useCache, this.allowNulls, SCOUtils.useCachedLazyLoading(this.ownerSM, this.ownerMmd)));
        }
    }

    @Override
    public void initialise(java.util.Map newValue, Object oldValue) {
        if (newValue != null) {
            if (SCOUtils.mapHasSerialisedKeysAndValues(this.ownerMmd) && (this.ownerMmd.getMap().keyIsPersistent() || this.ownerMmd.getMap().valueIsPersistent())) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (Map.Entry entry : newValue.entrySet()) {
                    DNStateManager<Object> objSM;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (this.ownerMmd.getMap().keyIsPersistent() && (objSM = ec.findStateManager(key)) == null) {
                        objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, key, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber());
                    }
                    if (!this.ownerMmd.getMap().valueIsPersistent() || (objSM = ec.findStateManager(value)) != null) continue;
                    objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, value, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023008", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + newValue.size()));
            }
            if (this.useCache) {
                java.util.Map oldMap = (java.util.Map)oldValue;
                if (oldMap != null) {
                    this.delegate.putAll(oldMap);
                }
                this.isCacheLoaded = true;
                SCOUtils.updateMapWithMapKeysValues(this.ownerSM.getExecutionContext().getApiAdapter(), this, newValue);
            } else {
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                        if (this.ownerSM.isFlushedToDatastore() || !this.ownerSM.getLifecycleState().isNew()) {
                            this.ownerSM.getExecutionContext().addOperationToQueue(new MapClearOperation(this.ownerSM, this.backingStore));
                            for (Map.Entry entry : newValue.entrySet()) {
                                this.ownerSM.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerSM, this.backingStore, entry.getKey(), entry.getValue()));
                            }
                        }
                    } else {
                        this.backingStore.clear(this.ownerSM);
                        this.backingStore.putAll(this.ownerSM, newValue, Collections.emptyMap());
                    }
                }
                this.delegate.putAll(newValue);
                this.isCacheLoaded = true;
                this.makeDirty();
            }
        }
    }

    @Override
    public void initialise(java.util.Map m) {
        if (m != null) {
            if (SCOUtils.mapHasSerialisedKeysAndValues(this.ownerMmd) && (this.ownerMmd.getMap().keyIsPersistent() || this.ownerMmd.getMap().valueIsPersistent())) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (Map.Entry entry : m.entrySet()) {
                    DNStateManager<Object> objSM;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (this.ownerMmd.getMap().keyIsPersistent() && (objSM = ec.findStateManager(key)) == null) {
                        objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, key, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber());
                    }
                    if (!this.ownerMmd.getMap().valueIsPersistent() || (objSM = ec.findStateManager(value)) != null) continue;
                    objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, value, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023007", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + m.size()));
            }
            this.delegate.putAll(m);
            this.isCacheLoaded = true;
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    @Override
    public java.util.Map getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023006", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName()));
            }
            this.delegate.clear();
            SCOUtils.populateMapDelegateWithStoreData(this.delegate, this.backingStore, this.ownerSM);
            this.isCacheLoaded = true;
        }
    }

    @Override
    public Store getBackingStore() {
        return this.backingStore;
    }

    @Override
    public void updateEmbeddedKey(K key, int fieldNumber, Object newValue, boolean makeDirty) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedKey(this.ownerSM, key, fieldNumber, newValue);
        }
    }

    @Override
    public void updateEmbeddedValue(V value, int fieldNumber, Object newValue, boolean makeDirty) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedValue(this.ownerSM, value, fieldNumber, newValue);
        }
    }

    @Override
    public void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return ((HashMap)this.delegate).clone();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsKey(key);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsKey(this.ownerSM, key);
        }
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsValue(value);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsValue(this.ownerSM, value);
        }
        return this.delegate.containsValue(value);
    }

    @Override
    public java.util.Set entrySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.ownerMmd, false, this.backingStore.entrySetStore());
        }
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof java.util.Map)) {
            return false;
        }
        java.util.Map m = (java.util.Map)o;
        return this.entrySet().equals(m.entrySet());
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        for (Map.Entry entry : this.entrySet()) {
            Object v;
            Object k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            action.accept(k, v);
        }
    }

    @Override
    public V get(Object key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerSM, key);
        }
        return this.delegate.get(key);
    }

    @Override
    public int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public java.util.Set keySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.ownerMmd, false, this.backingStore.keySetStore());
        }
        return this.delegate.keySet();
    }

    @Override
    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.entrySetStore().size(this.ownerSM);
        }
        return this.delegate.size();
    }

    @Override
    public java.util.Collection values() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Collection(this.ownerSM, this.ownerMmd, true, this.backingStore.valueCollectionStore());
        }
        return this.delegate.values();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("{");
        Iterator i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry e = (Map.Entry)i.next();
            Object key = e.getKey();
            Object val = e.getValue();
            s.append(key).append('=').append(val);
            hasNext = i.hasNext();
            if (!hasNext) continue;
            s.append(',');
        }
        s.append("}");
        return s.toString();
    }

    @Override
    public void clear() {
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new MapClearOperation(this.ownerSM, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public V put(K key, V value) {
        if (!this.allowNulls) {
            if (value == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.ownerMmd.getName() + " but value is null");
            }
            if (key == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.ownerMmd.getName() + " but key is null");
            }
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        this.makeDirty();
        Object oldValue = null;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new MapPutOperation<K, V>(this.ownerSM, this.backingStore, key, value));
            } else if (this.useCache) {
                oldValue = this.delegate.get(key);
                this.backingStore.put(this.ownerSM, key, value, oldValue, this.delegate.containsKey(key));
            } else {
                oldValue = this.backingStore.put(this.ownerSM, key, value);
            }
        }
        V delegateOldValue = this.delegate.put(key, value);
        if (this.backingStore == null) {
            oldValue = delegateOldValue;
        } else if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
            oldValue = delegateOldValue;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return oldValue;
    }

    @Override
    public void putAll(java.util.Map m) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (Map.Entry entry : m.entrySet()) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerSM, this.backingStore, entry.getKey(), entry.getValue()));
                }
            } else if (this.useCache) {
                this.backingStore.putAll(this.ownerSM, m, Collections.unmodifiableMap(this.delegate));
            } else {
                this.backingStore.putAll(this.ownerSM, m);
            }
        }
        this.delegate.putAll(m);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public V remove(Object key) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        V removed = null;
        Object delegateRemoved = this.delegate.remove(key);
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new MapRemoveOperation(this.ownerSM, this.backingStore, key, delegateRemoved));
                removed = delegateRemoved;
            } else if (this.useCache) {
                this.backingStore.remove(this.ownerSM, key, delegateRemoved);
                removed = delegateRemoved;
            } else {
                removed = this.backingStore.remove(this.ownerSM, key);
            }
        } else {
            removed = delegateRemoved;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return removed;
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new HashMap(this.delegate);
        }
        return new HashMap(this.delegate);
    }
}

