/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.containers;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.store.types.containers.ContainerHandler;
import org.datanucleus.store.types.containers.ElementContainerAdapter;

public abstract class ElementContainerHandler<C, A extends ElementContainerAdapter<C>>
implements ContainerHandler<C, A> {
    public abstract C newContainer(AbstractMemberMetaData var1, Object ... var2);

    public abstract int getObjectType(AbstractMemberMetaData var1);

    public String getElementTypeName(ContainerMetaData cmd) {
        if (cmd instanceof CollectionMetaData) {
            return ((CollectionMetaData)cmd).getElementType();
        }
        if (cmd instanceof ArrayMetaData) {
            return ((ArrayMetaData)cmd).getElementType();
        }
        throw new NucleusException("Unable to determine element type name - container metadata not supported");
    }

    protected void moveColumnsToElement(AbstractMemberMetaData mmd) {
        ColumnMetaData[] columnMetaData = mmd.getColumnMetaData();
        if (!mmd.isSerialized() && !mmd.isEmbedded() && columnMetaData != null && mmd.getTypeConverterName() == null && mmd.getElementMetaData() == null) {
            ElementMetaData elemmd = new ElementMetaData();
            mmd.setElementMetaData(elemmd);
            for (int i = 0; i < columnMetaData.length; ++i) {
                elemmd.addColumn(columnMetaData[i]);
            }
            mmd.clearColumns();
        }
    }

    protected void copyMappedByDefinitionFromElement(AbstractMemberMetaData mmd) {
        ElementMetaData elementMetaData = mmd.getElementMetaData();
        if (elementMetaData != null && elementMetaData.getMappedBy() != null && mmd.getMappedBy() == null) {
            mmd.setMappedBy(elementMetaData.getMappedBy());
        }
    }
}

