/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.containers;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.datanucleus.store.types.containers.ElementContainerAdapter;
import org.datanucleus.store.types.containers.SequenceAdapter;

public class ArrayAdapter<C>
extends ElementContainerAdapter<C>
implements SequenceAdapter {
    List<Object> buffer;

    public ArrayAdapter(C container) {
        super(container);
    }

    @Override
    public Iterator<Object> iterator() {
        C container = this.getContainer();
        return container instanceof Object[] ? new ObjectArrayIterator((Object[])container) : new ArrayIterator(container);
    }

    @Override
    public C getContainer() {
        if (this.buffer == null) {
            return (C)this.container;
        }
        Object newArray = Array.newInstance(this.container.getClass().getComponentType(), this.buffer.size());
        for (int i = 0; i < this.buffer.size(); ++i) {
            Object object = this.buffer.get(i);
            Array.set(newArray, i, object);
        }
        return (C)newArray;
    }

    @Override
    public void clear() {
        this.buffer = new ArrayList<Object>();
    }

    @Override
    public void add(Object newElement) {
        this.getBuffer().add(newElement);
    }

    @Override
    public void remove(Object element) {
        this.getBuffer().remove(element);
    }

    private List<Object> getBuffer() {
        if (this.buffer == null) {
            this.buffer = new ArrayList<Object>();
            for (Object object : this) {
                this.buffer.add(object);
            }
        }
        return this.buffer;
    }

    @Override
    public void update(Object newElement, int position) {
        Array.set(this.getContainer(), position, newElement);
    }

    private class ArrayIterator
    implements Iterator {
        protected Object array;
        protected int endIndex = 0;
        protected int index = 0;

        public ArrayIterator(Object array) {
            this.setArray(array);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return Array.get(this.array, this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() method is not supported");
        }

        public void setArray(Object array) {
            this.endIndex = Array.getLength(array);
            this.array = array;
            this.index = 0;
        }
    }

    private final class ObjectArrayIterator
    implements Iterator {
        protected Object[] array = null;
        protected int endIndex = 0;
        protected int index = 0;

        public ObjectArrayIterator(Object[] array) {
            this.array = array;
            this.endIndex = array.length;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() method is not supported for an ObjectArrayIterator");
        }
    }
}

