/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema.table;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.MultitenancyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.SoftDeleteMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.ColumnImpl;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.MemberColumnMappingImpl;
import org.datanucleus.store.schema.table.SchemaVerifier;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CompleteClassTable
implements Table {
    StoreManager storeMgr;
    AbstractClassMetaData cmd;
    String catalogName;
    String schemaName;
    String identifier;
    List<Column> columns = null;
    Column versionColumn;
    Column discriminatorColumn;
    Column datastoreIdColumn;
    Column multitenancyColumn;
    Column softDeleteColumn;
    Map<String, MemberColumnMapping> mappingByMember = new HashMap<String, MemberColumnMapping>();
    Map<String, MemberColumnMapping> mappingByEmbeddedMember = new HashMap<String, MemberColumnMapping>();
    Map<String, Column> columnByName = new HashMap<String, Column>();
    SchemaVerifier schemaVerifier;

    public CompleteClassTable(StoreManager storeMgr, AbstractClassMetaData cmd, SchemaVerifier verifier) {
        SoftDeleteMetaData sdmd;
        MultitenancyMetaData mtmd;
        ColumnImpl col;
        String colName;
        VersionMetaData vermd;
        Object col2;
        this.storeMgr = storeMgr;
        this.cmd = cmd;
        this.schemaVerifier = verifier;
        this.schemaName = cmd.getSchema() != null ? cmd.getSchema() : storeMgr.getStringProperty("datanucleus.mapping.Schema");
        this.catalogName = cmd.getCatalog() != null ? cmd.getCatalog() : storeMgr.getStringProperty("datanucleus.mapping.Catalog");
        this.identifier = storeMgr.getNamingFactory().getTableName(cmd);
        this.columns = new ArrayList<Column>();
        MetaDataManager mmgr = storeMgr.getMetaDataManager();
        TypeManager typeMgr = storeMgr.getNucleusContext().getTypeManager();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        int numMembers = cmd.getAllMemberPositions().length;
        for (int i = 0; i < numMembers; ++i) {
            MemberColumnMappingImpl mapping;
            Column col3;
            String colName2;
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
            if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
            RelationType relationType = mmd.getRelationType(clr);
            if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(mmgr, clr, mmd, relationType, null)) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                if (RelationType.isRelationSingleValued(relationType)) {
                    boolean nested = false;
                    if (storeMgr.getSupportedOptions().contains("ORM.EmbeddedPC.Nested")) {
                        nested = !storeMgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.embedded.flat");
                        String nestedStr = mmd.getValueForExtension("nested");
                        if (nestedStr != null && nestedStr.equalsIgnoreCase("" + !nested)) {
                            boolean bl = nested = !nested;
                        }
                    }
                    if (nested) {
                        ColumnMetaData[] colmds = mmd.getColumnMetaData();
                        String colName3 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                        ColumnImpl col4 = this.addColumn(mmd, colName3, null);
                        if (colmds != null && colmds.length == 1) {
                            col4.setColumnMetaData(colmds[0]);
                            if (colmds[0].getPosition() != null) {
                                col4.setPosition(colmds[0].getPosition());
                            }
                            if (colmds[0].getJdbcType() != null) {
                                col4.setJdbcType(colmds[0].getJdbcType());
                            }
                        }
                        MemberColumnMappingImpl mapping2 = new MemberColumnMappingImpl(mmd, col4);
                        col4.setMemberColumnMapping(mapping2);
                        if (this.schemaVerifier != null) {
                            this.schemaVerifier.attributeMember(mapping2, mmd);
                        }
                        this.mappingByMember.put(mmd.getFullFieldName(), mapping2);
                    }
                    this.processEmbeddedMember(embMmds, mmgr.getMetaDataForClass(mmd.getType(), clr), clr, mmd.getEmbeddedMetaData(), nested);
                    continue;
                }
                if (!RelationType.isRelationMultiValued(relationType)) continue;
                if (mmd.hasCollection()) {
                    if (storeMgr.getSupportedOptions().contains("ORM.EmbeddedCollection.Nested")) {
                        ColumnMetaData[] colmds = mmd.getColumnMetaData();
                        colName2 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                        col3 = this.addColumn(mmd, colName2, null);
                        if (colmds != null && colmds.length == 1) {
                            ((ColumnImpl)col3).setColumnMetaData(colmds[0]);
                            if (colmds[0].getPosition() != null) {
                                ((ColumnImpl)col3).setPosition(colmds[0].getPosition());
                            }
                            if (colmds[0].getJdbcType() != null) {
                                ((ColumnImpl)col3).setJdbcType(colmds[0].getJdbcType());
                            }
                        }
                        mapping = new MemberColumnMappingImpl(mmd, col3);
                        ((ColumnImpl)col3).setMemberColumnMapping(mapping);
                        if (this.schemaVerifier != null) {
                            this.schemaVerifier.attributeMember(mapping, mmd);
                        }
                        this.mappingByMember.put(mmd.getFullFieldName(), mapping);
                        EmbeddedMetaData embmd = mmd.getElementMetaData() != null ? mmd.getElementMetaData().getEmbeddedMetaData() : null;
                        this.processEmbeddedMember(embMmds, mmgr.getMetaDataForClass(mmd.getCollection().getElementType(), clr), clr, embmd, true);
                        continue;
                    }
                    NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded collection. Not supported for this datastore, so ignoring");
                    continue;
                }
                if (mmd.hasMap()) {
                    if (storeMgr.getSupportedOptions().contains("ORM.EmbeddedMap.Nested")) {
                        ColumnMetaData[] colmds = mmd.getColumnMetaData();
                        colName2 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                        col3 = this.addColumn(mmd, colName2, null);
                        if (colmds != null && colmds.length == 1) {
                            ((ColumnImpl)col3).setColumnMetaData(colmds[0]);
                            if (colmds[0].getPosition() != null) {
                                ((ColumnImpl)col3).setPosition(colmds[0].getPosition());
                            }
                            if (colmds[0].getJdbcType() != null) {
                                ((ColumnImpl)col3).setJdbcType(colmds[0].getJdbcType());
                            }
                        }
                        mapping = new MemberColumnMappingImpl(mmd, col3);
                        ((ColumnImpl)col3).setMemberColumnMapping(mapping);
                        if (this.schemaVerifier != null) {
                            this.schemaVerifier.attributeMember(mapping, mmd);
                        }
                        this.mappingByMember.put(mmd.getFullFieldName(), mapping);
                        if (mmd.getMap().keyIsPersistent()) {
                            EmbeddedMetaData embmd = mmd.getKeyMetaData() != null ? mmd.getKeyMetaData().getEmbeddedMetaData() : null;
                            this.processEmbeddedMember(embMmds, mmgr.getMetaDataForClass(mmd.getMap().getKeyType(), clr), clr, embmd, true);
                        }
                        if (!mmd.getMap().valueIsPersistent()) continue;
                        EmbeddedMetaData embmd = mmd.getValueMetaData() != null ? mmd.getValueMetaData().getEmbeddedMetaData() : null;
                        this.processEmbeddedMember(embMmds, mmgr.getMetaDataForClass(mmd.getMap().getValueType(), clr), clr, embmd, true);
                        continue;
                    }
                    NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded map. Not supported for this datastore, so ignoring");
                    continue;
                }
                if (!mmd.hasArray()) continue;
                if (storeMgr.getSupportedOptions().contains("ORM.EmbeddedArray.Nested")) {
                    ColumnMetaData[] colmds = mmd.getColumnMetaData();
                    colName2 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                    col3 = this.addColumn(mmd, colName2, null);
                    if (colmds != null && colmds.length == 1) {
                        ((ColumnImpl)col3).setColumnMetaData(colmds[0]);
                        if (colmds[0].getPosition() != null) {
                            ((ColumnImpl)col3).setPosition(colmds[0].getPosition());
                        }
                        if (colmds[0].getJdbcType() != null) {
                            ((ColumnImpl)col3).setJdbcType(colmds[0].getJdbcType());
                        }
                    }
                    mapping = new MemberColumnMappingImpl(mmd, col3);
                    ((ColumnImpl)col3).setMemberColumnMapping(mapping);
                    if (this.schemaVerifier != null) {
                        this.schemaVerifier.attributeMember(mapping, mmd);
                    }
                    this.mappingByMember.put(mmd.getFullFieldName(), mapping);
                    EmbeddedMetaData embmd = mmd.getElementMetaData() != null ? mmd.getElementMetaData().getEmbeddedMetaData() : null;
                    this.processEmbeddedMember(embMmds, mmgr.getMetaDataForClass(mmd.getArray().getElementType(), clr), clr, embmd, true);
                    continue;
                }
                NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded array. Not supported for this datastore, so ignoring");
                continue;
            }
            ColumnMetaData[] colmds = mmd.getColumnMetaData();
            if ((colmds == null || colmds.length == 0) && mmd.hasCollection() && mmd.getElementMetaData() != null) {
                colmds = mmd.getElementMetaData().getColumnMetaData();
            }
            if (relationType != RelationType.NONE) {
                String colName4 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                col2 = this.addColumn(mmd, colName4, null);
                if (colmds != null && colmds.length == 1) {
                    ((ColumnImpl)col2).setColumnMetaData(colmds[0]);
                    if (colmds[0].getPosition() != null) {
                        ((ColumnImpl)col2).setPosition(colmds[0].getPosition());
                    }
                    if (colmds[0].getJdbcType() != null) {
                        ((ColumnImpl)col2).setJdbcType(colmds[0].getJdbcType());
                    }
                }
                MemberColumnMappingImpl mapping3 = new MemberColumnMappingImpl(mmd, (Column)col2);
                ((ColumnImpl)col2).setMemberColumnMapping(mapping3);
                if (this.schemaVerifier != null) {
                    this.schemaVerifier.attributeMember(mapping3, mmd);
                }
                this.mappingByMember.put(mmd.getFullFieldName(), mapping3);
                continue;
            }
            TypeConverter typeConv = this.getTypeConverterForMember(mmd, colmds, typeMgr);
            if (typeConv != null) {
                if (typeConv instanceof MultiColumnConverter) {
                    Class[] colJavaTypes = ((MultiColumnConverter)((Object)typeConv)).getDatastoreColumnTypes();
                    Column[] cols = new Column[colJavaTypes.length];
                    for (int j = 0; j < colJavaTypes.length; ++j) {
                        String colName5 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, j);
                        ColumnImpl col5 = this.addColumn(mmd, colName5);
                        if (colmds != null && colmds.length == 1) {
                            col5.setColumnMetaData(colmds[0]);
                            if (colmds[j].getPosition() != null) {
                                col5.setPosition(colmds[j].getPosition());
                            }
                            if (colmds[j].getJdbcType() != null) {
                                col5.setJdbcType(colmds[j].getJdbcType());
                            }
                        }
                        cols[j] = col5;
                    }
                    mapping = new MemberColumnMappingImpl(mmd, cols, typeConv);
                    for (int j = 0; j < colJavaTypes.length; ++j) {
                        ((ColumnImpl)cols[j]).setMemberColumnMapping(mapping);
                    }
                    if (this.schemaVerifier != null) {
                        this.schemaVerifier.attributeMember(mapping, mmd);
                    }
                    this.mappingByMember.put(mmd.getFullFieldName(), mapping);
                    continue;
                }
                colName2 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                col3 = this.addColumn(mmd, colName2);
                if (colmds != null && colmds.length == 1) {
                    ((ColumnImpl)col3).setColumnMetaData(colmds[0]);
                    if (colmds[0].getPosition() != null) {
                        ((ColumnImpl)col3).setPosition(colmds[0].getPosition());
                    }
                    if (colmds[0].getJdbcType() != null) {
                        ((ColumnImpl)col3).setJdbcType(colmds[0].getJdbcType());
                    }
                }
                mapping = new MemberColumnMappingImpl(mmd, col3);
                ((ColumnImpl)col3).setMemberColumnMapping(mapping);
                mapping.setTypeConverter(typeConv);
                if (this.schemaVerifier != null) {
                    this.schemaVerifier.attributeMember(mapping, mmd);
                }
                this.mappingByMember.put(mmd.getFullFieldName(), mapping);
                continue;
            }
            colName2 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
            col3 = this.addColumn(mmd, colName2);
            if (colmds != null && colmds.length == 1) {
                ((ColumnImpl)col3).setColumnMetaData(colmds[0]);
                if (colmds[0].getPosition() != null) {
                    ((ColumnImpl)col3).setPosition(colmds[0].getPosition());
                }
                if (colmds[0].getJdbcType() != null) {
                    ((ColumnImpl)col3).setJdbcType(colmds[0].getJdbcType());
                }
            }
            mapping = new MemberColumnMappingImpl(mmd, col3);
            if (mmd.hasCollection()) {
                if (mmd.getElementMetaData() != null && mmd.getElementMetaData().hasExtension("type-converter-name")) {
                    TypeConverter elemConv = typeMgr.getTypeConverterForName(mmd.getElementMetaData().getValueForExtension("type-converter-name"));
                    mapping.setTypeConverterForComponent(FieldRole.ROLE_COLLECTION_ELEMENT, elemConv);
                }
            } else if (mmd.hasMap()) {
                if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().hasExtension("type-converter-name")) {
                    TypeConverter keyConv = typeMgr.getTypeConverterForName(mmd.getKeyMetaData().getValueForExtension("type-converter-name"));
                    mapping.setTypeConverterForComponent(FieldRole.ROLE_MAP_KEY, keyConv);
                }
                if (mmd.getValueMetaData() != null && mmd.getValueMetaData().hasExtension("type-converter-name")) {
                    TypeConverter valConv = typeMgr.getTypeConverterForName(mmd.getValueMetaData().getValueForExtension("type-converter-name"));
                    mapping.setTypeConverterForComponent(FieldRole.ROLE_MAP_VALUE, valConv);
                }
            }
            ((ColumnImpl)col3).setMemberColumnMapping(mapping);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(mapping, mmd);
            }
            this.mappingByMember.put(mmd.getFullFieldName(), mapping);
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            String colName6 = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
            ColumnImpl col6 = this.addColumn(null, colName6, ColumnType.DATASTOREID_COLUMN);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(new MemberColumnMappingImpl(null, col6));
            }
            if (cmd.getDatastoreIdentityMetaData() != null && cmd.getDatastoreIdentityMetaData().getColumnMetaData() != null) {
                if (cmd.getDatastoreIdentityMetaData().getColumnMetaData().getPosition() != null) {
                    col6.setPosition(cmd.getDatastoreIdentityMetaData().getColumnMetaData().getPosition());
                }
                if (cmd.getDatastoreIdentityMetaData().getColumnMetaData().getJdbcType() != null) {
                    col6.setJdbcType(cmd.getDatastoreIdentityMetaData().getColumnMetaData().getJdbcType());
                }
            }
            this.datastoreIdColumn = col6;
        }
        if ((vermd = cmd.getVersionMetaDataForClass()) != null && vermd.getFieldName() == null) {
            colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
            col = this.addColumn(null, colName, ColumnType.VERSION_COLUMN);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(new MemberColumnMappingImpl(null, col));
            }
            if (vermd.getColumnMetaData() != null) {
                if (vermd.getColumnMetaData().getPosition() != null) {
                    col.setPosition(vermd.getColumnMetaData().getPosition());
                }
                if (vermd.getColumnMetaData().getJdbcType() != null) {
                    col.setJdbcType(vermd.getColumnMetaData().getJdbcType());
                }
            }
            this.versionColumn = col;
        }
        if (cmd.hasDiscriminatorStrategy()) {
            DiscriminatorMetaData dismd;
            colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            col = this.addColumn(null, colName, ColumnType.DISCRIMINATOR_COLUMN);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(new MemberColumnMappingImpl(null, col));
            }
            if ((dismd = cmd.getDiscriminatorMetaDataForTable()) != null && dismd.getColumnMetaData() != null) {
                if (dismd.getColumnMetaData().getPosition() != null) {
                    col.setPosition(dismd.getColumnMetaData().getPosition());
                }
                if (dismd.getColumnMetaData().getJdbcType() != null) {
                    col.setJdbcType(dismd.getColumnMetaData().getJdbcType());
                }
            }
            this.discriminatorColumn = col;
        }
        if ((mtmd = cmd.getMultitenancyMetaData()) != null) {
            ColumnMetaData colmd = mtmd.getColumnMetaData();
            String colName7 = mtmd.getColumnName();
            if (colmd != null) {
                colName7 = colmd.getName();
            }
            if (StringUtils.isWhitespace(colName7)) {
                colName7 = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN);
            }
            ColumnImpl col7 = this.addColumn(null, colName7, ColumnType.MULTITENANCY_COLUMN);
            col7.setJdbcType(colmd.getJdbcType() != null ? colmd.getJdbcType() : JdbcType.VARCHAR);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(new MemberColumnMappingImpl(null, col7));
            }
            this.multitenancyColumn = col7;
        }
        if ((sdmd = cmd.getSoftDeleteMetaData()) != null) {
            ColumnMetaData colmd = sdmd.getColumnMetaData();
            String colName8 = sdmd.getColumnName();
            if (colmd != null) {
                colName8 = colmd.getName();
            }
            if (StringUtils.isWhitespace(colName8)) {
                colName8 = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.SOFTDELETE_COLUMN);
            }
            col2 = this.addColumn(null, colName8, ColumnType.SOFTDELETE_COLUMN);
            col2.setJdbcType(colmd.getJdbcType() != null ? colmd.getJdbcType() : JdbcType.BOOLEAN);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(new MemberColumnMappingImpl(null, (Column)col2));
            }
            this.softDeleteColumn = col2;
        }
        if (cmd.hasExtension("createuser")) {
            // empty if block
        }
        if (cmd.hasExtension("createtimestamp")) {
            // empty if block
        }
        if (cmd.hasExtension("updateuser")) {
            // empty if block
        }
        if (cmd.hasExtension("updatetimestamp")) {
            // empty if block
        }
        ArrayList<Column> unorderedCols = new ArrayList<Column>();
        Column[] cols = new Column[this.columns.size()];
        for (Column col3 : this.columns) {
            if (col3.getPosition() >= this.columns.size()) {
                NucleusLogger.DATASTORE_SCHEMA.warn("Column with name " + col3.getName() + " is specified with position=" + col3.getPosition() + " which is invalid. This table has " + this.columns.size() + " columns");
                unorderedCols.add(col3);
                continue;
            }
            if (col3.getPosition() >= 0) {
                if (cols[col3.getPosition()] != null) {
                    NucleusLogger.DATASTORE_SCHEMA.warn("Column with name " + col3.getName() + " defined for position=" + col3.getPosition() + " yet there is also " + cols[col3.getPosition()].getName() + " at that position! Ignoring");
                    unorderedCols.add(col3);
                    continue;
                }
                cols[col3.getPosition()] = col3;
                continue;
            }
            unorderedCols.add(col3);
        }
        if (!unorderedCols.isEmpty()) {
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i] != null) continue;
                cols[i] = (Column)unorderedCols.get(0);
                cols[i].setPosition(i);
                unorderedCols.remove(0);
            }
        }
        this.columns = new ArrayList<Column>();
        for (Column col8 : cols) {
            MemberColumnMapping mapping = col8.getMemberColumnMapping();
            if (mapping != null) {
                if (!mapping.getMemberMetaData().isInsertable() && !mapping.getMemberMetaData().isUpdateable()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug("Not adding column " + col8.getName() + " for member=" + mapping.getMemberMetaData().getFullFieldName() + " since is not insertable/updateable");
                    continue;
                }
                boolean allowAddition = true;
                if (this.columnByName.containsKey(col8.getName())) {
                    Column otherCol = this.columnByName.get(col8.getName());
                    if (!((ColumnImpl)col8).isNested() && !((ColumnImpl)otherCol).isNested()) {
                        if (mapping.getMemberMetaData() instanceof PropertyMetaData && otherCol.getMemberColumnMapping().getMemberMetaData() instanceof PropertyMetaData) {
                            allowAddition = false;
                        } else {
                            String msg = "Unable to add column with name=" + col8.getName() + " for member=" + mapping.getMemberMetaData() + " to table=" + this.getName() + " for class=" + cmd.getFullClassName() + " since one with same name already exists (superclass?).";
                            NucleusLogger.DATASTORE_SCHEMA.error(msg);
                            throw new NucleusUserException(msg);
                        }
                    }
                }
                if (!allowAddition) continue;
                this.columns.add(col8);
                this.columnByName.put(col8.getName(), col8);
                continue;
            }
            this.columns.add(col8);
            this.columnByName.put(col8.getName(), col8);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected TypeConverter getTypeConverterForMember(AbstractMemberMetaData mmd, ColumnMetaData[] colmds, TypeManager typeMgr) {
        TypeConverter typeConv = null;
        String typeConvName = mmd.getTypeConverterName();
        if (typeConvName != null) {
            typeConv = typeMgr.getTypeConverterForName(typeConvName);
            if (typeConv == null) {
                throw new NucleusUserException(Localiser.msg("044062", mmd.getFullFieldName(), typeConvName));
            }
        } else {
            typeConv = typeMgr.getAutoApplyTypeConverterForType(mmd.getType());
        }
        if (typeConv == null) {
            if (colmds != null && colmds.length > 1) {
                Collection<TypeConverter> converters = typeMgr.getTypeConvertersForType(mmd.getType());
                if (converters != null && !converters.isEmpty()) {
                    for (TypeConverter conv : converters) {
                        if (!(conv instanceof MultiColumnConverter) || ((MultiColumnConverter)((Object)conv)).getDatastoreColumnTypes().length != colmds.length) continue;
                        typeConv = conv;
                        break;
                    }
                }
                if (typeConv != null) {
                    // empty if block
                }
            } else {
                JdbcType jdbcType;
                JdbcType jdbcType2 = jdbcType = colmds != null && colmds.length > 0 ? colmds[0].getJdbcType() : null;
                if (jdbcType != null) {
                    if (MetaDataUtils.isJdbcTypeString(jdbcType)) {
                        typeConv = typeMgr.getTypeConverterForType(mmd.getType(), String.class);
                    } else if (MetaDataUtils.isJdbcTypeNumeric(jdbcType)) {
                        typeConv = typeMgr.getTypeConverterForType(mmd.getType(), Long.class);
                    } else if (jdbcType == JdbcType.TIMESTAMP) {
                        typeConv = typeMgr.getTypeConverterForType(mmd.getType(), Timestamp.class);
                    } else if (jdbcType == JdbcType.TIME) {
                        typeConv = typeMgr.getTypeConverterForType(mmd.getType(), Time.class);
                    } else if (jdbcType == JdbcType.DATE) {
                        typeConv = typeMgr.getTypeConverterForType(mmd.getType(), Date.class);
                    }
                }
            }
        }
        if (this.schemaVerifier == null) return typeConv;
        return this.schemaVerifier.verifyTypeConverterForMember(mmd, typeConv);
    }

    protected void processEmbeddedMember(List<AbstractMemberMetaData> mmds, AbstractClassMetaData embCmd, ClassLoaderResolver clr, EmbeddedMetaData embmd, boolean ownerNested) {
        TypeManager typeMgr = this.storeMgr.getNucleusContext().getTypeManager();
        MetaDataManager mmgr = this.storeMgr.getMetaDataManager();
        NamingFactory namingFactory = this.storeMgr.getNamingFactory();
        AbstractMemberMetaData lastMmd = mmds.get(mmds.size() - 1);
        int[] memberPositions = embCmd.getAllMemberPositions();
        for (int i = 0; i < memberPositions.length; ++i) {
            MemberColumnMappingImpl mapping;
            ColumnImpl col;
            ArrayList<AbstractMemberMetaData> embMmds;
            MemberColumnMappingImpl mapping2;
            ColumnImpl col2;
            String colName;
            RelationType relationType;
            AbstractMemberMetaData[] embmdMmds;
            AbstractMemberMetaData mmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
            if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) continue;
            AbstractMemberMetaData embmdMmd = null;
            if (embmd != null && (embmdMmds = embmd.getMemberMetaData()) != null) {
                for (AbstractMemberMetaData thisMmd : embmdMmds) {
                    if (!thisMmd.getName().equals(mmd.getName())) continue;
                    embmdMmd = thisMmd;
                    break;
                }
            }
            if ((relationType = mmd.getRelationType(clr)) != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(mmgr, clr, mmd, relationType, lastMmd)) {
                if (RelationType.isRelationSingleValued(relationType)) {
                    boolean nested = false;
                    if (this.storeMgr.getSupportedOptions().contains("ORM.EmbeddedPC.Nested")) {
                        nested = !this.storeMgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.embedded.flat");
                        String nestedStr = mmd.getValueForExtension("nested");
                        if (nestedStr != null && nestedStr.equalsIgnoreCase("" + !nested)) {
                            nested = !nested;
                        }
                    }
                    ArrayList<AbstractMemberMetaData> embMmds2 = new ArrayList<AbstractMemberMetaData>(mmds);
                    embMmds2.add(mmd);
                    if (nested) {
                        ColumnMetaData[] colmds = mmd.getColumnMetaData();
                        colName = namingFactory.getColumnName(embMmds2, 0);
                        col2 = this.addEmbeddedColumn(colName, null);
                        col2.setNested(true);
                        if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getPosition() != null) {
                            col2.setPosition(embmdMmd.getColumnMetaData()[0].getPosition());
                        } else if (colmds != null && colmds.length == 1 && colmds[0].getPosition() != null) {
                            col2.setPosition(colmds[0].getPosition());
                        }
                        if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getJdbcType() != null) {
                            col2.setJdbcType(embmdMmd.getColumnMetaData()[0].getJdbcType());
                        } else if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                            col2.setJdbcType(colmds[0].getJdbcType());
                        }
                        mapping2 = new MemberColumnMappingImpl(mmd, col2);
                        col2.setMemberColumnMapping(mapping2);
                        if (this.schemaVerifier != null) {
                            this.schemaVerifier.attributeEmbeddedMember(mapping2, embMmds2);
                        }
                        this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds2), mapping2);
                    }
                    this.processEmbeddedMember(embMmds2, mmgr.getMetaDataForClass(mmd.getType(), clr), clr, embmdMmd != null ? embmdMmd.getEmbeddedMetaData() : null, nested);
                    continue;
                }
                if (mmd.hasCollection()) {
                    if (this.storeMgr.getSupportedOptions().contains("ORM.EmbeddedCollection.Nested")) {
                        embMmds = new ArrayList<AbstractMemberMetaData>(mmds);
                        embMmds.add(mmd);
                        ColumnMetaData[] colmds = mmd.getColumnMetaData();
                        String colName2 = namingFactory.getColumnName(embMmds, 0);
                        col = this.addEmbeddedColumn(colName2, null);
                        col.setNested(true);
                        if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getPosition() != null) {
                            col.setPosition(embmdMmd.getColumnMetaData()[0].getPosition());
                        } else if (colmds != null && colmds.length == 1 && colmds[0].getPosition() != null) {
                            col.setPosition(colmds[0].getPosition());
                        }
                        if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getJdbcType() != null) {
                            col.setJdbcType(embmdMmd.getColumnMetaData()[0].getJdbcType());
                        } else if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                            col.setJdbcType(colmds[0].getJdbcType());
                        }
                        mapping = new MemberColumnMappingImpl(mmd, col);
                        col.setMemberColumnMapping(mapping);
                        if (this.schemaVerifier != null) {
                            this.schemaVerifier.attributeEmbeddedMember(mapping, embMmds);
                        }
                        this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping);
                        this.processEmbeddedMember(embMmds, mmgr.getMetaDataForClass(mmd.getCollection().getElementType(), clr), clr, embmdMmd != null ? embmdMmd.getEmbeddedMetaData() : null, true);
                        continue;
                    }
                    NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is a (nested) embedded collection. Not supported for this datastore so ignoring");
                    continue;
                }
                if (mmd.hasMap()) {
                    if (this.storeMgr.getSupportedOptions().contains("ORM.EmbeddedMap.Nested")) {
                        NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is a (nested) embedded map. Not yet supported so ignoring");
                        continue;
                    }
                    NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is a (nested) embedded map. Not supported for this datastore so ignoring");
                    continue;
                }
                if (!mmd.hasArray()) continue;
                if (this.storeMgr.getSupportedOptions().contains("ORM.EmbeddedArray.Nested")) {
                    embMmds = new ArrayList<AbstractMemberMetaData>(mmds);
                    embMmds.add(mmd);
                    ColumnMetaData[] colmds = mmd.getColumnMetaData();
                    String colName3 = namingFactory.getColumnName(embMmds, 0);
                    col = this.addEmbeddedColumn(colName3, null);
                    col.setNested(true);
                    if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getPosition() != null) {
                        col.setPosition(embmdMmd.getColumnMetaData()[0].getPosition());
                    } else if (colmds != null && colmds.length == 1 && colmds[0].getPosition() != null) {
                        col.setPosition(colmds[0].getPosition());
                    }
                    if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getJdbcType() != null) {
                        col.setJdbcType(embmdMmd.getColumnMetaData()[0].getJdbcType());
                    } else if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                        col.setJdbcType(colmds[0].getJdbcType());
                    }
                    mapping = new MemberColumnMappingImpl(mmd, col);
                    col.setMemberColumnMapping(mapping);
                    if (this.schemaVerifier != null) {
                        this.schemaVerifier.attributeEmbeddedMember(mapping, embMmds);
                    }
                    this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping);
                    this.processEmbeddedMember(embMmds, mmgr.getMetaDataForClass(mmd.getArray().getElementType(), clr), clr, embmdMmd != null ? embmdMmd.getEmbeddedMetaData() : null, true);
                    continue;
                }
                NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is a (nested) embedded array. Not supported for this datastore so ignoring");
                continue;
            }
            embMmds = new ArrayList<AbstractMemberMetaData>(mmds);
            embMmds.add(mmd);
            ColumnMetaData[] colmds = mmd.getColumnMetaData();
            if (relationType != RelationType.NONE) {
                String colName4 = namingFactory.getColumnName(embMmds, 0);
                col = this.addEmbeddedColumn(colName4, null);
                col.setNested(ownerNested);
                if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getPosition() != null) {
                    col.setPosition(embmdMmd.getColumnMetaData()[0].getPosition());
                } else if (colmds != null && colmds.length == 1 && colmds[0].getPosition() != null) {
                    col.setPosition(colmds[0].getPosition());
                }
                if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getJdbcType() != null) {
                    col.setJdbcType(embmdMmd.getColumnMetaData()[0].getJdbcType());
                } else if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                    col.setJdbcType(colmds[0].getJdbcType());
                }
                mapping = new MemberColumnMappingImpl(mmd, col);
                col.setMemberColumnMapping(mapping);
                if (this.schemaVerifier != null) {
                    this.schemaVerifier.attributeEmbeddedMember(mapping, embMmds);
                }
                this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping);
                continue;
            }
            TypeConverter typeConv = this.getTypeConverterForMember(mmd, colmds, typeMgr);
            if (typeConv != null) {
                if (typeConv instanceof MultiColumnConverter) {
                    Class[] colJavaTypes = ((MultiColumnConverter)((Object)typeConv)).getDatastoreColumnTypes();
                    Column[] cols = new Column[colJavaTypes.length];
                    for (int j = 0; j < colJavaTypes.length; ++j) {
                        String colName5 = namingFactory.getColumnName(embMmds, j);
                        ColumnImpl col3 = this.addEmbeddedColumn(colName5, typeConv);
                        col3.setNested(ownerNested);
                        if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == colJavaTypes.length && embmdMmd.getColumnMetaData()[j].getPosition() != null) {
                            col3.setPosition(embmdMmd.getColumnMetaData()[j].getPosition());
                        } else if (colmds != null && colmds.length == colJavaTypes.length && colmds[j].getPosition() != null) {
                            col3.setPosition(colmds[j].getPosition());
                        }
                        if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == colJavaTypes.length && embmdMmd.getColumnMetaData()[j].getJdbcType() != null) {
                            col3.setJdbcType(embmdMmd.getColumnMetaData()[j].getJdbcType());
                        } else if (colmds != null && colmds.length == colJavaTypes.length && colmds[j].getJdbcType() != null) {
                            col3.setJdbcType(colmds[j].getJdbcType());
                        }
                        cols[j] = col3;
                    }
                    mapping2 = new MemberColumnMappingImpl(mmd, cols, typeConv);
                    for (int j = 0; j < colJavaTypes.length; ++j) {
                        ((ColumnImpl)cols[j]).setMemberColumnMapping(mapping2);
                    }
                    if (this.schemaVerifier != null) {
                        this.schemaVerifier.attributeEmbeddedMember(mapping2, embMmds);
                    }
                    this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping2);
                    continue;
                }
                colName = namingFactory.getColumnName(embMmds, 0);
                col2 = this.addEmbeddedColumn(colName, typeConv);
                col2.setNested(ownerNested);
                if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getPosition() != null) {
                    col2.setPosition(embmdMmd.getColumnMetaData()[0].getPosition());
                } else if (colmds != null && colmds.length == 1 && colmds[0].getPosition() != null) {
                    col2.setPosition(colmds[0].getPosition());
                }
                if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getJdbcType() != null) {
                    col2.setJdbcType(embmdMmd.getColumnMetaData()[0].getJdbcType());
                } else if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                    col2.setJdbcType(colmds[0].getJdbcType());
                }
                mapping2 = new MemberColumnMappingImpl(mmd, col2);
                col2.setMemberColumnMapping(mapping2);
                mapping2.setTypeConverter(typeConv);
                if (this.schemaVerifier != null) {
                    this.schemaVerifier.attributeEmbeddedMember(mapping2, embMmds);
                }
                this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping2);
                continue;
            }
            colName = namingFactory.getColumnName(embMmds, 0);
            col2 = this.addEmbeddedColumn(colName, null);
            col2.setNested(ownerNested);
            AbstractMemberMetaData theMmd = (AbstractMemberMetaData)embMmds.get(0);
            if (theMmd.isPrimaryKey()) {
                col2.setPrimaryKey();
            }
            if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getPosition() != null) {
                col2.setPosition(embmdMmd.getColumnMetaData()[0].getPosition());
            } else if (colmds != null && colmds.length == 1 && colmds[0].getPosition() != null) {
                col2.setPosition(colmds[0].getPosition());
            }
            if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getJdbcType() != null) {
                col2.setJdbcType(embmdMmd.getColumnMetaData()[0].getJdbcType());
            } else if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                col2.setJdbcType(colmds[0].getJdbcType());
            }
            MemberColumnMappingImpl mapping3 = new MemberColumnMappingImpl(mmd, col2);
            col2.setMemberColumnMapping(mapping3);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeEmbeddedMember(mapping3, embMmds);
            }
            this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping3);
        }
    }

    protected ColumnImpl addColumn(AbstractMemberMetaData mmd, String colName) {
        return this.addColumn(mmd, colName, ColumnType.COLUMN);
    }

    protected ColumnImpl addColumn(AbstractMemberMetaData mmd, String colName, ColumnType colType) {
        ColumnImpl col = new ColumnImpl(this, colName, colType);
        if (mmd != null) {
            if (mmd.isPrimaryKey()) {
                col.setPrimaryKey();
            }
        } else if (colType == ColumnType.DATASTOREID_COLUMN) {
            col.setPrimaryKey();
        }
        this.columns.add(col);
        return col;
    }

    protected ColumnImpl addEmbeddedColumn(String colName, TypeConverter typeConv) {
        ColumnImpl col = new ColumnImpl(this, colName, ColumnType.COLUMN);
        this.columns.add(col);
        return col;
    }

    private String getEmbeddedMemberNavigatedPath(List<AbstractMemberMetaData> mmds) {
        Iterator<AbstractMemberMetaData> mmdIter = mmds.iterator();
        StringBuilder strBldr = new StringBuilder(mmdIter.next().getFullFieldName());
        while (mmdIter.hasNext()) {
            strBldr.append('.').append(mmdIter.next().getName());
        }
        return strBldr.toString();
    }

    @Override
    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    @Override
    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getName() {
        return this.identifier;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns.size();
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public Column getColumnForPosition(int pos) {
        if (pos < 0 || pos >= this.columns.size()) {
            throw new ArrayIndexOutOfBoundsException("There are " + this.columns.size() + " columns, so specify a value between 0 and " + (this.columns.size() - 1));
        }
        return this.columns.get(pos);
    }

    @Override
    public Column getSurrogateColumn(SurrogateColumnType colType) {
        if (colType == SurrogateColumnType.DATASTORE_ID) {
            return this.datastoreIdColumn;
        }
        if (colType == SurrogateColumnType.DISCRIMINATOR) {
            return this.discriminatorColumn;
        }
        if (colType == SurrogateColumnType.VERSION) {
            return this.versionColumn;
        }
        if (colType == SurrogateColumnType.MULTITENANCY) {
            return this.multitenancyColumn;
        }
        if (colType != SurrogateColumnType.CREATE_TIMESTAMP && colType != SurrogateColumnType.UPDATE_TIMESTAMP && colType != SurrogateColumnType.CREATE_USER && colType != SurrogateColumnType.UPDATE_USER && colType == SurrogateColumnType.SOFTDELETE) {
            return this.softDeleteColumn;
        }
        return null;
    }

    @Override
    public Column getColumnForName(String name) {
        Column col = this.columnByName.get(name);
        if (col != null) {
            return col;
        }
        if (!name.startsWith("\"")) {
            col = this.columnByName.get("\"" + name + "\"");
        }
        return col;
    }

    @Override
    public MemberColumnMapping getMemberColumnMappingForMember(AbstractMemberMetaData mmd) {
        return this.mappingByMember.get(mmd.getFullFieldName());
    }

    @Override
    public MemberColumnMapping getMemberColumnMappingForEmbeddedMember(List<AbstractMemberMetaData> mmds) {
        return this.mappingByEmbeddedMember.get(this.getEmbeddedMemberNavigatedPath(mmds));
    }

    @Override
    public Set<MemberColumnMapping> getMemberColumnMappings() {
        HashSet<MemberColumnMapping> mappings = new HashSet<MemberColumnMapping>(this.mappingByMember.values());
        mappings.addAll(this.mappingByEmbeddedMember.values());
        return mappings;
    }

    public String toString() {
        return "Table: " + this.identifier;
    }

    public String debugString() {
        StringBuilder str = new StringBuilder();
        str.append("Table: ");
        if (this.catalogName != null) {
            str.append(this.catalogName).append('.');
        }
        if (this.schemaName != null) {
            str.append(this.schemaName).append('.');
        }
        str.append(this.identifier).append("\n");
        str.append("{\n");
        for (Column col : this.columns) {
            str.append("  ").append(col.toString()).append("\n");
        }
        str.append("}");
        return str.toString();
    }
}

