/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ReachabilityFieldManager
extends AbstractFieldManager {
    private final DNStateManager sm;
    private Set reachables = null;

    public ReachabilityFieldManager(DNStateManager sm, Set reachables) {
        this.sm = sm;
        this.reachables = reachables;
    }

    protected void processPersistable(Object obj, AbstractMemberMetaData mmd) {
        ExecutionContext ec = this.sm.getExecutionContext();
        DNStateManager objSM = ec.findStateManager(obj);
        if (objSM != null) {
            Object objID = objSM.getInternalObjectId();
            if (!this.reachables.contains(objID) && !objSM.isDeleted()) {
                if (ec.isEnlistedInTransaction(objID)) {
                    objSM.loadUnloadedRelationFields();
                }
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("007000", IdentityUtils.getPersistableIdentityForId(objID), objSM.getLifecycleState()));
                }
                this.reachables.add(objID);
                ReachabilityFieldManager pcFM = new ReachabilityFieldManager(objSM, this.reachables);
                int[] relationFieldNums = objSM.getClassMetaData().getRelationMemberPositions(ec.getClassLoaderResolver());
                int[] loadedFieldNumbers = ClassUtils.getFlagsSetTo(objSM.getLoadedFields(), relationFieldNums, true);
                if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
                    objSM.provideFields(loadedFieldNumbers, pcFM);
                }
            }
        } else if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("007005", this.sm.getExecutionContext().getApiAdapter().getIdForObject(obj), mmd.getFullFieldName()));
        }
    }

    private void processContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("007002", mmd.getFullFieldName()));
        }
        ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
        TypeManager typeManager = this.sm.getExecutionContext().getTypeManager();
        for (Object object : typeManager.getContainerAdapter(container)) {
            if (!api.isPersistable(object)) continue;
            this.processPersistable(object, mmd);
        }
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        RelationType relType;
        boolean persistCascade;
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (value != null && (persistCascade = mmd.isCascadePersist()) && (relType = mmd.getRelationType(this.sm.getExecutionContext().getClassLoaderResolver())) != RelationType.NONE) {
            if (mmd.hasContainer()) {
                this.processContainer(fieldNumber, value, mmd);
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("007004", mmd.getFullFieldName()));
                }
                this.processPersistable(value, mmd);
            }
        }
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
    }
}

