/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.containers.ElementContainerAdapter;
import org.datanucleus.store.types.containers.ElementContainerHandler;
import org.datanucleus.store.types.containers.MapContainerAdapter;
import org.datanucleus.store.types.containers.SequenceAdapter;

public class PersistFieldManager
extends AbstractFieldManager {
    private final DNStateManager sm;
    private final boolean replaceSCOsWithWrappers;

    public PersistFieldManager(DNStateManager sm, boolean replaceSCOsWithWrappers) {
        this.sm = sm;
        this.replaceSCOsWithWrappers = replaceSCOsWithWrappers;
    }

    protected Object processPersistable(Object pc, int ownerFieldNum, int objectType) {
        ApiAdapter adapter = this.sm.getExecutionContext().getApiAdapter();
        if (!adapter.isPersistent(pc) || adapter.isPersistent(pc) && adapter.isDeleted(pc)) {
            if (objectType != 0) {
                return this.sm.getExecutionContext().persistObjectInternal(pc, this.sm, ownerFieldNum, objectType);
            }
            return this.sm.getExecutionContext().persistObjectInternal(pc, null, -1, objectType);
        }
        return pc;
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        if (value != null) {
            ClassLoaderResolver clr;
            RelationType relationType;
            AbstractMemberMetaData mmd;
            boolean[] secondClassMutableFieldFlags;
            if (this.replaceSCOsWithWrappers && (secondClassMutableFieldFlags = this.sm.getClassMetaData().getSCOMutableMemberFlags())[fieldNumber] && !(value instanceof SCO)) {
                value = SCOUtils.wrapSCOField(this.sm, fieldNumber, value, true);
            }
            if ((mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).isCascadePersist() && (relationType = mmd.getRelationType(clr = this.sm.getExecutionContext().getClassLoaderResolver())) != RelationType.NONE) {
                if (mmd.hasContainer()) {
                    this.processContainer(fieldNumber, value, mmd);
                } else if (mmd.isEmbedded() || mmd.isSerialized()) {
                    this.processPersistable(value, fieldNumber, 1);
                } else {
                    this.processPersistable(value, -1, 0);
                }
            }
        }
    }

    private void processContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        if (mmd.hasMap()) {
            this.processMapContainer(fieldNumber, container, mmd);
        } else {
            this.processElementContainer(fieldNumber, container, mmd);
        }
    }

    private void processMapContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        TypeManager typeManager = this.sm.getExecutionContext().getTypeManager();
        Object containerHandler = typeManager.getContainerHandler(mmd.getType());
        ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
        MapContainerAdapter mapAdapter = (MapContainerAdapter)containerHandler.getAdapter((Object)container);
        for (Map.Entry<Object, Object> entry : mapAdapter.entries()) {
            DNStateManager valSM;
            DNStateManager keySM;
            Object mapKey = entry.getKey();
            Object mapValue = entry.getValue();
            Object newMapKey = mapKey;
            Object newMapValue = mapValue;
            if (api.isPersistable(mapKey)) {
                int mapKeyObjectType = mmd.getMap().isEmbeddedKey() || mmd.getMap().isSerializedKey() ? 3 : 0;
                newMapKey = this.processPersistable(mapKey, fieldNumber, mapKeyObjectType);
            }
            if (api.isPersistable(mapValue)) {
                int mapValueObjectType = mmd.getMap().isEmbeddedValue() || mmd.getMap().isSerializedValue() ? 4 : 0;
                newMapValue = this.processPersistable(mapValue, fieldNumber, mapValueObjectType);
            }
            if (newMapKey == mapKey && newMapValue == mapValue) continue;
            boolean updateKey = false;
            boolean updateValue = false;
            if (newMapKey != mapKey && (keySM = this.sm.getExecutionContext().findStateManager(newMapKey)).getReferencedPC() != null) {
                updateKey = true;
            }
            if (newMapValue != mapValue && (valSM = this.sm.getExecutionContext().findStateManager(newMapValue)).getReferencedPC() != null) {
                updateValue = true;
            }
            if (updateKey) {
                mapAdapter.remove(mapKey);
                mapAdapter.put(newMapKey, updateValue ? newMapValue : mapValue);
                continue;
            }
            if (!updateValue) continue;
            mapAdapter.put(mapKey, newMapValue);
        }
    }

    private void processElementContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        TypeManager typeManager = this.sm.getExecutionContext().getTypeManager();
        ElementContainerHandler elementContainerHandler = (ElementContainerHandler)typeManager.getContainerHandler(mmd.getType());
        ElementContainerAdapter containerAdapter = (ElementContainerAdapter)elementContainerHandler.getAdapter(container);
        ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
        int objectType = elementContainerHandler.getObjectType(mmd);
        if (objectType == 0) {
            int elementPosition = 0;
            for (Object element : containerAdapter) {
                if (api.isPersistable(element)) {
                    Object newElement = this.processPersistable(element, -1, objectType);
                    DNStateManager elementSM = this.sm.getExecutionContext().findStateManager(newElement);
                    if (elementSM.getReferencedPC() != null) {
                        if (containerAdapter instanceof SequenceAdapter) {
                            ((SequenceAdapter)((Object)containerAdapter)).update(newElement, elementPosition);
                        } else {
                            containerAdapter.remove(elementSM);
                            containerAdapter.add(newElement);
                        }
                    }
                }
                ++elementPosition;
            }
        } else {
            for (Object element : containerAdapter) {
                if (!api.isPersistable(element)) continue;
                this.processPersistable(element, fieldNumber, objectType);
            }
        }
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
    }
}

