/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.containers.ContainerHandler;
import org.datanucleus.store.types.containers.ElementContainerAdapter;
import org.datanucleus.store.types.containers.ElementContainerHandler;
import org.datanucleus.store.types.containers.MapContainerAdapter;

public class DeleteFieldManager
extends AbstractFieldManager {
    private final DNStateManager sm;
    private boolean manageRelationships = false;

    public DeleteFieldManager(DNStateManager sm) {
        this(sm, false);
    }

    public DeleteFieldManager(DNStateManager sm, boolean manageRelationships) {
        this.sm = sm;
        this.manageRelationships = manageRelationships;
    }

    protected void processPersistable(Object pc) {
        DNStateManager pcSM = this.sm.getExecutionContext().findStateManager(pc);
        if (pcSM != null && (pcSM.isDeleting() || pcSM.becomingDeleted())) {
            return;
        }
        this.sm.getExecutionContext().deleteObjectInternal(pc);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        ExecutionContext ec;
        AbstractMemberMetaData mmd;
        RelationType relationType;
        if (value != null && (relationType = (mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getRelationType((ec = this.sm.getExecutionContext()).getClassLoaderResolver())) != RelationType.NONE) {
            if (mmd.hasContainer()) {
                this.processContainer(fieldNumber, value, mmd, ec, relationType);
            } else {
                this.processSingleValue(value, mmd, ec, relationType);
            }
        }
    }

    private void processSingleValue(Object value, AbstractMemberMetaData mmd, ExecutionContext ec, RelationType relationType) {
        DNStateManager valueSM;
        if (mmd.isDependent()) {
            this.processPersistable(value);
        } else if (this.manageRelationships && RelationType.isBidirectional(relationType) && !mmd.isEmbedded() && (valueSM = ec.findStateManager(value)) != null && !valueSM.getLifecycleState().isDeleted() && !valueSM.isDeleting()) {
            AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(ec.getClassLoaderResolver())[0];
            if (relationType == RelationType.ONE_TO_ONE_BI) {
                valueSM.replaceFieldMakeDirty(relMmd.getAbsoluteFieldNumber(), null);
                valueSM.flush();
            } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                Object containerHandler;
                valueSM.loadField(relMmd.getAbsoluteFieldNumber());
                Object relValue = valueSM.provideField(relMmd.getAbsoluteFieldNumber());
                if (relValue != null && (containerHandler = ec.getTypeManager().getContainerHandler(relMmd.getType())) instanceof ElementContainerHandler) {
                    ElementContainerAdapter adapter = (ElementContainerAdapter)containerHandler.getAdapter((Object)relValue);
                    adapter.remove(this.sm.getObject());
                }
            }
        }
    }

    private void processContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd, ExecutionContext ec, RelationType relationType) {
        TypeManager typeManager = this.sm.getExecutionContext().getTypeManager();
        Object containerHandler = typeManager.getContainerHandler(mmd.getType());
        if (mmd.hasMap()) {
            this.processMapContainer(fieldNumber, container, mmd, (ContainerHandler<Object, MapContainerAdapter<Object>>)containerHandler);
        } else {
            this.processElementContainer(fieldNumber, container, mmd, (ContainerHandler<Object, ElementContainerAdapter<Object>>)containerHandler, ec, relationType);
        }
    }

    private void processMapContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd, ContainerHandler<Object, MapContainerAdapter<Object>> containerHandler) {
        block5: {
            boolean dependentValue;
            block6: {
                boolean dependentKey;
                block4: {
                    dependentKey = mmd.getMap().isDependentKey();
                    dependentValue = mmd.getMap().isDependentValue();
                    if (!dependentKey || !dependentValue) break block4;
                    ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
                    for (Map.Entry<Object, Object> entry : containerHandler.getAdapter(container).entries()) {
                        Object value;
                        Object key = entry.getKey();
                        if (api.isPersistable(key)) {
                            this.processPersistable(key);
                        }
                        if (!api.isPersistable(value = entry.getValue())) continue;
                        this.processPersistable(key);
                    }
                    break block5;
                }
                if (!dependentKey) break block6;
                ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
                for (Object key : containerHandler.getAdapter(container).keys()) {
                    if (!api.isPersistable(key)) continue;
                    this.processPersistable(key);
                }
                break block5;
            }
            if (!dependentValue) break block5;
            ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
            for (Object value : containerHandler.getAdapter(container).values()) {
                if (!api.isPersistable(value)) continue;
                this.processPersistable(value);
            }
        }
    }

    private void processElementContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd, ContainerHandler<Object, ElementContainerAdapter<Object>> containerHandler, ExecutionContext ec, RelationType relationType) {
        block3: {
            block2: {
                if (!mmd.isCascadeRemoveOrphans() && (mmd.getCollection() == null || !mmd.getCollection().isDependentElement()) && (mmd.getArray() == null || !mmd.getArray().isDependentElement())) break block2;
                ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
                for (Object t : containerHandler.getAdapter(container)) {
                    if (!api.isPersistable(t)) continue;
                    this.processPersistable(t);
                }
                break block3;
            }
            if (!this.manageRelationships || relationType != RelationType.ONE_TO_MANY_BI || mmd.isEmbedded() || mmd.getCollection().isEmbeddedElement()) break block3;
            ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
            for (Object t : containerHandler.getAdapter(container)) {
                DNStateManager elementSM;
                if (!api.isPersistable(t) || (elementSM = ec.findStateManager(t)) == null || elementSM.getLifecycleState().isDeleted() || elementSM.isDeleting()) continue;
                AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(ec.getClassLoaderResolver())[0];
                elementSM.replaceFieldMakeDirty(relMmd.getAbsoluteFieldNumber(), null);
                elementSM.flush();
            }
        }
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
    }
}

