/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.store.StoreManager;
import org.datanucleus.util.Localiser;

public class StoreManagerHelper {
    static Class[] STORE_MGR_CTR_ARG_TYPES = new Class[]{ClassConstants.CLASS_LOADER_RESOLVER, ClassConstants.PERSISTENCE_NUCLEUS_CONTEXT, Map.class};

    public static StoreManager createStoreManagerForProperties(Map<String, Object> props, Map<String, Object> datastoreProps, ClassLoaderResolver clr, NucleusContext nucCtx) {
        Extension[] exts = nucCtx.getPluginManager().getExtensionPoint("org.datanucleus.store_manager").getExtensions();
        StoreManager storeMgr = null;
        String url = (String)props.get("datanucleus.ConnectionURL".toLowerCase());
        if (url != null) {
            int idx = url.indexOf(58);
            if (idx > -1) {
                url = url.substring(0, idx);
            }
            for (int e = 0; storeMgr == null && e < exts.length; ++e) {
                ConfigurationElement[] confElm = exts[e].getConfigurationElements();
                for (int c = 0; storeMgr == null && c < confElm.length; ++c) {
                    String urlKey = confElm[c].getAttribute("url-key");
                    if (url != null && !urlKey.equalsIgnoreCase(url)) continue;
                    try {
                        Object[] ctrArgs = new Object[]{clr, nucCtx, datastoreProps};
                        storeMgr = (StoreManager)nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.store_manager", "url-key", url == null ? urlKey : url, "class-name", STORE_MGR_CTR_ARG_TYPES, ctrArgs);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable t = ex.getTargetException();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new NucleusException(t.getMessage(), t).setFatal();
                    }
                    catch (Exception ex) {
                        throw new NucleusException(ex.getMessage(), ex).setFatal();
                    }
                }
            }
        } else {
            try {
                Object[] ctrArgs = new Object[]{clr, nucCtx, datastoreProps};
                storeMgr = (StoreManager)nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.store_manager", "key", "rdbms", "class-name", STORE_MGR_CTR_ARG_TYPES, ctrArgs);
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getTargetException();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new NucleusException(t.getMessage(), t).setFatal();
            }
            catch (Exception ex) {
                throw new NucleusException(ex.getMessage(), ex).setFatal();
            }
        }
        if (storeMgr == null) {
            throw new NucleusUserException(Localiser.msg("008004", url)).setFatal();
        }
        return storeMgr;
    }
}

