/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.DatastoreReadOnlyException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractPersistenceHandler
implements StorePersistenceHandler {
    protected StoreManager storeMgr;

    public AbstractPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = storeMgr;
    }

    @Override
    public Object findObjectForUnique(ExecutionContext ec, AbstractClassMetaData cmd, String[] memberNames, Object[] values) {
        if (memberNames.length != values.length) {
            throw new NucleusUserException("findObjectForUnique should have same number of member names and values");
        }
        StringBuilder jdoqlStr = new StringBuilder("SELECT FROM ").append(cmd.getFullClassName()).append(" WHERE ");
        HashMap<CallSite, Object> paramValueMap = new HashMap<CallSite, Object>();
        for (int i = 0; i < memberNames.length; ++i) {
            jdoqlStr.append("this.").append(memberNames[i]).append(" == :val").append(i);
            paramValueMap.put((CallSite)((Object)("val" + i)), values[i]);
            if (i == memberNames.length - 1) continue;
            jdoqlStr.append(" && ");
        }
        Query q = this.storeMgr.newQuery("JDOQL", ec, jdoqlStr.toString());
        List results = (List)q.executeWithMap(paramValueMap);
        if (results == null || results.size() == 0) {
            throw new NucleusObjectNotFoundException("No object found for specified members and values of type " + cmd.getFullClassName());
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new NucleusUserException("Specified members for class " + cmd.getFullClassName() + " finds multiple objects!");
    }

    public void assertReadOnlyForUpdateOfObject(DNStateManager sm) {
        boolean readonly;
        String value;
        if (sm.getExecutionContext().getBooleanProperty("datanucleus.readOnlyDatastore").booleanValue()) {
            if (sm.getExecutionContext().getStringProperty("datanucleus.readOnlyDatastoreAction").equalsIgnoreCase("EXCEPTION")) {
                throw new DatastoreReadOnlyException(Localiser.msg("032004", sm.getObjectAsPrintable()), sm.getExecutionContext().getClassLoaderResolver());
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("032005", sm.getObjectAsPrintable()));
            }
            return;
        }
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.hasExtension("read-only") && !StringUtils.isWhitespace(value = cmd.getValueForExtension("read-only")) && (readonly = Boolean.valueOf(value).booleanValue())) {
            if (sm.getExecutionContext().getStringProperty("datanucleus.readOnlyDatastoreAction").equalsIgnoreCase("EXCEPTION")) {
                throw new DatastoreReadOnlyException(Localiser.msg("032006", sm.getObjectAsPrintable()), sm.getExecutionContext().getClassLoaderResolver());
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("032007", sm.getObjectAsPrintable()));
            }
            return;
        }
    }
}

