/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.LockManager;
import org.datanucleus.state.LockMode;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class LockManagerImpl
implements LockManager {
    ExecutionContext ec;
    Map<Object, LockMode> requiredLockModesById = null;
    Map<DNStateManager, LockMode> lockModeBySM = null;

    public LockManagerImpl(ExecutionContext ec) {
        this.ec = ec;
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        if (this.requiredLockModesById != null) {
            this.requiredLockModesById.clear();
        }
        if (this.lockModeBySM != null) {
            this.lockModeBySM.clear();
        }
    }

    @Override
    public void lock(Object id, LockMode lockMode) {
        if (this.requiredLockModesById == null) {
            this.requiredLockModesById = new HashMap<Object, LockMode>();
        }
        this.requiredLockModesById.put(id, lockMode);
    }

    @Override
    public LockMode getLockMode(Object id) {
        LockMode lockMode;
        if (this.requiredLockModesById != null && (lockMode = this.requiredLockModesById.get(id)) != null) {
            return lockMode;
        }
        return LockMode.LOCK_NONE;
    }

    @Override
    public void lock(DNStateManager sm, LockMode lockMode) {
        if (this.lockModeBySM == null) {
            this.lockModeBySM = new HashMap<DNStateManager, LockMode>();
        }
        this.lockModeBySM.put(sm, lockMode);
        if (lockMode == LockMode.LOCK_PESSIMISTIC_READ || lockMode == LockMode.LOCK_PESSIMISTIC_WRITE) {
            sm.locate();
        }
    }

    @Override
    public void unlock(DNStateManager sm) {
        if (this.lockModeBySM != null) {
            this.lockModeBySM.remove(sm);
        }
    }

    @Override
    public LockMode getLockMode(DNStateManager sm) {
        if (sm == null) {
            return LockMode.LOCK_NONE;
        }
        if (this.lockModeBySM != null) {
            return this.lockModeBySM.containsKey(sm) ? this.lockModeBySM.get(sm) : LockMode.LOCK_NONE;
        }
        return LockMode.LOCK_NONE;
    }

    @Override
    public void performOptimisticVersionCheck(DNStateManager sm, VersionStrategy versionStrategy, Object versionDatastore) {
        boolean valid;
        Object versionObject = sm.getTransactionalVersion();
        if (versionObject == null) {
            return;
        }
        if (versionStrategy == null) {
            NucleusLogger.PERSISTENCE.info(sm.getClassMetaData().getFullClassName() + " has no version metadata so no check of version is required, since this will not have the version flag in its table");
            return;
        }
        if (versionStrategy == VersionStrategy.DATE_TIME) {
            valid = versionObject instanceof Calendar ? ((Calendar)versionObject).getTimeInMillis() == ((Calendar)versionDatastore).getTimeInMillis() : (versionObject instanceof Instant ? ((Instant)versionObject).equals(versionDatastore) : ((java.util.Date)versionObject).getTime() == ((java.util.Date)versionDatastore).getTime());
        } else if (versionStrategy == VersionStrategy.VERSION_NUMBER) {
            valid = ((Number)versionObject).longValue() == ((Number)versionDatastore).longValue();
        } else {
            if (versionStrategy == VersionStrategy.STATE_IMAGE) {
                throw new NucleusUserException(Localiser.msg("032017", new Object[]{sm.getClassMetaData().getFullClassName(), versionStrategy}));
            }
            throw new NucleusUserException(Localiser.msg("032017", new Object[]{sm.getClassMetaData().getFullClassName(), versionStrategy}));
        }
        if (!valid) {
            throw new NucleusOptimisticException(Localiser.msg("032016", IdentityUtils.getPersistableIdentityForId(sm.getInternalObjectId()), "" + versionDatastore, "" + versionObject), sm.getObject());
        }
    }

    @Override
    public Object getNextVersion(VersionMetaData vermd, Object currentVersion) {
        if (vermd == null) {
            return null;
        }
        VersionStrategy versionStrategy = vermd.getVersionStrategy();
        if (versionStrategy == null) {
            return null;
        }
        if (versionStrategy == VersionStrategy.NONE) {
            if (currentVersion == null) {
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = ((AbstractClassMetaData)vermd.getParent()).getMetaDataForMember(vermd.getFieldName());
                    if (verMmd.getType() == Integer.class || verMmd.getType() == Integer.TYPE) {
                        return 1;
                    }
                    if (verMmd.getType() == Short.class || verMmd.getType() == Short.TYPE) {
                        return (short)1;
                    }
                }
                return 1L;
            }
            return currentVersion;
        }
        if (versionStrategy == VersionStrategy.DATE_TIME) {
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = ((AbstractClassMetaData)vermd.getParent()).getMetaDataForMember(vermd.getFieldName());
                if (Calendar.class.isAssignableFrom(verMmd.getType())) {
                    return Calendar.getInstance();
                }
                if (Time.class.isAssignableFrom(verMmd.getType())) {
                    return new Time(System.currentTimeMillis());
                }
                if (Date.class.isAssignableFrom(verMmd.getType())) {
                    return new Date(System.currentTimeMillis());
                }
                if (Instant.class.isAssignableFrom(verMmd.getType())) {
                    return Instant.now();
                }
            }
            return new Timestamp(System.currentTimeMillis());
        }
        if (versionStrategy == VersionStrategy.VERSION_NUMBER) {
            if (currentVersion == null) {
                Integer initValue = this.ec.getIntProperty("datanucleus.version.versionNumber.initialValue");
                if (vermd.hasExtension("version-initial-value")) {
                    initValue = Integer.valueOf(vermd.getValueForExtension("version-initial-value"));
                }
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = ((AbstractClassMetaData)vermd.getParent()).getMetaDataForMember(vermd.getFieldName());
                    if (verMmd.getType() == Integer.class || verMmd.getType() == Integer.TYPE) {
                        return initValue;
                    }
                    if (verMmd.getType() == Short.class || verMmd.getType() == Short.TYPE) {
                        return initValue.shortValue();
                    }
                }
                return (long)initValue.intValue();
            }
            if (currentVersion instanceof Integer) {
                return (Integer)currentVersion + 1;
            }
            if (currentVersion instanceof Short) {
                return (short)((Short)currentVersion + 1);
            }
            return (Long)currentVersion + 1L;
        }
        if (versionStrategy == VersionStrategy.STATE_IMAGE) {
            throw new NucleusUserException("DataNucleus doesnt currently support version strategy \"state-image\"");
        }
        throw new NucleusUserException("Unknown version strategy - not supported");
    }
}

