/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.flush;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.flush.FlushProcess;
import org.datanucleus.flush.OperationQueue;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class FlushOrdered
implements FlushProcess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NucleusOptimisticException> execute(ExecutionContext ec, Collection<DNStateManager> primaryOPs, Collection<DNStateManager> secondaryOPs, OperationQueue opQueue) {
        int i;
        ArrayList<NucleusOptimisticException> optimisticFailures = null;
        Object[] toFlushPrimary = null;
        Object[] toFlushSecondary = null;
        try {
            if (ec.getMultithreaded()) {
                ec.getLock().lock();
            }
            if (primaryOPs != null) {
                toFlushPrimary = primaryOPs.toArray();
                primaryOPs.clear();
            }
            if (secondaryOPs != null) {
                toFlushSecondary = secondaryOPs.toArray();
                secondaryOPs.clear();
            }
        }
        finally {
            if (ec.getMultithreaded()) {
                ec.getLock().unlock();
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            int total = 0;
            if (toFlushPrimary != null) {
                total += toFlushPrimary.length;
            }
            if (toFlushSecondary != null) {
                total += toFlushSecondary.length;
            }
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010003", total));
        }
        HashSet classesToFlush = null;
        if (ec.getNucleusContext().getStoreManager().getQueryManager().getQueryResultsCache() != null) {
            classesToFlush = new HashSet();
        }
        if (toFlushPrimary != null) {
            for (i = 0; i < toFlushPrimary.length; ++i) {
                DNStateManager dNStateManager = (DNStateManager)toFlushPrimary[i];
                try {
                    dNStateManager.flush();
                    if (classesToFlush == null || dNStateManager.getObject() == null) continue;
                    classesToFlush.add(dNStateManager.getObject().getClass());
                    continue;
                }
                catch (NucleusOptimisticException oe) {
                    if (optimisticFailures == null) {
                        optimisticFailures = new ArrayList<NucleusOptimisticException>();
                    }
                    optimisticFailures.add(oe);
                }
            }
        }
        if (toFlushSecondary != null) {
            for (i = 0; i < toFlushSecondary.length; ++i) {
                DNStateManager dNStateManager = (DNStateManager)toFlushSecondary[i];
                try {
                    dNStateManager.flush();
                    if (classesToFlush == null || dNStateManager.getObject() == null) continue;
                    classesToFlush.add(dNStateManager.getObject().getClass());
                    continue;
                }
                catch (NucleusOptimisticException oe) {
                    if (optimisticFailures == null) {
                        optimisticFailures = new ArrayList();
                    }
                    optimisticFailures.add(oe);
                }
            }
        }
        if (opQueue != null) {
            if (!ec.getStoreManager().usesBackedSCOWrappers()) {
                opQueue.processOperationsForNoBackingStoreSCOs(ec);
            }
            opQueue.clearPersistDeleteUpdateOperations();
        }
        if (classesToFlush != null) {
            for (Class clazz : classesToFlush) {
                ec.getNucleusContext().getStoreManager().getQueryManager().evictQueryResultsForType(clazz);
            }
        }
        return optimisticFailures;
    }
}

