/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CacheUniqueKey;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.util.NucleusLogger;

public class JavaxCacheLevel2Cache
extends AbstractLevel2Cache {
    public static final String NAME = "javax.cache";
    private static final long serialVersionUID = 3218890128547271239L;
    private Cache cache;
    private Cache cacheUnique;

    public JavaxCacheLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        try {
            CachingProvider cacheProvider = Caching.getCachingProvider();
            CacheManager cacheMgr = cacheProvider.getCacheManager();
            Cache tmpcache = cacheMgr.getCache(this.cacheName);
            if (tmpcache == null) {
                MutableConfiguration cacheConfig = new MutableConfiguration();
                Configuration conf = nucleusCtx.getConfiguration();
                if (conf.hasProperty("datanucleus.cache.level2.readThrough")) {
                    cacheConfig.setReadThrough(conf.getBooleanProperty("datanucleus.cache.level2.readThrough"));
                }
                if (conf.hasProperty("datanucleus.cache.level2.writeThrough")) {
                    cacheConfig.setWriteThrough(conf.getBooleanProperty("datanucleus.cache.level2.writeThrough"));
                }
                if (conf.hasProperty("datanucleus.cache.level2.statisticsEnabled")) {
                    cacheConfig.setStatisticsEnabled(conf.getBooleanProperty("datanucleus.cache.level2.statisticsEnabled"));
                }
                if (conf.hasProperty("datanucleus.cache.level2.storeByValue")) {
                    cacheConfig.setStoreByValue(conf.getBooleanProperty("datanucleus.cache.level2.storeByValue"));
                }
                if (this.expiryMillis > 0L) {
                    // empty if block
                }
                cacheMgr.createCache(this.cacheName, (javax.cache.configuration.Configuration)cacheConfig);
                tmpcache = cacheMgr.getCache(this.cacheName);
            }
            this.cache = tmpcache;
            String cacheNameUnique = this.cacheName + "UNIQUE";
            tmpcache = cacheMgr.getCache(cacheNameUnique);
            if (tmpcache == null) {
                MutableConfiguration cacheConfig = new MutableConfiguration();
                Configuration conf = nucleusCtx.getConfiguration();
                if (conf.hasProperty("datanucleus.cache.level2.readThrough")) {
                    cacheConfig.setReadThrough(conf.getBooleanProperty("datanucleus.cache.level2.readThrough"));
                }
                if (conf.hasProperty("datanucleus.cache.level2.writeThrough")) {
                    cacheConfig.setWriteThrough(conf.getBooleanProperty("datanucleus.cache.level2.writeThrough"));
                }
                if (conf.hasProperty("datanucleus.cache.level2.statisticsEnabled")) {
                    cacheConfig.setStatisticsEnabled(conf.getBooleanProperty("datanucleus.cache.level2.statisticsEnabled"));
                }
                if (conf.hasProperty("datanucleus.cache.level2.storeByValue")) {
                    cacheConfig.setStoreByValue(conf.getBooleanProperty("datanucleus.cache.level2.storeByValue"));
                }
                if (this.expiryMillis > 0L) {
                    // empty if block
                }
                cacheMgr.createCache(cacheNameUnique, (javax.cache.configuration.Configuration)cacheConfig);
                tmpcache = cacheMgr.getCache(cacheNameUnique);
            }
            this.cacheUnique = tmpcache;
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", e);
        }
    }

    @Override
    public void close() {
        if (this.clearAtClose) {
            try {
                this.cache.removeAll();
            }
            catch (Exception re) {
                NucleusLogger.CACHE.debug("Objects not evicted from cache due to : " + re.getMessage());
            }
            this.cache.close();
            try {
                this.cacheUnique.removeAll();
            }
            catch (Exception re) {
                NucleusLogger.CACHE.debug("Objects not evicted from cache due to : " + re.getMessage());
            }
            this.cacheUnique.close();
        }
        this.cache = null;
        this.cacheUnique = null;
    }

    @Override
    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    @Override
    public CachedPC get(Object oid) {
        try {
            return (CachedPC)this.cache.get(oid);
        }
        catch (Exception e) {
            NucleusLogger.CACHE.debug("Object with id " + oid + " not retrieved from cache due to : " + e.getMessage());
            return null;
        }
    }

    @Override
    public Map<Object, CachedPC> getAll(Collection oids) {
        try {
            if (oids instanceof Set) {
                return this.cache.getAll((Set)oids);
            }
            return this.cache.getAll(new HashSet(oids));
        }
        catch (Exception e) {
            NucleusLogger.CACHE.debug("Objects not retrieved from cache due to : " + e.getMessage());
            return null;
        }
    }

    @Override
    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        try {
            this.cache.put(oid, (Object)pc);
        }
        catch (Exception e) {
            NucleusLogger.CACHE.debug("Object with id " + oid + " for cachedPC=" + pc.toString("", true) + " not cached due to : " + e.getMessage());
        }
        return pc;
    }

    @Override
    public void putAll(Map<Object, CachedPC> objs) {
        if (objs == null) {
            return;
        }
        try {
            this.cache.putAll(objs);
        }
        catch (Exception e) {
            NucleusLogger.CACHE.debug("Objects not cached due to : " + e.getMessage());
        }
    }

    @Override
    public void evict(Object oid) {
        try {
            this.cache.remove(oid);
        }
        catch (Exception re) {
            NucleusLogger.CACHE.debug("Object with id=" + oid + " not evicted from cache due to : " + re.getMessage());
        }
    }

    @Override
    public void evictAll() {
        try {
            this.cache.removeAll();
        }
        catch (Exception re) {
            NucleusLogger.CACHE.debug("Objects not evicted from cache due to : " + re.getMessage());
        }
    }

    @Override
    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        try {
            if (oids instanceof Set) {
                this.cache.removeAll((Set)oids);
            } else {
                this.cache.removeAll(new HashSet(oids));
            }
        }
        catch (Exception re) {
            NucleusLogger.CACHE.debug("Objects not evicted from cache due to : " + re.getMessage());
        }
    }

    @Override
    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        try {
            HashSet<Object> oidSet = new HashSet<Object>(Arrays.asList(oids));
            this.cache.removeAll(oidSet);
        }
        catch (Exception re) {
            NucleusLogger.CACHE.debug("Objects not evicted from cache due to : " + re.getMessage());
        }
    }

    @Override
    public void evictAll(Class pcClass, boolean subclasses) {
        String[] subclassNames;
        if (!this.nucleusCtx.getApiAdapter().isPersistable(pcClass)) {
            return;
        }
        this.evictAllOfClass(pcClass.getName());
        if (subclasses && (subclassNames = this.nucleusCtx.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                this.evictAllOfClass(subclassNames[i]);
            }
        }
    }

    void evictAllOfClass(String className) {
        try {
            AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(className, this.nucleusCtx.getClassLoaderResolver(null));
            Iterator entryIter = this.cache.iterator();
            while (entryIter.hasNext()) {
                String targetClassName;
                Cache.Entry entry = (Cache.Entry)entryIter.next();
                Object key = entry.getKey();
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    targetClassName = IdentityUtils.getTargetClassNameForIdentity(key);
                    if (!className.equals(targetClassName)) continue;
                    entryIter.remove();
                    continue;
                }
                if (cmd.getIdentityType() != IdentityType.DATASTORE || !className.equals(targetClassName = IdentityUtils.getTargetClassNameForIdentity(key))) continue;
                entryIter.remove();
            }
        }
        catch (Exception re) {
            NucleusLogger.CACHE.debug("Objects not evicted from cache due to : " + re.getMessage());
        }
    }

    @Override
    public CachedPC getUnique(CacheUniqueKey key) {
        return (CachedPC)this.cacheUnique.get((Object)key);
    }

    @Override
    public CachedPC putUnique(CacheUniqueKey key, CachedPC pc) {
        try {
            this.cacheUnique.put((Object)key, (Object)pc);
        }
        catch (Exception e) {
            NucleusLogger.CACHE.debug("Object with key " + key + " not cached due to : " + e.getMessage());
        }
        return pc;
    }

    @Override
    public void putUniqueAll(Map<CacheUniqueKey, CachedPC> objs) {
        if (objs == null) {
            return;
        }
        try {
            this.cacheUnique.putAll(objs);
        }
        catch (Exception e) {
            NucleusLogger.CACHE.debug("Objects not cached due to : " + e.getMessage());
        }
    }

    @Override
    public void removeUnique(CacheUniqueKey key) {
        this.cacheUnique.remove((Object)key);
    }
}

