/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api;

import java.io.Serializable;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.enhancement.Detachable;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.LifeCycleState;

public interface ApiAdapter
extends Serializable {
    public String getName();

    public boolean isMemberDefaultPersistent(Class var1);

    public String getXMLMetaDataForClass(AbstractClassMetaData var1, String var2, String var3);

    public String getDefaultMappingFileLocation();

    default public boolean isManaged(Object pc) {
        return this.getExecutionContext(pc) != null;
    }

    default public StateManager getStateManager(Object pc) {
        if (pc == null) {
            return null;
        }
        if (pc instanceof Persistable) {
            return ((Persistable)pc).dnGetStateManager();
        }
        return null;
    }

    public ExecutionContext getExecutionContext(Object var1);

    public LifeCycleState getLifeCycleState(int var1);

    default public boolean isPersistent(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsPersistent() : false;
    }

    default public boolean isNew(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsNew() : false;
    }

    default public boolean isDirty(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsDirty() : false;
    }

    default public boolean isDeleted(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsDeleted() : false;
    }

    default public boolean isDetached(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsDetached() : false;
    }

    default public boolean isTransactional(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsTransactional() : false;
    }

    default public boolean isPersistable(Object obj) {
        return obj == null ? false : obj instanceof Persistable;
    }

    default public boolean isPersistable(Class cls) {
        return cls == null ? false : Persistable.class.isAssignableFrom(cls);
    }

    default public boolean isDetachable(Object obj) {
        return obj == null ? false : obj instanceof Detachable;
    }

    default public String getObjectState(Object pc) {
        if (pc == null) {
            return null;
        }
        if (this.isDetached(pc)) {
            if (this.isDirty(pc)) {
                return "detached-dirty";
            }
            return "detached-clean";
        }
        if (this.isPersistent(pc)) {
            if (this.isTransactional(pc)) {
                if (this.isDirty(pc)) {
                    if (this.isNew(pc)) {
                        if (this.isDeleted(pc)) {
                            return "persistent-new-deleted";
                        }
                        return "persistent-new";
                    }
                    if (this.isDeleted(pc)) {
                        return "persistent-deleted";
                    }
                    return "persistent-dirty";
                }
                return "persistent-clean";
            }
            if (this.isDirty(pc)) {
                return "persistent-nontransactional-dirty";
            }
            return "hollow/persistent-nontransactional";
        }
        if (this.isTransactional(pc)) {
            if (this.isDirty(pc)) {
                return "transient-dirty";
            }
            return "transient-clean";
        }
        return "transient";
    }

    default public void makeDirty(Object obj, String member) {
        ((Persistable)obj).dnMakeDirty(member);
    }

    default public Object getIdForObject(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnGetObjectId() : null;
    }

    default public Object getVersionForObject(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnGetVersion() : null;
    }

    public boolean isValidPrimaryKeyClass(Class var1, AbstractClassMetaData var2, ClassLoaderResolver var3, int var4, MetaDataManager var5);

    default public void copyKeyFieldsFromIdToObject(Object pc, Persistable.ObjectIdFieldConsumer fm, Object id) {
        ((Persistable)pc).dnCopyKeyFieldsFromObjectId(fm, id);
    }

    public boolean allowPersistOfDeletedObject();

    public boolean allowDeleteOfNonPersistentObject();

    public boolean allowReadFieldOfDeletedObject();

    public boolean clearLoadedFlagsOnDeleteObject();

    public boolean getDefaultCascadePersistForField();

    public boolean getDefaultCascadeDeleteForField();

    public boolean getDefaultCascadeAttachForField();

    public boolean getDefaultCascadeDetachForField();

    public boolean getDefaultCascadeRefreshForField();

    public boolean getDefaultDFGForPersistableField();

    public Map getDefaultFactoryProperties();

    public boolean getDefaultPersistentPropertyWhenNotSpecified();

    public RuntimeException getApiExceptionForNucleusException(NucleusException var1);

    public RuntimeException getUserExceptionForException(String var1, Exception var2);

    public RuntimeException getDataStoreExceptionForException(String var1, Exception var2);
}

