/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.NullifyRelationFieldManager;
import org.datanucleus.store.fieldmanager.ReachabilityFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ReachabilityAtCommitHandler {
    private ExecutionContext ec;
    private boolean executing = false;
    private Set persistedIds = null;
    private Set deletedIds = null;
    private Set flushedNewIds = null;
    private Set enlistedIds = null;

    public ReachabilityAtCommitHandler(ExecutionContext ec) {
        this.ec = ec;
        this.persistedIds = ec.getMultithreaded() ? ConcurrentHashMap.newKeySet() : new HashSet();
        this.deletedIds = ec.getMultithreaded() ? ConcurrentHashMap.newKeySet() : new HashSet();
        this.flushedNewIds = ec.getMultithreaded() ? ConcurrentHashMap.newKeySet() : new HashSet();
        this.enlistedIds = ec.getMultithreaded() ? ConcurrentHashMap.newKeySet() : new HashSet();
    }

    public void clear() {
        this.persistedIds.clear();
        this.deletedIds.clear();
        this.flushedNewIds.clear();
        this.enlistedIds.clear();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void addEnlistedObject(Object id) {
        this.enlistedIds.add(id);
    }

    public boolean isObjectEnlisted(Object id) {
        return this.enlistedIds.contains(id);
    }

    public void addPersistedObject(Object id) {
        this.persistedIds.add(id);
    }

    public boolean isObjectPersisted(Object id) {
        return this.persistedIds.contains(id);
    }

    public void addDeletedObject(Object id) {
        this.deletedIds.add(id);
    }

    public boolean isObjectDeleted(Object id) {
        return this.deletedIds.contains(id);
    }

    public void addFlushedNewObject(Object id) {
        this.flushedNewIds.add(id);
    }

    public boolean isObjectFlushedNew(Object id) {
        return this.flushedNewIds.contains(id);
    }

    public void swapObjectId(Object oldID, Object newID) {
        if (oldID != null) {
            if (this.enlistedIds.remove(oldID)) {
                this.enlistedIds.add(newID);
            }
            if (this.flushedNewIds.remove(oldID)) {
                this.flushedNewIds.add(newID);
            }
            if (this.persistedIds.remove(oldID)) {
                this.persistedIds.add(newID);
            }
            if (this.deletedIds.remove(oldID)) {
                this.deletedIds.add(newID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.executing = true;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010032"));
            }
            if (!this.persistedIds.isEmpty() && !this.flushedNewIds.isEmpty()) {
                HashSet<Object> currentReachableIds = new HashSet<Object>();
                Object[] ids = this.persistedIds.toArray();
                HashSet<Object> objectIdsNotFound = new HashSet<Object>();
                for (int i = 0; i < ids.length; ++i) {
                    if (this.deletedIds.contains(ids[i])) continue;
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug("Performing reachability algorithm on object with id \"" + ids[i] + "\"");
                    }
                    try {
                        DNStateManager sm = this.ec.findStateManager(this.ec.findObject(ids[i], true, true, null));
                        if (sm.isDeleted() || currentReachableIds.contains(ids[i])) continue;
                        sm.loadUnloadedRelationFields();
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(Localiser.msg("007000", IdentityUtils.getPersistableIdentityForId(ids[i]), sm.getLifecycleState()));
                        }
                        currentReachableIds.add(ids[i]);
                        ReachabilityFieldManager pcFM = new ReachabilityFieldManager(sm, currentReachableIds);
                        int[] relationFieldNums = sm.getClassMetaData().getRelationMemberPositions(this.ec.getClassLoaderResolver());
                        if (relationFieldNums == null || relationFieldNums.length <= 0) continue;
                        sm.provideFields(relationFieldNums, pcFM);
                        continue;
                    }
                    catch (NucleusObjectNotFoundException ex) {
                        objectIdsNotFound.add(ids[i]);
                    }
                }
                this.flushedNewIds.removeAll(currentReachableIds);
                Object[] nonReachableIds = this.flushedNewIds.toArray();
                if (nonReachableIds != null && nonReachableIds.length > 0) {
                    DNStateManager sm2;
                    int i;
                    for (i = 0; i < nonReachableIds.length; ++i) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010033", IdentityUtils.getPersistableIdentityForId(nonReachableIds[i])));
                        }
                        try {
                            if (objectIdsNotFound.contains(nonReachableIds[i]) || (sm2 = this.ec.findStateManager(this.ec.findObject(nonReachableIds[i], true, true, null))).getLifecycleState().isDeleted() || this.ec.getApiAdapter().isDetached(sm2.getObject())) continue;
                            sm2.replaceFields(sm2.getClassMetaData().getRelationMemberPositions(this.ec.getClassLoaderResolver()), new NullifyRelationFieldManager(sm2));
                            this.ec.flush();
                            continue;
                        }
                        catch (NucleusObjectNotFoundException sm2) {
                            // empty catch block
                        }
                    }
                    for (i = 0; i < nonReachableIds.length; ++i) {
                        try {
                            if (objectIdsNotFound.contains(nonReachableIds[i]) || (sm2 = this.ec.findStateManager(this.ec.findObject(nonReachableIds[i], true, true, null))).isDeleted()) continue;
                            sm2.makeTransientForReachability();
                            continue;
                        }
                        catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                this.ec.flushInternal(true);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010034"));
            }
        }
        finally {
            this.executing = false;
        }
    }
}

