/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassLoaderResolverImpl;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.api.ApiAdapterFactory;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.properties.CorePropertyValidator;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.TypeManagerImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractNucleusContext
implements NucleusContext {
    protected final Configuration config;
    protected final PluginManager pluginManager;
    protected MetaDataManager metaDataManager = null;
    protected final ApiAdapter apiAdapter;
    protected TypeManager typeManager;
    protected final String classLoaderResolverClassName;
    protected transient Map<String, ClassLoaderResolver> classLoaderResolverMap = new ConcurrentHashMap<String, ClassLoaderResolver>();
    public static final Set<String> STARTUP_PROPERTIES = new HashSet<String>();

    public AbstractNucleusContext(String apiName, Map startupProps, PluginManager pluginMgr) {
        String clrName;
        this.pluginManager = pluginMgr != null ? pluginMgr : PluginManager.createPluginManager(startupProps, this.getClass().getClassLoader());
        this.config = new Configuration(this);
        if (startupProps != null && !startupProps.isEmpty()) {
            this.config.setPersistenceProperties(startupProps);
        }
        if ("datanucleus".equalsIgnoreCase(clrName = this.config.getStringProperty("datanucleus.classLoaderResolverName"))) {
            this.classLoaderResolverClassName = ClassLoaderResolverImpl.class.getName();
        } else if (clrName != null) {
            this.classLoaderResolverClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.classloader_resolver", "name", clrName, "class-name");
            if (this.classLoaderResolverClassName == null) {
                throw new NucleusUserException(Localiser.msg("001001", clrName)).setFatal();
            }
        } else {
            this.classLoaderResolverClassName = null;
        }
        if (apiName != null) {
            this.apiAdapter = ApiAdapterFactory.getInstance().getApiAdapter(apiName, this.pluginManager);
            this.config.setDefaultProperties(this.apiAdapter.getDefaultFactoryProperties());
        } else {
            this.apiAdapter = null;
        }
    }

    @Override
    public void applyDefaultProperties(Configuration conf) {
        conf.addDefaultProperty("datanucleus.plugin.pluginRegistryClassName", null, null, null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.plugin.allowUserBundles", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.plugin.validatePlugins", null, false, false, false);
        conf.addDefaultProperty("datanucleus.plugin.pluginRegistryBundleCheck", null, "EXCEPTION", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultProperty("datanucleus.classLoaderResolverName", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.primaryClassLoader", null, null, null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.ignoreMetaDataForMissingClasses", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.alwaysDetachable", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.xml.validate", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.xml.namespaceAware", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.autoregistration", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.allowXML", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.allowAnnotations", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.defaultNullable", null, true, true, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.allowLoadAtRuntime", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.supportORM", null, null, false, false);
        conf.addDefaultProperty("datanucleus.metadata.jdoFileExtension", null, "jdo", null, false, false);
        conf.addDefaultProperty("datanucleus.metadata.ormFileExtension", null, "orm", null, false, false);
        conf.addDefaultProperty("datanucleus.metadata.jdoqueryFileExtension", null, "jdoquery", null, false, false);
        conf.addDefaultProperty("datanucleus.metadata.defaultInheritanceStrategy", null, "JDO2", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.embedded.flat", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.useDiscriminatorForSingleTable", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.useDiscriminatorClassNameByDefault", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.javaxValidationShortcuts", null, false, false, false);
    }

    @Override
    public synchronized void initialise() {
        this.logConfiguration();
    }

    @Override
    public void close() {
        if (this.typeManager != null) {
            this.typeManager.close();
        }
    }

    @Override
    public ApiAdapter getApiAdapter() {
        return this.apiAdapter;
    }

    @Override
    public String getApiName() {
        return this.apiAdapter != null ? this.apiAdapter.getName() : null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public synchronized MetaDataManager getMetaDataManager() {
        if (this.metaDataManager == null) {
            String apiName = this.getApiName();
            try {
                this.metaDataManager = (MetaDataManager)this.pluginManager.createExecutableExtension("org.datanucleus.metadata_manager", new String[]{"name"}, new String[]{apiName}, "class", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this});
                if (this.metaDataManager != null && this.config.hasProperty("datanucleus.metadata.listener.object")) {
                    MetaDataListener mdl = (MetaDataListener)this.config.getProperty("datanucleus.metadata.listener.object");
                    this.metaDataManager.registerListener(mdl);
                }
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg("008010", apiName, e.getMessage()), e);
            }
            if (this.metaDataManager == null) {
                throw new NucleusException(Localiser.msg("008009", apiName));
            }
        }
        return this.metaDataManager;
    }

    @Override
    public boolean supportsORMMetaData() {
        return true;
    }

    @Override
    public TypeManager getTypeManager() {
        if (this.typeManager == null) {
            this.typeManager = new TypeManagerImpl(this);
        }
        return this.typeManager;
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver(ClassLoader primaryLoader) {
        ClassLoaderResolver clr;
        Object key;
        String resolverName = this.config.getStringProperty("datanucleus.classLoaderResolverName");
        Object object = key = resolverName != null ? resolverName : "datanucleus";
        if (primaryLoader != null) {
            key = (String)key + ":[" + StringUtils.toJVMIDString(primaryLoader) + "]";
        }
        if (this.classLoaderResolverMap == null) {
            this.classLoaderResolverMap = new HashMap<String, ClassLoaderResolver>();
        }
        if ((clr = this.classLoaderResolverMap.get(key)) != null) {
            return clr;
        }
        if (resolverName == null) {
            clr = new ClassLoaderResolverImpl(primaryLoader);
        } else {
            try {
                clr = (ClassLoaderResolver)this.pluginManager.createExecutableExtension("org.datanucleus.classloader_resolver", "name", resolverName, "class-name", new Class[]{ClassLoader.class}, new Object[]{primaryLoader});
            }
            catch (ClassNotFoundException cnfe) {
                throw new NucleusUserException(Localiser.msg("001002", this.classLoaderResolverClassName), cnfe).setFatal();
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("001003", this.classLoaderResolverClassName), e).setFatal();
            }
        }
        clr.registerUserClassLoader((ClassLoader)this.config.getProperty("datanucleus.primaryClassLoader"));
        this.classLoaderResolverMap.put((String)key, clr);
        return clr;
    }

    protected void logConfiguration() {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug("================= NucleusContext ===============");
            String javaVersion = System.getProperty("java.version");
            if (StringUtils.isWhitespace(javaVersion)) {
                javaVersion = "unknown";
            }
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("008000", this.pluginManager.getVersionForBundle("org.datanucleus"), javaVersion, System.getProperty("os.name")));
            NucleusLogger.PERSISTENCE.debug("Persistence API : " + this.getApiName());
            if (this.config.hasPropertyNotNull("datanucleus.PersistenceUnitName")) {
                NucleusLogger.PERSISTENCE.debug("Persistence-Unit : " + this.config.getStringProperty("datanucleus.PersistenceUnitName"));
            }
            NucleusLogger.PERSISTENCE.debug("Plugin Registry : " + this.pluginManager.getRegistryClassName());
            Object primCL = this.config.getProperty("datanucleus.primaryClassLoader");
            String clrName = this.config.getStringProperty("datanucleus.classLoaderResolverName");
            if (clrName == null) {
                clrName = "default";
            }
            NucleusLogger.PERSISTENCE.debug("ClassLoading : " + clrName + (String)(primCL != null ? "primary=" + primCL : ""));
            this.logConfigurationDetails();
            NucleusLogger.PERSISTENCE.debug("================================================");
        }
    }

    protected abstract void logConfigurationDetails();

    static {
        STARTUP_PROPERTIES.add("datanucleus.plugin.pluginRegistryClassName");
        STARTUP_PROPERTIES.add("datanucleus.plugin.pluginRegistryBundleCheck");
        STARTUP_PROPERTIES.add("datanucleus.plugin.allowUserBundles");
        STARTUP_PROPERTIES.add("datanucleus.plugin.validatePlugins");
        STARTUP_PROPERTIES.add("datanucleus.classLoaderResolverName");
        STARTUP_PROPERTIES.add("datanucleus.persistenceXmlFilename");
        STARTUP_PROPERTIES.add("datanucleus.primaryClassLoader");
        STARTUP_PROPERTIES.add("datanucleus.metadata.listener.object");
    }
}

