/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.compiler.AbstractParser;
import org.datanucleus.query.compiler.Lexer;
import org.datanucleus.query.compiler.Node;
import org.datanucleus.query.compiler.NodeType;
import org.datanucleus.query.compiler.ParameterNode;
import org.datanucleus.store.query.QueryCompilerSyntaxException;

public class JPQLParser
extends AbstractParser {
    private static String paramPrefixes = ":?";
    int parameterPosition = 0;

    @Override
    public Node parse(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, false);
        this.stack = new ArrayDeque();
        Node result = this.processExpression();
        if (this.lexer.ci.getIndex() != this.lexer.ci.getEndIndex()) {
            throw new QueryCompilerSyntaxException("Portion of expression could not be parsed: " + this.lexer.getInput().substring(this.lexer.ci.getIndex()));
        }
        return result;
    }

    @Override
    public Node parseVariable(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, false);
        this.stack = new ArrayDeque();
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.lexer.getIndex(), this.lexer.getInput());
        }
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.lexer.getIndex(), this.lexer.getInput());
        }
        Node nodeVariable = (Node)this.stack.pop();
        Node nodeType = (Node)this.stack.pop();
        nodeType.appendChildNode(nodeVariable);
        return nodeType;
    }

    @Override
    public Node[] parseFrom(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, false);
        this.stack = new ArrayDeque();
        return this.processFromExpression();
    }

    @Override
    public Node[] parseUpdate(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, false);
        this.stack = new ArrayDeque();
        return this.parseTuple(expression);
    }

    @Override
    public Node[] parseOrder(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, false);
        this.stack = new ArrayDeque();
        return this.processOrderExpression();
    }

    @Override
    public Node[] parseResult(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, false);
        this.stack = new ArrayDeque();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node node = (Node)this.stack.pop();
            String alias = this.lexer.parseIdentifier();
            if (alias != null && alias.equalsIgnoreCase("AS")) {
                alias = this.lexer.parseIdentifier();
            }
            if (alias != null) {
                Node aliasNode = new Node(NodeType.NAME, alias.toLowerCase());
                node.appendChildNode(aliasNode);
            }
            nodes.add(node);
        } while (this.lexer.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    @Override
    public Node[] parseTuple(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, false);
        this.stack = new ArrayDeque();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node node = (Node)this.stack.pop();
            nodes.add(node);
        } while (this.lexer.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    @Override
    public Node[][] parseVariables(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, false);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.processPrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.lexer.getIndex(), this.lexer.getInput());
            }
            if (!this.processIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.lexer.getIndex(), this.lexer.getInput());
            }
            Node nodeVariable = (Node)this.stack.pop();
            Node nodeType = (Node)this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.lexer.parseString(";"));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    @Override
    public Node[][] parseParameters(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, false);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.processPrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.lexer.getIndex(), this.lexer.getInput());
            }
            if (!this.processIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.lexer.getIndex(), this.lexer.getInput());
            }
            Node nodeVariable = (Node)this.stack.pop();
            Node nodeType = (Node)this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.lexer.parseString(","));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    private Node[] processFromExpression() {
        String candidateClassName = null;
        String candidateAlias = null;
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            if (this.lexer.peekStringIgnoreCase("IN(") || this.lexer.peekStringIgnoreCase("IN ")) {
                Node joinedNode;
                this.lexer.parseStringIgnoreCase("IN");
                if (!this.lexer.parseChar('(')) {
                    throw new QueryCompilerSyntaxException("Expected: '(' but got " + this.lexer.remaining(), this.lexer.getIndex(), this.lexer.getInput());
                }
                String name = this.lexer.parseIdentifier();
                Node parentNode = joinedNode = new Node(NodeType.IDENTIFIER, name);
                while (this.lexer.nextIsDot()) {
                    this.lexer.parseChar('.');
                    String subName = this.lexer.parseIdentifier();
                    Node subNode = new Node(NodeType.IDENTIFIER, subName);
                    parentNode.appendChildNode(subNode);
                    parentNode = subNode;
                }
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("Expected: ')' but got " + this.lexer.remaining(), this.lexer.getIndex(), this.lexer.getInput());
                }
                this.lexer.parseStringIgnoreCase("AS");
                String alias = this.lexer.parseIdentifier();
                Node classNode = new Node(NodeType.CLASS, candidateClassName);
                Node classAliasNode = new Node(NodeType.NAME, candidateAlias);
                classNode.insertChildNode(classAliasNode);
                this.stack.push(classNode);
                Node joinNode = new Node(NodeType.OPERATOR, "JOIN_INNER");
                joinNode.appendChildNode(joinedNode);
                Node joinAliasNode = new Node(NodeType.NAME, alias);
                joinNode.appendChildNode(joinAliasNode);
                classNode.appendChildNode(joinNode);
                this.processFromJoinExpression();
                nodes.add(classNode);
                continue;
            }
            this.processExpression();
            Node id = (Node)this.stack.pop();
            StringBuilder className = new StringBuilder(id.getNodeValue().toString());
            while (!id.getChildNodes().isEmpty()) {
                id = id.getFirstChild();
                className.append(".").append(id.getNodeValue().toString());
            }
            String alias = this.lexer.parseIdentifier();
            if (alias != null && alias.equalsIgnoreCase("AS")) {
                alias = this.lexer.parseIdentifier();
            }
            if (candidateClassName == null) {
                candidateClassName = className.toString();
                candidateAlias = alias;
            }
            Node classNode = new Node(NodeType.CLASS, className.toString());
            Node aliasNode = new Node(NodeType.NAME, alias);
            classNode.insertChildNode(aliasNode);
            this.stack.push(classNode);
            this.processFromJoinExpression();
            nodes.add(classNode);
        } while (this.lexer.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private void processFromJoinExpression() {
        Node candidateNode = (Node)this.stack.pop();
        boolean moreJoins = true;
        while (moreJoins) {
            boolean leftJoin = false;
            boolean rightJoin = false;
            boolean innerJoin = false;
            if (this.lexer.parseStringIgnoreCase("INNER ")) {
                innerJoin = true;
            } else if (this.lexer.parseStringIgnoreCase("LEFT ")) {
                this.lexer.parseStringIgnoreCase("OUTER");
                leftJoin = true;
            } else if (this.lexer.parseStringIgnoreCase("RIGHT ")) {
                this.lexer.parseStringIgnoreCase("OUTER");
                rightJoin = true;
            }
            if (this.lexer.parseStringIgnoreCase("JOIN ")) {
                Node joinedAliasNode;
                String alias;
                if (!(innerJoin || leftJoin || rightJoin)) {
                    innerJoin = true;
                }
                boolean fetch = false;
                if (this.lexer.parseStringIgnoreCase("FETCH")) {
                    fetch = true;
                }
                String joinType = "JOIN_INNER";
                if (innerJoin) {
                    joinType = fetch ? "JOIN_INNER_FETCH" : "JOIN_INNER";
                } else if (leftJoin) {
                    joinType = fetch ? "JOIN_OUTER_FETCH" : "JOIN_OUTER";
                } else if (rightJoin) {
                    joinType = fetch ? "JOIN_OUTER_FETCH_RIGHT" : "JOIN_OUTER_RIGHT";
                }
                Node joinNode = new Node(NodeType.OPERATOR, joinType);
                if (this.processTreat()) {
                    Node treatNode = (Node)this.stack.pop();
                    joinNode.appendChildNode(treatNode);
                    this.lexer.parseStringIgnoreCase("AS ");
                    alias = this.lexer.parseName();
                    joinedAliasNode = new Node(NodeType.NAME, alias);
                    joinNode.appendChildNode(joinedAliasNode);
                } else if (this.processKey()) {
                    Node keyNode = (Node)this.stack.pop();
                    joinNode.appendChildNode(keyNode);
                    this.lexer.parseStringIgnoreCase("AS ");
                    alias = this.lexer.parseName();
                    joinedAliasNode = new Node(NodeType.NAME, alias);
                    joinNode.appendChildNode(joinedAliasNode);
                } else if (this.processValue()) {
                    Node valNode = (Node)this.stack.pop();
                    joinNode.appendChildNode(valNode);
                    this.lexer.parseStringIgnoreCase("AS ");
                    alias = this.lexer.parseName();
                    joinedAliasNode = new Node(NodeType.NAME, alias);
                    joinNode.appendChildNode(joinedAliasNode);
                } else {
                    Node joinedNode;
                    String id = this.lexer.parseIdentifier();
                    Node parentNode = joinedNode = new Node(NodeType.IDENTIFIER, id);
                    while (this.lexer.nextIsDot()) {
                        this.lexer.parseChar('.');
                        Node subNode = new Node(NodeType.IDENTIFIER, this.lexer.parseName());
                        parentNode.appendChildNode(subNode);
                        parentNode = subNode;
                    }
                    joinNode.appendChildNode(joinedNode);
                    this.lexer.parseStringIgnoreCase("AS ");
                    String alias2 = this.lexer.parseName();
                    Node joinedAliasNode2 = new Node(NodeType.NAME, alias2);
                    joinNode.appendChildNode(joinedAliasNode2);
                }
                if (this.lexer.parseStringIgnoreCase("ON ")) {
                    this.processExpression();
                    Node onNode = (Node)this.stack.pop();
                    joinNode.appendChildNode(onNode);
                }
                candidateNode.appendChildNode(joinNode);
                continue;
            }
            if (innerJoin || leftJoin) {
                throw new NucleusUserException("Expected JOIN after INNER/LEFT keyword at" + this.lexer.remaining());
            }
            moreJoins = false;
        }
        this.stack.push(candidateNode);
    }

    private Node[] processOrderExpression() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node directionNode = null;
            directionNode = this.lexer.parseStringIgnoreCase("asc") ? new Node(NodeType.OPERATOR, "ascending") : (this.lexer.parseStringIgnoreCase("desc") ? new Node(NodeType.OPERATOR, "descending") : new Node(NodeType.OPERATOR, "ascending"));
            Node nullsNode = null;
            if (this.lexer.parseStringIgnoreCase("NULLS FIRST")) {
                nullsNode = new Node(NodeType.OPERATOR, "NULLS FIRST");
            } else if (this.lexer.parseStringIgnoreCase("NULLS LAST")) {
                nullsNode = new Node(NodeType.OPERATOR, "NULLS LAST");
            }
            Node expr = new Node(NodeType.OPERATOR, "order");
            expr.insertChildNode(directionNode);
            if (nullsNode != null) {
                expr.appendChildNode(nullsNode);
            }
            if (!this.stack.isEmpty()) {
                expr.insertChildNode((Node)this.stack.pop());
            }
            nodes.add(expr);
        } while (this.lexer.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node processExpression() {
        this.processOrExpression();
        return (Node)this.stack.peek();
    }

    private void processOrExpression() {
        this.processAndExpression();
        while (this.lexer.parseStringIgnoreCase("OR ")) {
            this.processAndExpression();
            Node expr = new Node(NodeType.OPERATOR, "||");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processAndExpression() {
        this.processRelationalExpression();
        while (this.lexer.parseStringIgnoreCase("AND ")) {
            this.processRelationalExpression();
            Node expr = new Node(NodeType.OPERATOR, "&&");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processRelationalExpression() {
        this.processAdditiveExpression();
        while (true) {
            Node expr;
            Node betweenNode;
            Node rightNode;
            Node leftNode;
            Node lowerNode;
            Node inputNode;
            Node expr2;
            Node left;
            Node right;
            if (this.lexer.parseString("=")) {
                Node primNode;
                this.processAdditiveExpression();
                right = (Node)this.stack.pop();
                left = (Node)this.stack.pop();
                if (right.getNodeType() == NodeType.TYPE) {
                    primNode = right.getFirstChild();
                    expr2 = new Node(NodeType.OPERATOR, "instanceof");
                    expr2.appendChildNode(primNode);
                    expr2.appendChildNode(left);
                    this.stack.push(expr2);
                    continue;
                }
                if (left.getNodeType() == NodeType.TYPE) {
                    primNode = left.getFirstChild();
                    expr2 = new Node(NodeType.OPERATOR, "instanceof");
                    expr2.appendChildNode(primNode);
                    expr2.appendChildNode(right);
                    this.stack.push(expr2);
                    continue;
                }
                Node expr3 = new Node(NodeType.OPERATOR, "==");
                expr3.insertChildNode(right);
                expr3.insertChildNode(left);
                this.stack.push(expr3);
                continue;
            }
            if (this.lexer.parseString("<>")) {
                Node notNode;
                Node primNode;
                this.processAdditiveExpression();
                right = (Node)this.stack.pop();
                left = (Node)this.stack.pop();
                if (right.getNodeType() == NodeType.TYPE) {
                    primNode = right.getFirstChild();
                    expr2 = new Node(NodeType.OPERATOR, "instanceof");
                    expr2.appendChildNode(primNode);
                    expr2.appendChildNode(left);
                    notNode = new Node(NodeType.OPERATOR, "!");
                    notNode.appendChildNode(expr2);
                    this.stack.push(notNode);
                    continue;
                }
                if (left.getNodeType() == NodeType.TYPE) {
                    primNode = left.getFirstChild();
                    expr2 = new Node(NodeType.OPERATOR, "instanceof");
                    expr2.appendChildNode(primNode);
                    expr2.appendChildNode(right);
                    notNode = new Node(NodeType.OPERATOR, "!");
                    notNode.appendChildNode(expr2);
                    this.stack.push(notNode);
                    continue;
                }
                Node expr4 = new Node(NodeType.OPERATOR, "!=");
                expr4.insertChildNode(right);
                expr4.insertChildNode(left);
                this.stack.push(expr4);
                continue;
            }
            if (this.lexer.parseStringIgnoreCase("NOT ")) {
                if (this.lexer.parseStringIgnoreCase("BETWEEN ")) {
                    inputNode = (Node)this.stack.pop();
                    this.processAdditiveExpression();
                    lowerNode = (Node)this.stack.pop();
                    if (this.lexer.parseStringIgnoreCase("AND ")) {
                        this.processAdditiveExpression();
                        Node upperNode = (Node)this.stack.pop();
                        leftNode = new Node(NodeType.OPERATOR, "<");
                        leftNode.appendChildNode(inputNode);
                        leftNode.appendChildNode(lowerNode);
                        rightNode = new Node(NodeType.OPERATOR, ">");
                        rightNode.appendChildNode(inputNode);
                        rightNode.appendChildNode(upperNode);
                        betweenNode = new Node(NodeType.OPERATOR, "||");
                        betweenNode.appendChildNode(leftNode);
                        betweenNode.appendChildNode(rightNode);
                        this.stack.push(betweenNode);
                        continue;
                    }
                    throw new NucleusUserException("Query has BETWEEN keyword with no AND clause");
                }
                if (this.lexer.parseStringIgnoreCase("LIKE ")) {
                    this.processLikeExpression();
                    Node notNode = new Node(NodeType.OPERATOR, "!");
                    notNode.insertChildNode((Node)this.stack.pop());
                    this.stack.push(notNode);
                    continue;
                }
                if (this.lexer.parseStringIgnoreCase("IN")) {
                    this.processInExpression(true);
                    continue;
                }
                if (this.lexer.parseStringIgnoreCase("MEMBER ")) {
                    this.processMemberExpression(true);
                    continue;
                }
                throw new NucleusException("Unsupported query syntax NOT followed by unsupported keyword");
            }
            if (this.lexer.parseStringIgnoreCase("BETWEEN ")) {
                inputNode = (Node)this.stack.pop();
                this.processAdditiveExpression();
                lowerNode = (Node)this.stack.pop();
                if (this.lexer.parseStringIgnoreCase("AND ")) {
                    this.processAdditiveExpression();
                    Node upperNode = (Node)this.stack.pop();
                    leftNode = new Node(NodeType.OPERATOR, ">=");
                    leftNode.appendChildNode(inputNode);
                    leftNode.appendChildNode(lowerNode);
                    rightNode = new Node(NodeType.OPERATOR, "<=");
                    rightNode.appendChildNode(inputNode);
                    rightNode.appendChildNode(upperNode);
                    betweenNode = new Node(NodeType.OPERATOR, "&&");
                    betweenNode.appendChildNode(rightNode);
                    betweenNode.appendChildNode(leftNode);
                    this.stack.push(betweenNode);
                    continue;
                }
                throw new NucleusUserException("Query has BETWEEN keyword with no AND clause");
            }
            if (this.lexer.parseStringIgnoreCase("LIKE ")) {
                this.processLikeExpression();
                continue;
            }
            if (this.lexer.parseStringIgnoreCase("IN")) {
                this.processInExpression(false);
                continue;
            }
            if (this.lexer.parseStringIgnoreCase("MEMBER ")) {
                this.processMemberExpression(false);
                continue;
            }
            if (this.lexer.parseStringIgnoreCase("IS ")) {
                Node inputRootNode = inputNode = (Node)this.stack.pop();
                if (inputNode.getNodeType() == NodeType.IDENTIFIER) {
                    while (inputNode.getFirstChild() != null) {
                        inputNode = inputNode.getFirstChild();
                    }
                }
                boolean not = false;
                if (this.lexer.parseStringIgnoreCase("NOT ")) {
                    not = true;
                }
                if (this.lexer.parseStringIgnoreCase("NULL")) {
                    Node isNode = new Node(NodeType.OPERATOR, not ? "!=" : "==");
                    Node compareNode = new Node(NodeType.LITERAL, null);
                    isNode.insertChildNode(compareNode);
                    isNode.insertChildNode(inputRootNode);
                    this.stack.push(isNode);
                    continue;
                }
                if (this.lexer.parseStringIgnoreCase("EMPTY")) {
                    Node sizeNode = new Node(NodeType.INVOKE, "size");
                    inputNode.insertChildNode(sizeNode);
                    Node isEmptyNode = new Node(NodeType.OPERATOR, not ? "!=" : "==");
                    isEmptyNode.appendChildNode(inputRootNode);
                    Node zeroNode = new Node(NodeType.LITERAL, 0);
                    isEmptyNode.appendChildNode(zeroNode);
                    this.stack.push(isEmptyNode);
                    continue;
                }
                throw new NucleusException("Encountered IS " + (not ? "NOT " : " ") + " that should be followed by NULL | EMPTY but isnt");
            }
            if (this.lexer.parseString("<=")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "<=");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.lexer.parseString(">=")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, ">=");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.lexer.parseChar('<')) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "<");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.lexer.parseChar('>')) break;
            this.processAdditiveExpression();
            expr = new Node(NodeType.OPERATOR, ">");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processLikeExpression() {
        Node primaryNode;
        Node primaryRootNode = primaryNode = (Node)this.stack.pop();
        if (primaryNode.getNodeType() == NodeType.IDENTIFIER) {
            while (primaryNode.getFirstChild() != null) {
                primaryNode = primaryNode.getFirstChild();
            }
        }
        this.processAdditiveExpression();
        Node likeExprNode = (Node)this.stack.pop();
        if (this.lexer.parseStringIgnoreCase("ESCAPE")) {
            this.processAdditiveExpression();
            Node escapeNode = (Node)this.stack.pop();
            Node matchesNode = new Node(NodeType.INVOKE, "matches");
            matchesNode.addProperty(likeExprNode);
            matchesNode.addProperty(escapeNode);
            primaryNode.appendChildNode(matchesNode);
            this.stack.push(primaryRootNode);
        } else {
            Node matchesNode = new Node(NodeType.INVOKE, "matches");
            matchesNode.addProperty(likeExprNode);
            primaryNode.appendChildNode(matchesNode);
            this.stack.push(primaryRootNode);
        }
    }

    private void processInExpression(boolean not) {
        Object inNode;
        Node inputNode = (Node)this.stack.pop();
        boolean usesType = false;
        if (inputNode.getNodeType() == NodeType.TYPE) {
            usesType = true;
        }
        if (!this.lexer.parseChar('(')) {
            Node inNode2;
            this.processPrimary();
            Node subqueryNode = (Node)this.stack.pop();
            if (usesType) {
                inNode2 = new Node(NodeType.OPERATOR, "instanceof");
                inNode2.appendChildNode(inputNode.getFirstChild());
                inNode2.appendChildNode(subqueryNode);
                if (not) {
                    Node notNode = new Node(NodeType.OPERATOR, "!");
                    notNode.appendChildNode(inNode2);
                    inNode2 = notNode;
                }
            } else {
                inNode2 = new Node(NodeType.OPERATOR, not ? "NOT IN" : "IN");
                inNode2.appendChildNode(inputNode);
                inNode2.appendChildNode(subqueryNode);
            }
            this.stack.push(inNode2);
            return;
        }
        ArrayList<Node> valueNodes = new ArrayList<Node>();
        do {
            this.processPrimary();
            if (this.stack.peek() == null) {
                throw new QueryCompilerSyntaxException("Expected literal|parameter but got " + this.lexer.remaining(), this.lexer.getIndex(), this.lexer.getInput());
            }
            Node valueNode = (Node)this.stack.pop();
            valueNodes.add(valueNode);
            this.lexer.skipWS();
        } while (this.lexer.parseChar(','));
        if (!this.lexer.parseChar(')')) {
            throw new QueryCompilerSyntaxException("Expected: ')' but got " + this.lexer.remaining(), this.lexer.getIndex(), this.lexer.getInput());
        }
        if (valueNodes.isEmpty()) {
            throw new QueryCompilerSyntaxException("IN expression had zero arguments!");
        }
        if (usesType) {
            inNode = new Node(NodeType.OPERATOR, "instanceof");
            ((Node)inNode).appendChildNode(inputNode.getFirstChild());
            for (Node valueNode : valueNodes) {
                ((Node)inNode).appendChildNode(valueNode);
            }
            if (not) {
                Node notNode = new Node(NodeType.OPERATOR, "!");
                notNode.appendChildNode((Node)inNode);
                inNode = notNode;
            }
            this.stack.push(inNode);
            return;
        }
        inNode = null;
        Node firstValueNode = (Node)valueNodes.get(0);
        if (valueNodes.size() == 1 && firstValueNode.getNodeType() != NodeType.LITERAL) {
            inNode = new Node(NodeType.OPERATOR, not ? "NOT IN" : "IN");
            ((Node)inNode).appendChildNode(inputNode);
            ((Node)inNode).appendChildNode((Node)valueNodes.get(0));
        } else {
            for (Node valueNode : valueNodes) {
                Node compareNode = new Node(NodeType.OPERATOR, not ? "!=" : "==");
                compareNode.appendChildNode(inputNode);
                compareNode.appendChildNode(valueNode);
                if (inNode == null) {
                    inNode = compareNode;
                    continue;
                }
                Node newInNode = new Node(NodeType.OPERATOR, not ? "&&" : "||");
                newInNode.appendChildNode((Node)inNode);
                newInNode.appendChildNode(compareNode);
                inNode = newInNode;
            }
        }
        this.stack.push(inNode);
    }

    private void processMemberExpression(boolean not) {
        Node containerNode;
        Node inputNode = (Node)this.stack.pop();
        this.lexer.parseStringIgnoreCase("OF");
        this.processPrimary();
        Node lastNode = containerNode = (Node)this.stack.peek();
        while (lastNode.getFirstChild() != null) {
            lastNode = lastNode.getFirstChild();
        }
        if (not) {
            Node notNode = new Node(NodeType.OPERATOR, "!");
            this.stack.pop();
            notNode.insertChildNode(containerNode);
            this.stack.push(notNode);
        }
        Node containsNode = new Node(NodeType.INVOKE, "contains");
        containsNode.addProperty(inputNode);
        lastNode.appendChildNode(containsNode);
    }

    private void processCaseExpression() {
        Node caseNode = new Node(NodeType.CASE);
        boolean simple = true;
        if (this.lexer.peekStringIgnoreCase("WHEN ")) {
            simple = false;
        }
        if (simple) {
            Node exprNode = this.processExpression();
            this.stack.pop();
            while (this.lexer.parseStringIgnoreCase("WHEN ")) {
                this.processExpression();
                Node eqCondNode = (Node)this.stack.pop();
                Node whenNode = new Node(NodeType.OPERATOR, "==");
                whenNode.insertChildNode(exprNode.clone(null));
                whenNode.insertChildNode(eqCondNode);
                caseNode.appendChildNode(whenNode);
                boolean hasThen = this.lexer.parseStringIgnoreCase("THEN ");
                if (!hasThen) {
                    throw new QueryCompilerSyntaxException("expected 'THEN' as part of CASE", this.lexer.getIndex(), this.lexer.getInput());
                }
                this.processExpression();
                Node actionNode = (Node)this.stack.pop();
                caseNode.appendChildNode(actionNode);
            }
            if (this.lexer.parseStringIgnoreCase("ELSE ")) {
                this.processExpression();
                Node elseNode = (Node)this.stack.pop();
                caseNode.appendChildNode(elseNode);
            }
            if (!this.lexer.parseStringIgnoreCase("END")) {
                throw new QueryCompilerSyntaxException("expected 'END' as part of CASE", this.lexer.getIndex(), this.lexer.getInput());
            }
        } else {
            while (this.lexer.parseStringIgnoreCase("WHEN ")) {
                this.processExpression();
                Node whenNode = (Node)this.stack.pop();
                caseNode.appendChildNode(whenNode);
                boolean hasThen = this.lexer.parseStringIgnoreCase("THEN ");
                if (!hasThen) {
                    throw new QueryCompilerSyntaxException("expected 'THEN' as part of CASE", this.lexer.getIndex(), this.lexer.getInput());
                }
                this.processExpression();
                Node actionNode = (Node)this.stack.pop();
                caseNode.appendChildNode(actionNode);
            }
            if (this.lexer.parseStringIgnoreCase("ELSE ")) {
                this.processExpression();
                Node elseNode = (Node)this.stack.pop();
                caseNode.appendChildNode(elseNode);
            }
            if (!this.lexer.parseStringIgnoreCase("END")) {
                throw new QueryCompilerSyntaxException("expected 'END' as part of CASE", this.lexer.getIndex(), this.lexer.getInput());
            }
        }
        this.stack.push(caseNode);
    }

    protected void processAdditiveExpression() {
        this.processMultiplicativeExpression();
        while (true) {
            Node expr;
            if (this.lexer.parseChar('+')) {
                this.processMultiplicativeExpression();
                expr = new Node(NodeType.OPERATOR, "+");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.lexer.parseChar('-')) break;
            this.processMultiplicativeExpression();
            expr = new Node(NodeType.OPERATOR, "-");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processMultiplicativeExpression() {
        this.processUnaryExpression();
        while (true) {
            Node expr;
            if (this.lexer.parseChar('*')) {
                this.processUnaryExpression();
                expr = new Node(NodeType.OPERATOR, "*");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.lexer.parseChar('/')) {
                this.processUnaryExpression();
                expr = new Node(NodeType.OPERATOR, "/");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.lexer.parseChar('%')) break;
            this.processUnaryExpression();
            expr = new Node(NodeType.OPERATOR, "%");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processUnaryExpression() {
        if (this.lexer.parseString("++")) {
            throw new NucleusUserException("Unsupported operator '++'");
        }
        if (this.lexer.parseString("--")) {
            throw new NucleusUserException("Unsupported operator '--'");
        }
        if (this.lexer.parseChar('+')) {
            this.processUnaryExpression();
        } else if (this.lexer.parseChar('-')) {
            this.processUnaryExpression();
            Node expr = new Node(NodeType.OPERATOR, "-");
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        } else if (this.lexer.parseStringIgnoreCase("NOT ")) {
            this.processRelationalExpression();
            Node expr = new Node(NodeType.OPERATOR, "!");
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        } else {
            this.processPrimary();
        }
    }

    protected void processPrimary() {
        String subqueryKeyword = null;
        Node subqueryNode = null;
        if (this.lexer.parseStringIgnoreCase("SOME ")) {
            subqueryKeyword = "SOME";
            this.processExpression();
            subqueryNode = (Node)this.stack.pop();
        } else if (this.lexer.parseStringIgnoreCase("ALL ")) {
            subqueryKeyword = "ALL";
            this.processExpression();
            subqueryNode = (Node)this.stack.pop();
        } else if (this.lexer.parseStringIgnoreCase("ANY ")) {
            subqueryKeyword = "ANY";
            this.processExpression();
            subqueryNode = (Node)this.stack.pop();
        } else if (this.lexer.parseStringIgnoreCase("EXISTS ")) {
            subqueryKeyword = "EXISTS";
            this.processExpression();
            subqueryNode = (Node)this.stack.pop();
        }
        if (subqueryKeyword != null && subqueryNode != null) {
            Node subNode = new Node(NodeType.SUBQUERY, subqueryKeyword);
            subNode.appendChildNode(subqueryNode);
            this.stack.push(subNode);
            return;
        }
        if (!this.strict) {
            if (this.lexer.parseStringIgnoreCase("COUNT(*)")) {
                Node node = new Node(NodeType.INVOKE, "COUNTSTAR");
                this.stack.push(node);
                return;
            }
            if (this.lexer.parseStringIgnoreCase("CURRENT_DATE()")) {
                Node node = new Node(NodeType.INVOKE, "CURRENT_DATE");
                this.stack.push(node);
                return;
            }
            if (this.lexer.parseStringIgnoreCase("CURRENT_TIMESTAMP()")) {
                Node node = new Node(NodeType.INVOKE, "CURRENT_TIMESTAMP");
                this.stack.push(node);
                return;
            }
            if (this.lexer.parseStringIgnoreCase("CURRENT_TIME()")) {
                Node node = new Node(NodeType.INVOKE, "CURRENT_TIME");
                this.stack.push(node);
                return;
            }
        }
        if (this.lexer.parseStringIgnoreCase("CURRENT_DATE")) {
            Node node = new Node(NodeType.INVOKE, "CURRENT_DATE");
            this.stack.push(node);
            return;
        }
        if (this.lexer.parseStringIgnoreCase("CURRENT_TIMESTAMP")) {
            Node node = new Node(NodeType.INVOKE, "CURRENT_TIMESTAMP");
            this.stack.push(node);
            return;
        }
        if (this.lexer.parseStringIgnoreCase("CURRENT_TIME")) {
            Node node = new Node(NodeType.INVOKE, "CURRENT_TIME");
            this.stack.push(node);
            return;
        }
        if (this.lexer.parseStringIgnoreCase("CASE ")) {
            this.processCaseExpression();
            return;
        }
        if (this.lexer.parseStringIgnoreCase("DISTINCT ")) {
            Node distinctNode = new Node(NodeType.OPERATOR, "DISTINCT");
            this.processExpression();
            Node identifierNode = (Node)this.stack.pop();
            distinctNode.appendChildNode(identifierNode);
            this.stack.push(distinctNode);
            return;
        }
        if (!this.lexer.peekStringIgnoreCase("TREAT(")) {
            if (this.processKey()) {
                return;
            }
            if (this.processValue()) {
                return;
            }
            if (this.processEntry()) {
                return;
            }
            if (this.processCreator() || this.processLiteral() || this.processMethod()) {
                return;
            }
        }
        int sizeBeforeBraceProcessing = this.stack.size();
        boolean braceProcessing = false;
        if (this.lexer.parseChar('(')) {
            this.processExpression();
            if (!this.lexer.parseChar(')')) {
                throw new QueryCompilerSyntaxException("expected ')'", this.lexer.getIndex(), this.lexer.getInput());
            }
            if (!this.lexer.parseChar('.')) {
                return;
            }
            braceProcessing = true;
        }
        if (!(this.processTreat() || this.processMethod() || this.processIdentifier())) {
            throw new QueryCompilerSyntaxException("Method/Identifier expected", this.lexer.getIndex(), this.lexer.getInput());
        }
        int size = this.stack.size();
        if (braceProcessing) {
            size = sizeBeforeBraceProcessing + 1;
        }
        while (this.lexer.parseChar('.')) {
            if (this.processMethod() || this.processIdentifier()) continue;
            throw new QueryCompilerSyntaxException("Identifier expected", this.lexer.getIndex(), this.lexer.getInput());
        }
        while (this.stack.size() > size) {
            Node top = (Node)this.stack.pop();
            Node peek = (Node)this.stack.peek();
            Node lastDescendant = JPQLParser.getLastDescendantNodeForNode(peek);
            if (lastDescendant != null) {
                lastDescendant.appendChildNode(top);
                continue;
            }
            Node primNode = new Node(NodeType.PRIMARY);
            primNode.appendChildNode(peek);
            primNode.appendChildNode(top);
            this.stack.pop();
            this.stack.push(primNode);
        }
    }

    private boolean processCreator() {
        if (this.lexer.parseStringIgnoreCase("NEW ")) {
            int size = this.stack.size();
            if (!this.processMethod()) {
                if (!this.processIdentifier()) {
                    throw new QueryCompilerSyntaxException("Identifier expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                while (this.lexer.parseChar('.')) {
                    if (this.processMethod() || this.processIdentifier()) continue;
                    throw new QueryCompilerSyntaxException("Identifier expected", this.lexer.getIndex(), this.lexer.getInput());
                }
            }
            while (this.stack.size() - 1 > size) {
                Node top = (Node)this.stack.pop();
                Node peek = (Node)this.stack.peek();
                peek.insertChildNode(top);
            }
            Node node = (Node)this.stack.pop();
            Node newNode = new Node(NodeType.CREATOR);
            newNode.insertChildNode(node);
            this.stack.push(newNode);
            return true;
        }
        return false;
    }

    protected boolean processEntry() {
        boolean foundEntry = false;
        if (this.lexer.parseStringIgnoreCase("ENTRY ")) {
            foundEntry = true;
            this.lexer.skipWS();
            this.lexer.parseChar('(');
        } else if (this.lexer.parseStringIgnoreCase("ENTRY(")) {
            foundEntry = true;
        }
        if (foundEntry) {
            Node primaryNode;
            Node invokeNode = new Node(NodeType.INVOKE, "mapEntry");
            this.processExpression();
            if (!this.lexer.parseChar(')')) {
                throw new QueryCompilerSyntaxException("',' expected", this.lexer.getIndex(), this.lexer.getInput());
            }
            Node primaryRootNode = primaryNode = (Node)this.stack.pop();
            while (primaryNode.getFirstChild() != null) {
                primaryNode = primaryNode.getFirstChild();
            }
            primaryNode.appendChildNode(invokeNode);
            this.stack.push(primaryRootNode);
            return true;
        }
        return false;
    }

    protected boolean processKey() {
        boolean foundKey = false;
        if (this.lexer.parseStringIgnoreCase("KEY ")) {
            foundKey = true;
            this.lexer.skipWS();
            this.lexer.parseChar('(');
        } else if (this.lexer.parseStringIgnoreCase("KEY(")) {
            foundKey = true;
        }
        if (foundKey) {
            Node primaryNode;
            this.processExpression();
            if (!this.lexer.parseChar(')')) {
                throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
            }
            Node primaryRootNode = primaryNode = (Node)this.stack.pop();
            Node lastNode = primaryNode;
            while (primaryNode.getFirstChild() != null) {
                primaryNode = primaryNode.getFirstChild();
            }
            Object keyValue = primaryNode.getNodeValue();
            primaryNode.setNodeValue(keyValue + "#KEY");
            this.stack.push(primaryRootNode);
            int size = this.stack.size();
            while (this.lexer.parseChar('.')) {
                if (this.processIdentifier()) continue;
                throw new QueryCompilerSyntaxException("Identifier expected", this.lexer.getIndex(), this.lexer.getInput());
            }
            if (size != this.stack.size()) {
                while (this.stack.size() > size) {
                    Node top = (Node)this.stack.pop();
                    lastNode.insertChildNode(top);
                    lastNode = top;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean processValue() {
        boolean foundValue = false;
        if (this.lexer.parseStringIgnoreCase("VALUE ")) {
            foundValue = true;
            this.lexer.skipWS();
            this.lexer.parseChar('(');
        } else if (this.lexer.parseStringIgnoreCase("VALUE(")) {
            foundValue = true;
        }
        if (foundValue) {
            Node primaryNode;
            this.processExpression();
            if (!this.lexer.parseChar(')')) {
                throw new QueryCompilerSyntaxException("',' expected", this.lexer.getIndex(), this.lexer.getInput());
            }
            Node primaryRootNode = primaryNode = (Node)this.stack.pop();
            Node lastNode = primaryNode;
            while (primaryNode.getFirstChild() != null) {
                primaryNode = primaryNode.getFirstChild();
            }
            Object keyValue = primaryNode.getNodeValue();
            primaryNode.setNodeValue(keyValue + "#VALUE");
            this.stack.push(primaryRootNode);
            int size = this.stack.size();
            while (this.lexer.parseChar('.')) {
                if (this.processIdentifier()) continue;
                throw new QueryCompilerSyntaxException("Identifier expected", this.lexer.getIndex(), this.lexer.getInput());
            }
            if (size != this.stack.size()) {
                while (this.stack.size() > size) {
                    Node top = (Node)this.stack.pop();
                    lastNode.insertChildNode(top);
                    lastNode = top;
                }
            }
            return true;
        }
        return false;
    }

    private boolean processMethod() {
        String method = this.lexer.parseMethod();
        if (method != null) {
            this.lexer.skipWS();
            this.lexer.parseChar('(');
            if (method.equalsIgnoreCase("COUNT")) {
                method = "COUNT";
            } else if (method.equalsIgnoreCase("AVG")) {
                method = "AVG";
            } else if (method.equalsIgnoreCase("MIN")) {
                method = "MIN";
            } else if (method.equalsIgnoreCase("MAX")) {
                method = "MAX";
            } else if (method.equalsIgnoreCase("SUM")) {
                method = "SUM";
            } else if (method.equalsIgnoreCase("ABS")) {
                method = "ABS";
            } else if (method.equalsIgnoreCase("INDEX")) {
                method = "INDEX";
            } else if (method.equalsIgnoreCase("FUNCTION")) {
                method = "FUNCTION";
            }
            if (method.equalsIgnoreCase("Object")) {
                this.processExpression();
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("MOD")) {
                Node modNode = new Node(NodeType.OPERATOR, "%");
                this.processExpression();
                Node firstNode = (Node)this.stack.pop();
                if (!this.lexer.parseChar(',')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                this.processExpression();
                Node secondNode = (Node)this.stack.pop();
                modNode.appendChildNode(firstNode);
                modNode.appendChildNode(secondNode);
                this.stack.push(modNode);
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("TYPE")) {
                Node typeNode = new Node(NodeType.TYPE);
                this.processExpression();
                Node typePrimaryNode = (Node)this.stack.pop();
                typeNode.appendChildNode(typePrimaryNode);
                this.stack.push(typeNode);
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("SUBSTRING")) {
                Node invokeNode = new Node(NodeType.INVOKE, "substring");
                this.processExpression();
                Node primaryNode = (Node)this.stack.pop();
                if (!this.lexer.parseChar(',')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                this.processExpression();
                Node arg1 = (Node)this.stack.pop();
                Node oneNode = new Node(NodeType.LITERAL, 1);
                Node arg1Node = new Node(NodeType.OPERATOR, "-");
                arg1Node.insertChildNode(arg1);
                arg1Node.appendChildNode(oneNode);
                if (this.lexer.parseChar(',')) {
                    this.processExpression();
                    Node arg2 = (Node)this.stack.pop();
                    Node arg2Node = new Node(NodeType.OPERATOR, "+");
                    arg2Node.appendChildNode(arg2);
                    arg2Node.appendChildNode(arg1Node);
                    if (!this.lexer.parseChar(')')) {
                        throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
                    }
                    primaryNode.appendChildNode(invokeNode);
                    invokeNode.addProperty(arg1Node);
                    invokeNode.addProperty(arg2Node);
                    this.stack.push(primaryNode);
                    return true;
                }
                if (this.lexer.parseChar(')')) {
                    primaryNode.appendChildNode(invokeNode);
                    invokeNode.addProperty(arg1Node);
                    this.stack.push(primaryNode);
                    return true;
                }
                throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
            }
            if (method.equalsIgnoreCase("UPPER")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "toUpperCase");
                this.processExpression();
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                Node primaryRootNode = primaryNode = (Node)this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("LOWER")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "toLowerCase");
                this.processExpression();
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                Node primaryRootNode = primaryNode = (Node)this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("LENGTH")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "length");
                this.processExpression();
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                Node primaryRootNode = primaryNode = (Node)this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("CONCAT")) {
                this.processExpression();
                Node prevNode = (Node)this.stack.pop();
                while (true) {
                    if (!this.lexer.parseChar(',')) {
                        throw new QueryCompilerSyntaxException("',' expected", this.lexer.getIndex(), this.lexer.getInput());
                    }
                    this.processExpression();
                    Node thisNode = (Node)this.stack.pop();
                    Node currentNode = new Node(NodeType.OPERATOR, "+");
                    currentNode.appendChildNode(prevNode);
                    currentNode.appendChildNode(thisNode);
                    if (this.lexer.parseChar(')')) {
                        this.stack.push(currentNode);
                        return true;
                    }
                    prevNode = currentNode;
                    currentNode = null;
                }
            }
            if (method.equalsIgnoreCase("LOCATE")) {
                Node primaryNode;
                this.processExpression();
                Node searchNode = (Node)this.stack.pop();
                Node invokeNode = new Node(NodeType.INVOKE, "indexOf");
                invokeNode.addProperty(searchNode);
                if (!this.lexer.parseChar(',')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                this.processExpression();
                Node primaryRootNode = primaryNode = (Node)this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                Node oneNode = new Node(NodeType.LITERAL, 1);
                if (this.lexer.parseChar(',')) {
                    this.processExpression();
                    Node fromPosNode = (Node)this.stack.pop();
                    Node positionNode = new Node(NodeType.OPERATOR, "-");
                    positionNode.appendChildNode(fromPosNode);
                    positionNode.appendChildNode(oneNode);
                    invokeNode.addProperty(positionNode);
                }
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                Node locateNode = new Node(NodeType.OPERATOR, "+");
                locateNode.appendChildNode(primaryRootNode);
                locateNode.appendChildNode(oneNode);
                this.stack.push(locateNode);
                return true;
            }
            if (method.equalsIgnoreCase("TRIM")) {
                String methodName = "trim";
                if (this.lexer.parseStringIgnoreCase("LEADING")) {
                    methodName = "trimLeft";
                } else if (this.lexer.parseStringIgnoreCase("TRAILING")) {
                    methodName = "trimRight";
                } else if (this.lexer.parseStringIgnoreCase("BOTH")) {
                    // empty if block
                }
                Node invokeNode = new Node(NodeType.INVOKE, methodName);
                this.processExpression();
                Node next = (Node)this.stack.pop();
                if (this.lexer.parseChar(')')) {
                    Node primaryNode = next;
                    while (primaryNode.getFirstChild() != null) {
                        primaryNode = primaryNode.getFirstChild();
                    }
                    primaryNode.appendChildNode(invokeNode);
                    this.stack.push(next);
                    return true;
                }
                if (next.getNodeType() == NodeType.LITERAL) {
                    Node trimCharNode = next;
                    if (this.lexer.parseStringIgnoreCase("FROM ")) {
                        // empty if block
                    }
                    this.processExpression();
                    next = (Node)this.stack.pop();
                    if (trimCharNode != null) {
                        invokeNode.addProperty(trimCharNode);
                    }
                } else if (next.getNodeType() == NodeType.IDENTIFIER) {
                    Object litValue = next.getNodeValue();
                    if (litValue instanceof String && ((String)litValue).equals("FROM")) {
                        this.processExpression();
                        next = (Node)this.stack.pop();
                    } else {
                        throw new QueryCompilerSyntaxException("Unexpected expression", this.lexer.getIndex(), this.lexer.getInput());
                    }
                }
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                Node primaryNode = next;
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(next);
                return true;
            }
            if (method.equalsIgnoreCase("SIZE")) {
                Node primaryNode;
                Node invokeNode = new Node(NodeType.INVOKE, "size");
                this.processExpression();
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                Node primaryRootNode = primaryNode = (Node)this.stack.pop();
                while (primaryNode.getFirstChild() != null) {
                    primaryNode = primaryNode.getFirstChild();
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryRootNode);
                return true;
            }
            if (method.equalsIgnoreCase("FUNCTION")) {
                this.processExpression();
                Node sqlFunctionNode = (Node)this.stack.pop();
                Node invokeNode = new Node(NodeType.INVOKE, "SQL_function");
                invokeNode.addProperty(sqlFunctionNode);
                if (this.lexer.parseChar(',')) {
                    do {
                        this.processExpression();
                        invokeNode.addProperty((Node)this.stack.pop());
                    } while (this.lexer.parseChar(','));
                }
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                this.stack.push(invokeNode);
                return true;
            }
            Node node = new Node(NodeType.INVOKE, method);
            if (!this.lexer.parseChar(')')) {
                do {
                    this.processExpression();
                    node.addProperty((Node)this.stack.pop());
                } while (this.lexer.parseChar(','));
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
            }
            this.stack.push(node);
            return true;
        }
        return false;
    }

    protected boolean processTreat() {
        if (this.lexer.parseStringIgnoreCase("TREAT(")) {
            this.processExpression();
            Node identifierNode = (Node)this.stack.pop();
            String typeName = this.lexer.parseIdentifier();
            if (typeName == null || !typeName.equalsIgnoreCase("AS")) {
                throw new QueryCompilerSyntaxException("TREAT should always be structured as 'TREAT(id AS typeName)'");
            }
            this.processExpression();
            Node typeNode = (Node)this.stack.pop();
            typeName = typeNode.getNodeChildId();
            Node castNode = new Node(NodeType.CAST, typeName);
            Node endNode = JPQLParser.getLastDescendantNodeForNode(identifierNode);
            castNode.setParent(endNode);
            endNode.appendChildNode(castNode);
            if (!this.lexer.parseChar(')')) {
                throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
            }
            this.stack.push(identifierNode);
            return true;
        }
        return false;
    }

    protected boolean processLiteral() {
        if (this.lexer.parseChar('{')) {
            StringBuilder jdbcLiteralStr = new StringBuilder("{");
            if (this.lexer.parseChar('d')) {
                jdbcLiteralStr.append("d ");
            } else if (this.lexer.parseString("ts")) {
                jdbcLiteralStr.append("ts ");
            } else if (this.lexer.parseChar('t')) {
                jdbcLiteralStr.append("t ");
            } else {
                throw new QueryCompilerSyntaxException("d, ts or t expected after { (JDBC escape syntax)", this.lexer.getIndex(), this.lexer.getInput());
            }
            if (this.lexer.nextIsSingleQuote()) {
                String datetimeLit = this.lexer.parseStringLiteral();
                jdbcLiteralStr.append("'").append(datetimeLit).append("'");
                if (this.lexer.parseChar('}')) {
                    jdbcLiteralStr.append('}');
                    this.stack.push(new Node(NodeType.LITERAL, jdbcLiteralStr.toString()));
                    return true;
                }
                throw new QueryCompilerSyntaxException("} expected in JDBC escape syntax", this.lexer.getIndex(), this.lexer.getInput());
            }
            throw new QueryCompilerSyntaxException("'...' expected in JDBC escape syntax", this.lexer.getIndex(), this.lexer.getInput());
        }
        Object litValue = null;
        boolean single_quote_next = this.lexer.nextIsSingleQuote();
        String sLiteral = this.lexer.parseStringLiteral();
        if (sLiteral != null) {
            litValue = sLiteral.length() == 1 && single_quote_next ? Character.valueOf(sLiteral.charAt(0)) : sLiteral;
        } else {
            Number fLiteral = this.lexer.parseFloatingPointLiteral();
            if (fLiteral != null) {
                litValue = fLiteral;
            } else {
                Number iLiteral = this.lexer.parseIntegerLiteral();
                if (iLiteral != null) {
                    litValue = iLiteral;
                } else {
                    Boolean bLiteral = this.lexer.parseBooleanLiteralIgnoreCase();
                    if (bLiteral != null) {
                        litValue = bLiteral;
                    } else if (!this.lexer.parseNullLiteralIgnoreCase()) {
                        return false;
                    }
                }
            }
        }
        this.stack.push(new Node(NodeType.LITERAL, litValue));
        return true;
    }

    private boolean processIdentifier() {
        String id = this.lexer.parseIdentifier();
        if (id == null || id.length() == 0) {
            return false;
        }
        char first = id.charAt(0);
        if (first == '?') {
            String paramName = id.substring(1);
            ParameterNode node = new ParameterNode(NodeType.PARAMETER, paramName, this.parameterPosition);
            ++this.parameterPosition;
            this.stack.push(node);
            return true;
        }
        if (first == ':') {
            ParameterNode node = new ParameterNode(NodeType.PARAMETER, id.substring(1), this.parameterPosition);
            ++this.parameterPosition;
            this.stack.push(node);
            return true;
        }
        Node node = new Node(NodeType.IDENTIFIER, id);
        this.stack.push(node);
        return true;
    }
}

