/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.NucleusContextHelper;
import org.datanucleus.transaction.HeuristicMixedException;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.transaction.RollbackException;
import org.datanucleus.transaction.XidImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ResourcedTransaction {
    static final int STATUS_ACTIVE = 0;
    static final int STATUS_MARKED_ROLLBACK = 1;
    static final int STATUS_PREPARED = 2;
    static final int STATUS_COMMITTED = 3;
    static final int STATUS_ROLLEDBACK = 4;
    static final int STATUS_UNKNOWN = 5;
    static final int STATUS_NO_TRANSACTION = 6;
    static final int STATUS_PREPARING = 7;
    static final int STATUS_COMMITTING = 8;
    static final int STATUS_ROLLING_BACK = 9;
    private static final int NODE_ID = NucleusContextHelper.random.nextInt();
    private static int NEXT_GLOBAL_TRANSACTION_ID = 1;
    private int nextBranchId = 1;
    private final Xid xid;
    private int status;
    private boolean completing = false;
    private List<Synchronization> synchronization = null;
    private List<XAResource> enlistedResources = new ArrayList<XAResource>();
    private Map<Xid, XAResource> branches = new HashMap<Xid, XAResource>();
    private Map<XAResource, Xid> activeBranches = new HashMap<XAResource, Xid>();
    private Map<XAResource, Xid> suspendedResources = new HashMap<XAResource, Xid>();
    private final String idString;

    ResourcedTransaction() {
        this.xid = new XidImpl(NODE_ID, 0, NEXT_GLOBAL_TRANSACTION_ID++);
        this.idString = "" + NODE_ID + "-" + (NEXT_GLOBAL_TRANSACTION_ID - 1);
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug("Transaction created " + this.toString());
        }
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isEnlisted(XAResource xaRes) {
        if (xaRes == null) {
            return false;
        }
        Xid activeXid = this.activeBranches.get(xaRes);
        if (activeXid != null) {
            return true;
        }
        Xid branchXid = this.suspendedResources.get(xaRes);
        if (branchXid == null) {
            for (XAResource resourceManager : this.enlistedResources) {
                try {
                    if (!resourceManager.isSameRM(xaRes)) continue;
                    return true;
                }
                catch (XAException xAException) {
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean enlistResource(XAResource xaRes) {
        if (xaRes == null) {
            return false;
        }
        if (this.status == 1) {
            throw new RollbackException();
        }
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        Xid activeXid = this.activeBranches.get(xaRes);
        if (activeXid != null) {
            return false;
        }
        boolean alreadyEnlisted = false;
        int flag = 0;
        Xid branchXid = this.suspendedResources.get(xaRes);
        if (branchXid == null) {
            Iterator<XAResource> enlistedIterator = this.enlistedResources.iterator();
            while (!alreadyEnlisted && enlistedIterator.hasNext()) {
                XAResource resourceManager = enlistedIterator.next();
                try {
                    if (!resourceManager.isSameRM(xaRes)) continue;
                    flag = 0x200000;
                    alreadyEnlisted = true;
                }
                catch (XAException xAException) {}
            }
            branchXid = new XidImpl(this.nextBranchId++, this.xid.getFormatId(), this.xid.getGlobalTransactionId());
        } else {
            alreadyEnlisted = true;
            flag = 0x8000000;
            this.suspendedResources.remove(xaRes);
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015039", "enlist", xaRes, ResourcedTransaction.getXAFlag(flag), this.toString()));
        }
        try {
            xaRes.start(branchXid, flag);
        }
        catch (XAException e) {
            NucleusLogger.TRANSACTION.error(Localiser.msg("015038", "enlist", xaRes, ResourcedTransaction.getXAErrorCode(e), this.toString(), StringUtils.getMessageFromRootCauseOfThrowable(e)));
            return false;
        }
        if (!alreadyEnlisted) {
            this.enlistedResources.add(xaRes);
        }
        this.branches.put(branchXid, xaRes);
        this.activeBranches.put(xaRes, branchXid);
        return true;
    }

    public boolean delistResource(XAResource xaRes, int flag) {
        if (xaRes == null) {
            return false;
        }
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        Xid xid = this.activeBranches.get(xaRes);
        if (xid == null) {
            throw new IllegalStateException();
        }
        this.activeBranches.remove(xaRes);
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015039", "delist", xaRes, ResourcedTransaction.getXAFlag(flag), this.toString()));
        }
        XAException exception = null;
        try {
            xaRes.end(xid, flag);
        }
        catch (XAException e) {
            exception = e;
        }
        if (exception != null) {
            NucleusLogger.TRANSACTION.error(Localiser.msg("015038", "delist", xaRes, ResourcedTransaction.getXAErrorCode(exception), this.toString(), StringUtils.getMessageFromRootCauseOfThrowable(exception)));
            return false;
        }
        if (flag == 0x2000000) {
            this.suspendedResources.put(xaRes, xid);
        }
        return true;
    }

    public void registerSynchronization(Synchronization sync) {
        if (sync == null) {
            return;
        }
        if (this.status == 1) {
            throw new RollbackException();
        }
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        if (this.synchronization == null) {
            this.synchronization = new ArrayList<Synchronization>();
        }
        this.synchronization.add(sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (this.completing) {
            return;
        }
        if (this.status == 1) {
            this.rollback();
            return;
        }
        try {
            XAResource resourceManager;
            Xid key;
            this.completing = true;
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug("Committing " + this.toString());
            }
            if (this.status != 0) {
                throw new IllegalStateException();
            }
            if (this.synchronization != null) {
                Iterator<Synchronization> syncIterator = this.synchronization.iterator();
                while (syncIterator.hasNext()) {
                    syncIterator.next().beforeCompletion();
                }
            }
            ArrayList<Throwable> failures = null;
            boolean failed = false;
            if (this.enlistedResources.size() == 1) {
                this.status = 8;
                for (Map.Entry<Xid, XAResource> branchesEntry : this.branches.entrySet()) {
                    key = branchesEntry.getKey();
                    resourceManager = branchesEntry.getValue();
                    try {
                        if (!failed) {
                            resourceManager.commit(key, true);
                            continue;
                        }
                        resourceManager.rollback(key);
                    }
                    catch (Throwable e) {
                        if (failures == null) {
                            failures = new ArrayList<Throwable>();
                        }
                        failures.add(e);
                        failed = true;
                        this.status = 1;
                        NucleusLogger.TRANSACTION.error(Localiser.msg("015038", "commit", resourceManager, ResourcedTransaction.getXAErrorCode(e), this.toString(), StringUtils.getMessageFromRootCauseOfThrowable(e)));
                    }
                }
                this.status = !failed ? 3 : 4;
            } else if (!this.enlistedResources.isEmpty()) {
                this.status = 7;
                Iterator<Map.Entry<Xid, XAResource>> branchesEntryIter = this.branches.entrySet().iterator();
                while (!failed && branchesEntryIter.hasNext()) {
                    Map.Entry<Xid, XAResource> branchesEntry;
                    branchesEntry = branchesEntryIter.next();
                    key = branchesEntry.getKey();
                    resourceManager = branchesEntry.getValue();
                    try {
                        resourceManager.prepare(key);
                    }
                    catch (Throwable e) {
                        if (failures == null) {
                            failures = new ArrayList();
                        }
                        failures.add(e);
                        failed = true;
                        this.status = 1;
                        NucleusLogger.TRANSACTION.error(Localiser.msg("015038", "prepare", resourceManager, ResourcedTransaction.getXAErrorCode(e), this.toString(), StringUtils.getMessageFromRootCauseOfThrowable(e)));
                    }
                }
                if (!failed) {
                    this.status = 2;
                }
                if (failed) {
                    this.status = 9;
                    failed = false;
                    for (Map.Entry<Xid, XAResource> branchesEntry : this.branches.entrySet()) {
                        key = branchesEntry.getKey();
                        resourceManager = branchesEntry.getValue();
                        try {
                            resourceManager.rollback(key);
                        }
                        catch (Throwable e) {
                            NucleusLogger.TRANSACTION.error(Localiser.msg("015038", "rollback", resourceManager, ResourcedTransaction.getXAErrorCode(e), this.toString(), StringUtils.getMessageFromRootCauseOfThrowable(e)));
                            if (failures == null) {
                                failures = new ArrayList();
                            }
                            failures.add(e);
                            failed = true;
                        }
                    }
                    this.status = 4;
                } else {
                    this.status = 8;
                    for (Map.Entry<Xid, XAResource> branchesEntry : this.branches.entrySet()) {
                        key = branchesEntry.getKey();
                        resourceManager = branchesEntry.getValue();
                        try {
                            resourceManager.commit(key, false);
                        }
                        catch (Throwable e) {
                            NucleusLogger.TRANSACTION.error(Localiser.msg("015038", "commit", resourceManager, ResourcedTransaction.getXAErrorCode(e), this.toString(), StringUtils.getMessageFromRootCauseOfThrowable(e)));
                            if (failures == null) {
                                failures = new ArrayList();
                            }
                            failures.add(e);
                            failed = true;
                        }
                    }
                    this.status = 3;
                }
            }
            if (this.synchronization != null) {
                Iterator<Synchronization> syncIterator = this.synchronization.iterator();
                while (syncIterator.hasNext()) {
                    syncIterator.next().afterCompletion(this.status);
                }
            }
            if (this.status == 4) {
                if (failed) {
                    if (failures.size() == 1) {
                        throw new HeuristicRollbackException("Transaction rolled back due to failure during commit", (Throwable)failures.get(0));
                    }
                    throw new HeuristicRollbackException("Multiple failures");
                }
                throw new RollbackException();
            }
            if (this.status == 3 && failed) {
                throw new HeuristicMixedException();
            }
        }
        finally {
            this.completing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (this.completing) {
            return;
        }
        try {
            this.completing = true;
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug("Rolling back " + this.toString());
            }
            if (this.status != 0 && this.status != 1) {
                throw new IllegalStateException();
            }
            ArrayList<Throwable> failures = null;
            this.status = 9;
            for (Map.Entry<Xid, XAResource> branchesEntry : this.branches.entrySet()) {
                Xid xid = branchesEntry.getKey();
                XAResource resourceManager = branchesEntry.getValue();
                try {
                    resourceManager.rollback(xid);
                }
                catch (Throwable e) {
                    if (failures == null) {
                        failures = new ArrayList<Throwable>();
                    }
                    failures.add(e);
                    NucleusLogger.TRANSACTION.error(Localiser.msg("015038", "rollback", resourceManager, ResourcedTransaction.getXAErrorCode(e), this.toString(), StringUtils.getMessageFromRootCauseOfThrowable(e)));
                }
            }
            this.status = 4;
            if (this.synchronization != null) {
                Iterator<Synchronization> syncIterator = this.synchronization.iterator();
                while (syncIterator.hasNext()) {
                    syncIterator.next().afterCompletion(this.status);
                }
            }
        }
        finally {
            this.completing = false;
        }
    }

    public void setRollbackOnly() {
        this.status = 1;
    }

    public static String getXAErrorCode(Throwable xae) {
        if (!(xae instanceof XAException)) {
            return "UNKNOWN";
        }
        switch (((XAException)xae).errorCode) {
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 100: {
                return "XA_RBBASE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBBEADLOCK";
            }
            case 107: {
                return "XA_RBEND";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "UNKNOWN";
    }

    private static String getXAFlag(int flag) {
        switch (flag) {
            case 0x800000: {
                return "TMENDRSCAN";
            }
            case 0x20000000: {
                return "TMFAIL";
            }
            case 0x200000: {
                return "TMJOIN";
            }
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x40000000: {
                return "TMONEPHASE";
            }
            case 0x8000000: {
                return "TMRESUME";
            }
            case 0x1000000: {
                return "TMSTARTRSCAN";
            }
            case 0x4000000: {
                return "TMSUCCESS";
            }
            case 0x2000000: {
                return "TMSUSPEND";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "[DataNucleus Transaction, ID=" + this.idString + ", enlisted resources=" + this.enlistedResources.toString() + "]";
    }
}

