/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.util.Properties;
import org.datanucleus.store.valuegenerator.AUID;
import org.datanucleus.store.valuegenerator.AbstractGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class AUIDGenerator
extends AbstractGenerator<String> {
    public AUIDGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 1;
    }

    public static Class getStorageClass() {
        return String.class;
    }

    @Override
    protected ValueGenerationBlock<String> reserveBlock(long size) {
        Object[] ids = new Object[(int)size];
        int i = 0;
        while ((long)i < size) {
            ids[i] = new AUID().toString();
            ++i;
        }
        if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
            NucleusLogger.VALUEGENERATION.debug(Localiser.msg("040004", "" + size));
        }
        return new ValueGenerationBlock<Object>(ids);
    }
}

