/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.identity.DatastoreIdImpl;
import org.datanucleus.identity.DatastoreUniqueLongId;
import org.datanucleus.identity.IdentityKeyTranslator;
import org.datanucleus.identity.IdentityManager;
import org.datanucleus.identity.IdentityStringTranslator;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class IdentityManagerImpl
implements IdentityManager {
    protected Class datastoreIdClass = null;
    protected IdentityStringTranslator idStringTranslator = null;
    protected IdentityKeyTranslator idKeyTranslator = null;
    private Map<String, Constructor<?>> constructorCache = new ConcurrentHashMap();

    public IdentityManagerImpl(PersistenceNucleusContext nucCtx) {
        String stringTranslatorType;
        String dsidName = nucCtx.getConfiguration().getStringProperty("datanucleus.datastoreIdentityType");
        String datastoreIdentityClassName = nucCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.store_datastoreidentity", "name", dsidName, "class-name");
        if (datastoreIdentityClassName == null) {
            throw new NucleusUserException(Localiser.msg("002001", dsidName)).setFatal();
        }
        ClassLoaderResolver clr = nucCtx.getClassLoaderResolver(null);
        try {
            this.datastoreIdClass = clr.classForName(datastoreIdentityClassName, ClassConstants.NUCLEUS_CONTEXT_LOADER);
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusUserException(Localiser.msg("002002", dsidName, datastoreIdentityClassName)).setFatal();
        }
        String keyTranslatorType = nucCtx.getConfiguration().getStringProperty("datanucleus.identityKeyTranslatorType");
        if (keyTranslatorType != null) {
            try {
                this.idKeyTranslator = (IdentityKeyTranslator)nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.identity_key_translator", "name", keyTranslatorType, "class-name", null, null);
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("002001", keyTranslatorType)).setFatal();
            }
        }
        if ((stringTranslatorType = nucCtx.getConfiguration().getStringProperty("datanucleus.identityStringTranslatorType")) != null) {
            try {
                this.idStringTranslator = (IdentityStringTranslator)nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.identity_string_translator", "name", stringTranslatorType, "class-name", null, null);
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("002001", stringTranslatorType)).setFatal();
            }
        }
    }

    protected String getConstructorNameForCache(Class type, Class[] ctrArgTypes) {
        StringBuilder name = new StringBuilder(type.getName());
        if (ctrArgTypes != null) {
            for (int i = 0; i < ctrArgTypes.length; ++i) {
                name.append("-").append(ctrArgTypes[i].getName());
            }
        }
        return name.toString();
    }

    @Override
    public Class getDatastoreIdClass() {
        return this.datastoreIdClass;
    }

    @Override
    public IdentityStringTranslator getIdentityStringTranslator() {
        return this.idStringTranslator;
    }

    @Override
    public IdentityKeyTranslator getIdentityKeyTranslator() {
        return this.idKeyTranslator;
    }

    @Override
    public DatastoreId getDatastoreId(String className, Object value) {
        if (this.datastoreIdClass == ClassConstants.IDENTITY_DATASTORE_IMPL) {
            return new DatastoreIdImpl(className, value);
        }
        try {
            Class[] ctrArgTypes = new Class[]{String.class, Object.class};
            String ctrName = this.getConstructorNameForCache(this.datastoreIdClass, ctrArgTypes);
            Constructor<Object> ctr = this.constructorCache.get(ctrName);
            if (ctr == null) {
                ctr = this.datastoreIdClass.getConstructor(ctrArgTypes);
                this.constructorCache.put(ctrName, ctr);
            }
            return (DatastoreId)ctr.newInstance(className, value);
        }
        catch (Exception e) {
            throw new NucleusException("Error encountered while creating datastore instance for class \"" + className + "\"", e);
        }
    }

    @Override
    public DatastoreId getDatastoreId(long value) {
        if (this.datastoreIdClass == DatastoreUniqueLongId.class) {
            return new DatastoreUniqueLongId(value);
        }
        try {
            Class[] ctrArgTypes = new Class[]{Long.class};
            String ctrName = this.getConstructorNameForCache(this.datastoreIdClass, ctrArgTypes);
            Constructor<Object> ctr = this.constructorCache.get(ctrName);
            if (ctr == null) {
                ctr = this.datastoreIdClass.getConstructor(ctrArgTypes);
                this.constructorCache.put(ctrName, ctr);
            }
            return (DatastoreId)ctr.newInstance(value);
        }
        catch (Exception e) {
            throw new NucleusException("Error encountered while creating datastore instance for unique value \"" + value + "\"", e);
        }
    }

    @Override
    public DatastoreId getDatastoreId(String idString) {
        if (this.datastoreIdClass == ClassConstants.IDENTITY_DATASTORE_IMPL) {
            return new DatastoreIdImpl(idString);
        }
        try {
            Class[] ctrArgTypes = new Class[]{String.class};
            String ctrName = this.getConstructorNameForCache(this.datastoreIdClass, ctrArgTypes);
            Constructor<Object> ctr = this.constructorCache.get(ctrName);
            if (ctr == null) {
                ctr = this.datastoreIdClass.getConstructor(ctrArgTypes);
                this.constructorCache.put(ctrName, ctr);
            }
            return (DatastoreId)ctr.newInstance(idString);
        }
        catch (Exception e) {
            throw new NucleusException("Error encountered while creating datastore instance for string \"" + idString + "\"", e);
        }
    }

    @Override
    public SingleFieldId getSingleFieldId(Class idType, Class pcType, Object key) {
        if (idType == null) {
            throw new NucleusException(Localiser.msg("029001", pcType)).setFatal();
        }
        if (pcType == null) {
            throw new NucleusException(Localiser.msg("029000", idType)).setFatal();
        }
        if (key == null) {
            throw new NucleusException(Localiser.msg("029003", idType, pcType)).setFatal();
        }
        if (!SingleFieldId.class.isAssignableFrom(idType)) {
            throw new NucleusException(Localiser.msg("029002", idType.getName(), pcType.getName())).setFatal();
        }
        SingleFieldId id = null;
        Class keyType = null;
        if (idType == ClassConstants.IDENTITY_SINGLEFIELD_LONG) {
            keyType = Long.class;
            if (!(key instanceof Long)) {
                throw new NucleusException(Localiser.msg("029004", idType.getName(), pcType.getName(), key.getClass().getName(), "Long")).setFatal();
            }
        } else if (idType == ClassConstants.IDENTITY_SINGLEFIELD_INT) {
            keyType = Integer.class;
            if (!(key instanceof Integer)) {
                throw new NucleusException(Localiser.msg("029004", idType.getName(), pcType.getName(), key.getClass().getName(), "Integer")).setFatal();
            }
        } else if (idType == ClassConstants.IDENTITY_SINGLEFIELD_STRING) {
            keyType = String.class;
            if (!(key instanceof String)) {
                throw new NucleusException(Localiser.msg("029004", idType.getName(), pcType.getName(), key.getClass().getName(), "String")).setFatal();
            }
        } else if (idType == ClassConstants.IDENTITY_SINGLEFIELD_BYTE) {
            keyType = Byte.class;
            if (!(key instanceof Byte)) {
                throw new NucleusException(Localiser.msg("029004", idType.getName(), pcType.getName(), key.getClass().getName(), "Byte")).setFatal();
            }
        } else if (idType == ClassConstants.IDENTITY_SINGLEFIELD_SHORT) {
            keyType = Short.class;
            if (!(key instanceof Short)) {
                throw new NucleusException(Localiser.msg("029004", idType.getName(), pcType.getName(), key.getClass().getName(), "Short")).setFatal();
            }
        } else if (idType == ClassConstants.IDENTITY_SINGLEFIELD_CHAR) {
            keyType = Character.class;
            if (!(key instanceof Character)) {
                throw new NucleusException(Localiser.msg("029004", idType.getName(), pcType.getName(), key.getClass().getName(), "Character")).setFatal();
            }
        } else {
            keyType = Object.class;
        }
        try {
            Class[] ctrArgs = new Class[]{Class.class, keyType};
            String ctrName = this.getConstructorNameForCache(idType, ctrArgs);
            Constructor<Object> ctr = this.constructorCache.get(ctrName);
            if (ctr == null) {
                ctr = idType.getConstructor(ctrArgs);
                this.constructorCache.put(ctrName, ctr);
            }
            id = (SingleFieldId)ctr.newInstance(pcType, key);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error("Error encountered while creating SingleFieldIdentity instance of type \"" + idType.getName() + "\"", e);
            return null;
        }
        return id;
    }

    @Override
    public Object getApplicationId(ClassLoaderResolver clr, AbstractClassMetaData acmd, String keyToString) {
        if (acmd.getIdentityType() != IdentityType.APPLICATION) {
            throw new NucleusException("This class (" + acmd.getFullClassName() + ") doesn't use application-identity!");
        }
        Class targetClass = clr.classForName(acmd.getFullClassName());
        Class idType = clr.classForName(acmd.getObjectidClass());
        if (acmd.usesSingleFieldIdentityClass()) {
            try {
                Class[] ctrArgTypes = ClassConstants.IDENTITY_SINGLEFIELD_OBJECT.isAssignableFrom(idType) ? new Class[]{Class.class, Object.class} : new Class[]{Class.class, String.class};
                String ctrName = this.getConstructorNameForCache(idType, ctrArgTypes);
                Constructor<Object> ctr = this.constructorCache.get(ctrName);
                if (ctr == null) {
                    ctr = idType.getConstructor(ctrArgTypes);
                    this.constructorCache.put(ctrName, ctr);
                }
                return ctr.newInstance(targetClass, keyToString);
            }
            catch (Exception e) {
                throw new NucleusException("Error encountered while creating single-field identity instance with key \"" + keyToString + "\"", e);
            }
        }
        if (Modifier.isAbstract(targetClass.getModifiers()) && acmd.getObjectidClass() != null) {
            try {
                Class type = clr.classForName(acmd.getObjectidClass());
                Class[] ctrArgTypes = new Class[]{String.class};
                String ctrName = this.getConstructorNameForCache(type, ctrArgTypes);
                Constructor<Object> ctr = this.constructorCache.get(ctrName);
                if (ctr == null) {
                    ctr = type.getConstructor(ctrArgTypes);
                    this.constructorCache.put(ctrName, ctr);
                }
                return ctr.newInstance(keyToString);
            }
            catch (Exception e) {
                String msg = Localiser.msg("010030", acmd.getObjectidClass(), acmd.getFullClassName());
                NucleusLogger.PERSISTENCE.error(msg, e);
                throw new NucleusUserException(msg);
            }
        }
        clr.classForName(targetClass.getName(), true);
        return EnhancementHelper.getInstance().newObjectIdInstance(targetClass, keyToString);
    }

    @Override
    public Object getApplicationId(Object pc, AbstractClassMetaData cmd) {
        if (pc == null || cmd == null) {
            return null;
        }
        try {
            Field classField;
            Object id = ((Persistable)pc).dnNewObjectIdInstance();
            if (!cmd.usesSingleFieldIdentityClass()) {
                ((Persistable)pc).dnCopyKeyFieldsToObjectId(id);
            }
            if (!(id instanceof SingleFieldId) && (classField = ClassUtils.getFieldForClass(id.getClass(), "targetClassName")) != null) {
                try {
                    classField.set(id, cmd.getFullClassName());
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getApplicationId(Class cls, Object key) {
        return EnhancementHelper.getInstance().newObjectIdInstance(cls, key);
    }
}

