/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.containers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.types.ElementContainerHandler;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.containers.ArrayAdapter;
import org.datanucleus.util.StringUtils;

public class ArrayHandler
extends ElementContainerHandler<Object, ArrayAdapter<Object>> {
    private Class arrayClass;

    public ArrayHandler(Class arrayClass) {
        this.arrayClass = arrayClass;
    }

    @Override
    public ArrayMetaData newMetaData() {
        return new ArrayMetaData();
    }

    @Override
    public void populateMetaData(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mmgr, AbstractMemberMetaData mmd) {
        ArrayMetaData arrayMetadata = this.assertMetadataType(mmd.getContainer());
        if (StringUtils.isEmpty(arrayMetadata.getElementType())) {
            arrayMetadata.setElementType(this.getElementType(mmd));
        }
        this.moveColumnsToElement(mmd);
        this.copyMappedByDefinitionFromElement(mmd);
        if (mmd.getElementMetaData() != null) {
            mmd.getElementMetaData().populate(clr, primary);
        }
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            if (mmd.isCascadeDelete()) {
                arrayMetadata.setDependentElement(true);
            }
            arrayMetadata.populate(clr, primary);
        }
    }

    @Override
    public int getObjectType(AbstractMemberMetaData mmd) {
        return mmd.getArray().isEmbeddedElement() || mmd.getArray().isSerializedElement() ? 2 : 0;
    }

    @Override
    public boolean isSerialised(AbstractMemberMetaData mmd) {
        return mmd.isSerialized() || mmd.getArray().isSerializedElement();
    }

    @Override
    public boolean isEmbedded(AbstractMemberMetaData mmd) {
        return mmd.isEmbedded() || mmd.getArray().isEmbeddedElement();
    }

    @Override
    public boolean isDefaultFetchGroup(ClassLoaderResolver clr, MetaDataManager mmgr, AbstractMemberMetaData mmd) {
        String elementTypeName = this.getElementType(mmd);
        if (StringUtils.isEmpty(elementTypeName)) {
            throw new NucleusException("MetaData must be populated to determine default fetch group.");
        }
        Class elementType = clr.classForName(elementTypeName);
        TypeManager typeMgr = mmgr.getNucleusContext().getTypeManager();
        return typeMgr.isDefaultFetchGroupForCollection(mmd.getType(), elementType);
    }

    protected String getElementType(AbstractMemberMetaData mmd) {
        String elementType = null;
        Member member = mmd.getMemberRepresented();
        if (member instanceof Field) {
            elementType = ((Field)member).getType().getComponentType().getName();
        } else if (member instanceof Method) {
            elementType = ((Method)member).getReturnType().getComponentType().getName();
        }
        return elementType;
    }

    private ArrayMetaData assertMetadataType(ContainerMetaData existingMetaData) {
        if (existingMetaData instanceof ArrayMetaData) {
            return (ArrayMetaData)existingMetaData;
        }
        throw new NucleusException("Invalid type of metadata specified.");
    }

    @Override
    public ArrayAdapter getAdapter(Object container) {
        return new ArrayAdapter<Object>(container);
    }

    @Override
    public Object newContainer(AbstractMemberMetaData mmm) {
        return Array.newInstance(this.arrayClass.getComponentType(), 0);
    }

    @Override
    public Object newContainer(AbstractMemberMetaData mmd, Object ... objects) {
        return objects;
    }
}

