/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.compiler.QueryCompilationCache;
import org.datanucleus.query.inmemory.InvocationEvaluator;
import org.datanucleus.query.inmemory.method.ArrayContainsMethod;
import org.datanucleus.query.inmemory.method.ArraySizeMethod;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.cache.QueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class QueryManagerImpl
implements QueryManager {
    protected NucleusContext nucleusCtx;
    protected StoreManager storeMgr;
    protected QueryCompilationCache queryCompilationCache = null;
    protected QueryDatastoreCompilationCache queryCompilationCacheDatastore = null;
    protected QueryResultsCache queryResultsCache = null;
    protected Map<String, Map<Object, InvocationEvaluator>> inmemoryQueryMethodEvaluatorMap = new ConcurrentHashMap<String, Map<Object, InvocationEvaluator>>();

    public QueryManagerImpl(NucleusContext nucleusContext, StoreManager storeMgr) {
        String cacheClassName;
        this.nucleusCtx = nucleusContext;
        this.storeMgr = storeMgr;
        Configuration conf = this.nucleusCtx.getConfiguration();
        String cacheType = conf.getStringProperty("datanucleus.cache.queryCompilation.type");
        if (cacheType != null && !cacheType.equalsIgnoreCase("none")) {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_compilation", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(Localiser.msg("021500", cacheType)).setFatal();
            }
            try {
                this.queryCompilationCache = (QueryCompilationCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_compilation", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("021502", cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("021501", cacheType, cacheClassName), e).setFatal();
            }
        }
        if ((cacheType = conf.getStringProperty("datanucleus.cache.queryCompilationDatastore.type")) != null && !cacheType.equalsIgnoreCase("none")) {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_compilation_store", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(Localiser.msg("021500", cacheType)).setFatal();
            }
            try {
                this.queryCompilationCacheDatastore = (QueryDatastoreCompilationCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_compilation_store", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("021502", cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("021501", cacheType, cacheClassName), e).setFatal();
            }
        }
        if ((cacheType = conf.getStringProperty("datanucleus.cache.queryResults.type")) != null && !cacheType.equalsIgnoreCase("none")) {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_result", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(Localiser.msg("021500", cacheType)).setFatal();
            }
            try {
                this.queryResultsCache = (QueryResultsCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_result", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("021502", cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("021501", cacheType, cacheClassName), e).setFatal();
            }
        }
    }

    @Override
    public void close() {
        if (this.queryCompilationCache != null) {
            this.queryCompilationCache.close();
            this.queryCompilationCache = null;
        }
        if (this.queryCompilationCacheDatastore != null) {
            this.queryCompilationCacheDatastore.close();
            this.queryCompilationCacheDatastore = null;
        }
        if (this.queryResultsCache != null) {
            this.queryResultsCache.close();
            this.queryResultsCache = null;
        }
        this.inmemoryQueryMethodEvaluatorMap.clear();
        this.inmemoryQueryMethodEvaluatorMap = null;
    }

    @Override
    public Query newQuery(String language, ExecutionContext ec, Object query) {
        if (language == null) {
            return null;
        }
        String languageImpl = language;
        try {
            if (query == null) {
                Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.EXECUTION_CONTEXT};
                Object[] args = new Object[]{this.storeMgr, ec};
                Query q = (Query)ec.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, ec.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException(Localiser.msg("021034", languageImpl, ec.getStoreManager().getStoreManagerKey()));
                }
                return q;
            }
            Query q = null;
            if (query instanceof String) {
                Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.EXECUTION_CONTEXT, String.class};
                Object[] args = new Object[]{this.storeMgr, ec, query};
                q = (Query)ec.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, ec.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException(Localiser.msg("021034", languageImpl, ec.getStoreManager().getStoreManagerKey()));
                }
            } else if (query instanceof Query) {
                Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.EXECUTION_CONTEXT, query.getClass()};
                Object[] args = new Object[]{this.storeMgr, ec, query};
                q = (Query)ec.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, ec.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException(Localiser.msg("021034", languageImpl, ec.getStoreManager().getStoreManagerKey()));
                }
            } else {
                Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.EXECUTION_CONTEXT, Object.class};
                Object[] args = new Object[]{this.storeMgr, ec, query};
                q = (Query)ec.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, ec.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException(Localiser.msg("021034", languageImpl, ec.getStoreManager().getStoreManagerKey()));
                }
            }
            return q;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new NucleusException(t.getMessage(), t).setFatal();
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), e).setFatal();
        }
    }

    @Override
    public synchronized QueryCompilationCache getQueryCompilationCache() {
        return this.queryCompilationCache;
    }

    @Override
    public synchronized void addQueryCompilation(String language, String query, QueryCompilation compilation) {
        if (this.queryCompilationCache != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCache.put(queryKey, compilation);
        }
    }

    @Override
    public synchronized QueryCompilation getQueryCompilationForQuery(String language, String query) {
        String queryKey;
        QueryCompilation compilation;
        if (this.queryCompilationCache != null && (compilation = this.queryCompilationCache.get(queryKey = language + ":" + query)) != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021079", query, language));
            }
            return compilation;
        }
        return null;
    }

    @Override
    public synchronized QueryDatastoreCompilationCache getQueryDatastoreCompilationCache() {
        return this.queryCompilationCacheDatastore;
    }

    @Override
    public synchronized void addDatastoreQueryCompilation(String datastore, String language, String query, Object compilation) {
        if (this.queryCompilationCacheDatastore != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCacheDatastore.put(queryKey, compilation);
        }
    }

    @Override
    public synchronized void deleteDatastoreQueryCompilation(String datastore, String language, String query) {
        if (this.queryCompilationCacheDatastore != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCacheDatastore.evict(queryKey);
        }
    }

    @Override
    public synchronized Object getDatastoreQueryCompilation(String datastore, String language, String query) {
        String queryKey;
        Object compilation;
        if (this.queryCompilationCacheDatastore != null && (compilation = this.queryCompilationCacheDatastore.get(queryKey = language + ":" + query)) != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021080", query, language, datastore));
            }
            return compilation;
        }
        return null;
    }

    @Override
    public synchronized QueryResultsCache getQueryResultsCache() {
        return this.queryResultsCache;
    }

    @Override
    public synchronized void evictQueryResultsForType(Class cls) {
        if (this.queryResultsCache != null) {
            this.queryResultsCache.evict(cls);
        }
    }

    @Override
    public synchronized void addQueryResult(Query query, Map params, List<Object> results) {
        if (this.queryResultsCache != null) {
            String queryKey = QueryUtils.getKeyForQueryResultsCache(query, params);
            this.queryResultsCache.put(queryKey, results);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021081", query, results.size()));
            }
        }
    }

    @Override
    public synchronized List<Object> getQueryResult(Query query, Map params) {
        if (this.queryResultsCache != null) {
            String queryKey = QueryUtils.getKeyForQueryResultsCache(query, params);
            List<Object> results = this.queryResultsCache.get(queryKey);
            if (results != null && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021082", query, results.size()));
            }
            return results;
        }
        return null;
    }

    @Override
    public InvocationEvaluator getInMemoryEvaluatorForMethod(Class type, String methodName) {
        Map<Object, InvocationEvaluator> evaluatorsForMethod;
        if (type != null && type.isArray()) {
            if (methodName.equals("size") || methodName.equals("length")) {
                return new ArraySizeMethod();
            }
            if (methodName.equals("contains")) {
                return new ArrayContainsMethod();
            }
        }
        if ((evaluatorsForMethod = this.inmemoryQueryMethodEvaluatorMap.get(methodName)) != null) {
            for (Map.Entry<Object, InvocationEvaluator> entry : evaluatorsForMethod.entrySet()) {
                Object clsKey = entry.getKey();
                if (clsKey instanceof Class && ((Class)clsKey).isAssignableFrom(type)) {
                    return entry.getValue();
                }
                if (!(clsKey instanceof String) || !((String)clsKey).equals("STATIC") || type != null) continue;
                return entry.getValue();
            }
            return null;
        }
        ClassLoaderResolver clr = this.nucleusCtx.getClassLoaderResolver(type != null ? type.getClassLoader() : null);
        PluginManager pluginMgr = this.nucleusCtx.getPluginManager();
        ConfigurationElement[] elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.query_method_evaluators", "method", methodName);
        HashMap<Object, InvocationEvaluator> evaluators = new HashMap<Object, InvocationEvaluator>();
        InvocationEvaluator requiredEvaluator = null;
        if (elems == null) {
            return null;
        }
        for (int i = 0; i < elems.length; ++i) {
            try {
                String evalName = elems[i].getAttribute("evaluator");
                InvocationEvaluator eval = (InvocationEvaluator)pluginMgr.createExecutableExtension("org.datanucleus.query_method_evaluators", new String[]{"method", "evaluator"}, new String[]{methodName, evalName}, "evaluator", null, null);
                String elemClsName = elems[i].getAttribute("class");
                if (elemClsName != null && StringUtils.isWhitespace(elemClsName)) {
                    elemClsName = null;
                }
                if (elemClsName == null) {
                    if (type == null) {
                        requiredEvaluator = eval;
                    }
                    evaluators.put("STATIC", eval);
                    continue;
                }
                Class elemCls = clr.classForName(elemClsName);
                if (elemCls.isAssignableFrom(type)) {
                    requiredEvaluator = eval;
                }
                evaluators.put(elemCls, eval);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.inmemoryQueryMethodEvaluatorMap.put(methodName, evaluators);
        return requiredEvaluator;
    }
}

