/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.connection;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ConnectionManager;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.federation.FederatedStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ConnectionManagerImpl
implements ConnectionManager {
    PersistenceNucleusContext nucleusContext;
    Map<String, ConnectionFactory> factories = new HashMap<String, ConnectionFactory>();
    ManagedConnectionPool connectionPool = new ManagedConnectionPool();
    boolean connectionPoolEnabled = true;

    public ConnectionManagerImpl(PersistenceNucleusContext context) {
        this.nucleusContext = context;
    }

    @Override
    public void closeAllConnections(ConnectionFactory factory, ExecutionContext ec) {
        ManagedConnection mconnFromPool;
        if (ec != null && this.connectionPoolEnabled && (mconnFromPool = this.connectionPool.getManagedConnection(factory, ec)) != null) {
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug(Localiser.msg("009005", mconnFromPool, ec, factory));
            }
            mconnFromPool.close();
        }
    }

    @Override
    public ManagedConnection allocateConnection(final ConnectionFactory factory, final ExecutionContext ec, Transaction transaction, Map options) {
        ManagedConnection mconnFromPool;
        if (ec != null && this.connectionPoolEnabled && (mconnFromPool = this.connectionPool.getManagedConnection(factory, ec)) != null) {
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug(Localiser.msg("009004", mconnFromPool, ec, factory));
            }
            if (!mconnFromPool.closeAfterTransactionEnd()) {
                if (transaction.isActive()) {
                    if (mconnFromPool.commitOnRelease()) {
                        mconnFromPool.setCommitOnRelease(false);
                    }
                    if (mconnFromPool.closeOnRelease()) {
                        mconnFromPool.setCloseOnRelease(false);
                    }
                    XAResource res = mconnFromPool.getXAResource();
                    org.datanucleus.transaction.Transaction tx = this.nucleusContext.getTransactionManager().getTransaction(ec);
                    if (res != null && tx != null && !tx.isEnlisted(res)) {
                        String cfResourceType = factory.getResourceType();
                        if (!ConnectionResourceType.JTA.toString().equalsIgnoreCase(cfResourceType)) {
                            tx.enlistResource(res);
                        }
                    }
                } else {
                    if (!mconnFromPool.commitOnRelease()) {
                        mconnFromPool.setCommitOnRelease(true);
                    }
                    if (mconnFromPool.closeOnRelease()) {
                        mconnFromPool.setCloseOnRelease(false);
                    }
                }
            }
            return mconnFromPool;
        }
        final ManagedConnection mconn = factory.createManagedConnection(ec, this.mergeOptions(transaction, options));
        if (ec != null) {
            if (transaction.isActive()) {
                this.configureTransactionEventListener(transaction, mconn);
                org.datanucleus.transaction.Transaction tx = this.nucleusContext.getTransactionManager().getTransaction(ec);
                mconn.setCommitOnRelease(false);
                mconn.setCloseOnRelease(false);
                XAResource res = mconn.getXAResource();
                if (res != null && tx != null && !tx.isEnlisted(res)) {
                    String cfResourceType = factory.getResourceType();
                    if (!ConnectionResourceType.JTA.toString().equalsIgnoreCase(cfResourceType)) {
                        tx.enlistResource(res);
                    }
                }
            }
            if (this.connectionPoolEnabled) {
                mconn.addListener(new ManagedConnectionResourceListener(){

                    @Override
                    public void transactionFlushed() {
                    }

                    @Override
                    public void transactionPreClose() {
                    }

                    @Override
                    public void managedConnectionPreClose() {
                    }

                    @Override
                    public void managedConnectionPostClose() {
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug(Localiser.msg("009006", mconn, ec, factory));
                        }
                        ConnectionManagerImpl.this.connectionPool.removeManagedConnection(factory, ec);
                        mconn.removeListener(this);
                    }

                    @Override
                    public void resourcePostClose() {
                    }
                });
                if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                    NucleusLogger.CONNECTION.debug(Localiser.msg("009007", mconn, ec, factory));
                }
                this.connectionPool.putManagedConnection(factory, ec, mconn);
            }
        }
        return mconn;
    }

    private Map mergeOptions(Transaction transaction, Map overridingOptions) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (transaction != null && transaction.getOptions() != null && !transaction.getOptions().isEmpty()) {
            m.putAll(transaction.getOptions());
        }
        if (overridingOptions != null && !overridingOptions.isEmpty()) {
            m.putAll(overridingOptions);
        }
        return m;
    }

    private void configureTransactionEventListener(final Transaction transaction, final ManagedConnection mconn) {
        if (mconn.closeAfterTransactionEnd()) {
            transaction.addTransactionEventListener(new TransactionEventListener(){

                @Override
                public void transactionStarted() {
                }

                @Override
                public void transactionRolledBack() {
                    try {
                        mconn.close();
                    }
                    finally {
                        transaction.removeTransactionEventListener(this);
                    }
                }

                @Override
                public void transactionCommitted() {
                    try {
                        mconn.close();
                    }
                    finally {
                        transaction.removeTransactionEventListener(this);
                    }
                }

                @Override
                public void transactionEnded() {
                    try {
                        mconn.close();
                    }
                    finally {
                        transaction.removeTransactionEventListener(this);
                    }
                }

                @Override
                public void transactionPreCommit() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(Localiser.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                @Override
                public void transactionPreRollBack() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(Localiser.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                @Override
                public void transactionPreFlush() {
                }

                @Override
                public void transactionFlushed() {
                    mconn.transactionFlushed();
                }

                @Override
                public void transactionSetSavepoint(String name) {
                    mconn.setSavepoint(name);
                }

                @Override
                public void transactionReleaseSavepoint(String name) {
                    mconn.releaseSavepoint(name);
                }

                @Override
                public void transactionRollbackToSavepoint(String name) {
                    mconn.rollbackToSavepoint(name);
                }
            });
        } else {
            transaction.bindTransactionEventListener(new TransactionEventListener(){

                @Override
                public void transactionStarted() {
                }

                @Override
                public void transactionPreFlush() {
                }

                @Override
                public void transactionFlushed() {
                    mconn.transactionFlushed();
                }

                @Override
                public void transactionPreCommit() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(Localiser.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                @Override
                public void transactionCommitted() {
                }

                @Override
                public void transactionPreRollBack() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(Localiser.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                @Override
                public void transactionRolledBack() {
                }

                @Override
                public void transactionEnded() {
                }

                @Override
                public void transactionSetSavepoint(String name) {
                    mconn.setSavepoint(name);
                }

                @Override
                public void transactionReleaseSavepoint(String name) {
                    mconn.releaseSavepoint(name);
                }

                @Override
                public void transactionRollbackToSavepoint(String name) {
                    mconn.rollbackToSavepoint(name);
                }
            });
        }
    }

    @Override
    public ConnectionFactory lookupConnectionFactory(String name) {
        return this.factories.get(name);
    }

    @Override
    public void registerConnectionFactory(String name, ConnectionFactory factory) {
        this.factories.put(name, factory);
    }

    @Override
    public void disableConnectionPool() {
        this.connectionPoolEnabled = false;
    }

    class PoolKey {
        ConnectionFactory factory;
        ExecutionContext ec;

        public PoolKey(ConnectionFactory factory, ExecutionContext ec) {
            this.factory = factory;
            this.ec = ec;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof PoolKey)) {
                return false;
            }
            PoolKey other = (PoolKey)obj;
            return this.factory == other.factory && this.ec == other.ec;
        }

        public int hashCode() {
            return this.factory.hashCode() ^ this.ec.hashCode();
        }
    }

    class ManagedConnectionPool {
        Map<Object, Map<ConnectionFactory, ManagedConnection>> connectionsPool = new HashMap<Object, Map<ConnectionFactory, ManagedConnection>>();

        ManagedConnectionPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeManagedConnection(ConnectionFactory factory, ExecutionContext ec) {
            Map<Object, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Object poolKey = this.getPoolKey(factory, ec);
                Map<ConnectionFactory, ManagedConnection> connectionsForPool = this.connectionsPool.get(poolKey);
                if (connectionsForPool != null) {
                    if (connectionsForPool.remove(factory) != null && ConnectionManagerImpl.this.nucleusContext.getStatistics() != null) {
                        ConnectionManagerImpl.this.nucleusContext.getStatistics().decrementActiveConnections();
                    }
                    if (connectionsForPool.isEmpty()) {
                        this.connectionsPool.remove(poolKey);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedConnection getManagedConnection(ConnectionFactory factory, ExecutionContext ec) {
            Map<Object, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Object poolKey = this.getPoolKey(factory, ec);
                Map<ConnectionFactory, ManagedConnection> connectionsForEC = this.connectionsPool.get(poolKey);
                if (connectionsForEC == null) {
                    return null;
                }
                ManagedConnection mconn = connectionsForEC.get(factory);
                if (mconn != null) {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(Localiser.msg("009000"));
                    }
                    return mconn;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putManagedConnection(ConnectionFactory factory, ExecutionContext ec, ManagedConnection mconn) {
            Map<Object, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Object poolKey = this.getPoolKey(factory, ec);
                Map<ConnectionFactory, ManagedConnection> connectionsForOM = this.connectionsPool.get(poolKey);
                if (connectionsForOM == null) {
                    connectionsForOM = new HashMap<ConnectionFactory, ManagedConnection>();
                    this.connectionsPool.put(poolKey, connectionsForOM);
                }
                if (connectionsForOM.put(factory, mconn) == null && ConnectionManagerImpl.this.nucleusContext.getStatistics() != null) {
                    ConnectionManagerImpl.this.nucleusContext.getStatistics().incrementActiveConnections();
                }
            }
        }

        Object getPoolKey(ConnectionFactory factory, ExecutionContext ec) {
            if (ec.getStoreManager() instanceof FederatedStoreManager) {
                return new PoolKey(factory, ec);
            }
            return ec;
        }
    }
}

