/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.containers;

import java.util.List;
import java.util.Optional;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.types.ElementContainerAdapter;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.containers.CollectionHandler;
import org.datanucleus.store.types.containers.OptionalAdapter;

public class OptionalHandler
extends CollectionHandler<Optional> {
    @Override
    public Optional newContainer(AbstractMemberMetaData mmm) {
        return Optional.empty();
    }

    @Override
    public ElementContainerAdapter<Optional> getAdapter(Optional container) {
        return new OptionalAdapter(container);
    }

    @Override
    public Optional newContainer(AbstractMemberMetaData mmd, Object ... values) {
        return Optional.ofNullable(values[0]);
    }

    @Override
    public void populateMetaData(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mmgr, AbstractMemberMetaData mmd) {
        mmd.getCollection().setSingleElement(true);
        List<ColumnMetaData> columns = new AbstractMemberMetaData(mmd.getParent(), mmd){
            private static final long serialVersionUID = 1L;

            public List<ColumnMetaData> getColumns() {
                return this.columns;
            }
        }.getColumns();
        if (columns == null || columns.isEmpty()) {
            ColumnMetaData colmd = new ColumnMetaData();
            colmd.setAllowsNull(Boolean.TRUE);
            mmd.addColumn(colmd);
        }
        super.populateMetaData(clr, primary, mmgr, mmd);
    }

    @Override
    public boolean isDefaultFetchGroup(ClassLoaderResolver clr, MetaDataManager mmgr, AbstractMemberMetaData mmd) {
        String elementTypeName = mmd.getCollection().getElementType();
        Class elementClass = clr.classForName(elementTypeName);
        TypeManager typeMgr = mmgr.getNucleusContext().getTypeManager();
        return typeMgr.isDefaultFetchGroup(elementClass);
    }
}

