/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema.table;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.ColumnImpl;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.MemberColumnMappingImpl;
import org.datanucleus.store.schema.table.SchemaVerifier;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CompleteClassTable
implements Table {
    StoreManager storeMgr;
    AbstractClassMetaData cmd;
    String catalogName;
    String schemaName;
    String identifier;
    List<Column> columns = null;
    Column versionColumn;
    Column discriminatorColumn;
    Column datastoreIdColumn;
    Column multitenancyColumn;
    Map<AbstractMemberMetaData, MemberColumnMapping> mappingByMember = new HashMap<AbstractMemberMetaData, MemberColumnMapping>();
    Map<String, MemberColumnMapping> mappingByEmbeddedMember = new HashMap<String, MemberColumnMapping>();
    Map<String, Column> columnByName = new HashMap<String, Column>();
    SchemaVerifier schemaVerifier;

    public CompleteClassTable(StoreManager storeMgr, AbstractClassMetaData cmd, SchemaVerifier verifier) {
        ColumnImpl col;
        String colName;
        VersionMetaData vermd;
        MemberColumnMapping mapping;
        this.storeMgr = storeMgr;
        this.cmd = cmd;
        this.schemaVerifier = verifier;
        this.schemaName = cmd.getSchema() != null ? cmd.getSchema() : storeMgr.getStringProperty("datanucleus.mapping.Schema");
        this.catalogName = cmd.getCatalog() != null ? cmd.getCatalog() : storeMgr.getStringProperty("datanucleus.mapping.Catalog");
        this.identifier = storeMgr.getNamingFactory().getTableName(cmd);
        this.columns = new ArrayList<Column>();
        TypeManager typeMgr = storeMgr.getNucleusContext().getTypeManager();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        int numMembers = cmd.getAllMemberPositions().length;
        for (int i = 0; i < numMembers; ++i) {
            Column col2;
            String colName2;
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
            if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
            RelationType relationType = mmd.getRelationType(clr);
            if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(storeMgr.getMetaDataManager(), clr, mmd, relationType, null)) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                if (RelationType.isRelationSingleValued(relationType)) {
                    boolean nested = false;
                    if (storeMgr.getSupportedOptions().contains("ORM.EmbeddedPC.Nested")) {
                        nested = !storeMgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.embedded.flat");
                        String nestedStr = mmd.getValueForExtension("nested");
                        if (nestedStr != null && nestedStr.equalsIgnoreCase("" + !nested)) {
                            boolean bl = nested = !nested;
                        }
                    }
                    if (nested) {
                        ColumnMetaData[] colmds = mmd.getColumnMetaData();
                        String colName3 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                        ColumnImpl col3 = this.addColumn(mmd, colName3, null);
                        if (colmds != null && colmds.length == 1) {
                            col3.setColumnMetaData(colmds[0]);
                            if (colmds[0].getPosition() != null) {
                                col3.setPosition(colmds[0].getPosition());
                            }
                            if (colmds[0].getJdbcType() != null) {
                                col3.setJdbcType(colmds[0].getJdbcType());
                            }
                        }
                        MemberColumnMappingImpl mapping2 = new MemberColumnMappingImpl(mmd, col3);
                        col3.setMemberColumnMapping(mapping2);
                        if (this.schemaVerifier != null) {
                            this.schemaVerifier.attributeMember(mapping2, mmd);
                        }
                        this.mappingByMember.put(mmd, mapping2);
                        this.processEmbeddedMember(embMmds, clr, mmd.getEmbeddedMetaData(), true);
                        continue;
                    }
                    this.processEmbeddedMember(embMmds, clr, mmd.getEmbeddedMetaData(), false);
                    continue;
                }
                if (!RelationType.isRelationMultiValued(relationType)) continue;
                if (mmd.hasCollection()) {
                    if (storeMgr.getSupportedOptions().contains("ORM.EmbeddedCollection.Nested")) {
                        ColumnMetaData[] colmds = mmd.getColumnMetaData();
                        colName2 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                        col2 = this.addColumn(mmd, colName2, null);
                        if (colmds != null && colmds.length == 1) {
                            ((ColumnImpl)col2).setColumnMetaData(colmds[0]);
                            if (colmds[0].getPosition() != null) {
                                ((ColumnImpl)col2).setPosition(colmds[0].getPosition());
                            }
                            if (colmds[0].getJdbcType() != null) {
                                ((ColumnImpl)col2).setJdbcType(colmds[0].getJdbcType());
                            }
                        }
                        mapping = new MemberColumnMappingImpl(mmd, col2);
                        ((ColumnImpl)col2).setMemberColumnMapping(mapping);
                        if (this.schemaVerifier != null) {
                            this.schemaVerifier.attributeMember(mapping, mmd);
                        }
                        this.mappingByMember.put(mmd, mapping);
                        EmbeddedMetaData embmd = mmd.getElementMetaData() != null ? mmd.getElementMetaData().getEmbeddedMetaData() : null;
                        this.processEmbeddedMember(embMmds, clr, embmd, true);
                        continue;
                    }
                    NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded collection. Not yet supported. Ignoring");
                    continue;
                }
                if (mmd.hasMap()) {
                    if (storeMgr.getSupportedOptions().contains("ORM.EmbeddedMap.Nested")) {
                        ColumnMetaData[] colmds = mmd.getColumnMetaData();
                        colName2 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                        col2 = this.addColumn(mmd, colName2, null);
                        if (colmds != null && colmds.length == 1) {
                            ((ColumnImpl)col2).setColumnMetaData(colmds[0]);
                            if (colmds[0].getPosition() != null) {
                                ((ColumnImpl)col2).setPosition(colmds[0].getPosition());
                            }
                            if (colmds[0].getJdbcType() != null) {
                                ((ColumnImpl)col2).setJdbcType(colmds[0].getJdbcType());
                            }
                        }
                        mapping = new MemberColumnMappingImpl(mmd, col2);
                        ((ColumnImpl)col2).setMemberColumnMapping(mapping);
                        if (this.schemaVerifier != null) {
                            this.schemaVerifier.attributeMember(mapping, mmd);
                        }
                        this.mappingByMember.put(mmd, mapping);
                    }
                    NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded map. Not yet supported. Ignoring");
                    continue;
                }
                if (!mmd.hasArray()) continue;
                if (storeMgr.getSupportedOptions().contains("ORM.EmbeddedArray.Nested")) {
                    ColumnMetaData[] colmds = mmd.getColumnMetaData();
                    colName2 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                    col2 = this.addColumn(mmd, colName2, null);
                    if (colmds != null && colmds.length == 1) {
                        ((ColumnImpl)col2).setColumnMetaData(colmds[0]);
                        if (colmds[0].getPosition() != null) {
                            ((ColumnImpl)col2).setPosition(colmds[0].getPosition());
                        }
                        if (colmds[0].getJdbcType() != null) {
                            ((ColumnImpl)col2).setJdbcType(colmds[0].getJdbcType());
                        }
                    }
                    mapping = new MemberColumnMappingImpl(mmd, col2);
                    ((ColumnImpl)col2).setMemberColumnMapping(mapping);
                    if (this.schemaVerifier != null) {
                        this.schemaVerifier.attributeMember(mapping, mmd);
                    }
                    this.mappingByMember.put(mmd, mapping);
                    EmbeddedMetaData embmd = mmd.getElementMetaData() != null ? mmd.getElementMetaData().getEmbeddedMetaData() : null;
                    this.processEmbeddedMember(embMmds, clr, embmd, true);
                    continue;
                }
                NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded array. Not yet supported. Ignoring");
                continue;
            }
            ColumnMetaData[] colmds = mmd.getColumnMetaData();
            if ((colmds == null || colmds.length == 0) && mmd.hasCollection() && mmd.getElementMetaData() != null) {
                colmds = mmd.getElementMetaData().getColumnMetaData();
            }
            if (relationType != RelationType.NONE) {
                String colName4 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                ColumnImpl col4 = this.addColumn(mmd, colName4, null);
                if (colmds != null && colmds.length == 1) {
                    col4.setColumnMetaData(colmds[0]);
                    if (colmds[0].getPosition() != null) {
                        col4.setPosition(colmds[0].getPosition());
                    }
                    if (colmds[0].getJdbcType() != null) {
                        col4.setJdbcType(colmds[0].getJdbcType());
                    }
                }
                MemberColumnMappingImpl mapping3 = new MemberColumnMappingImpl(mmd, col4);
                col4.setMemberColumnMapping(mapping3);
                if (this.schemaVerifier != null) {
                    this.schemaVerifier.attributeMember(mapping3, mmd);
                }
                this.mappingByMember.put(mmd, mapping3);
                continue;
            }
            TypeConverter typeConv = this.getTypeConverterForMember(mmd, colmds, typeMgr);
            if (typeConv != null) {
                if (typeConv instanceof MultiColumnConverter) {
                    Class[] colJavaTypes = ((MultiColumnConverter)((Object)typeConv)).getDatastoreColumnTypes();
                    Column[] cols = new Column[colJavaTypes.length];
                    for (int j = 0; j < colJavaTypes.length; ++j) {
                        String colName5 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, j);
                        ColumnImpl col5 = this.addColumn(mmd, colName5);
                        if (colmds != null && colmds.length == 1) {
                            col5.setColumnMetaData(colmds[0]);
                            if (colmds[j].getPosition() != null) {
                                col5.setPosition(colmds[j].getPosition());
                            }
                            if (colmds[j].getJdbcType() != null) {
                                col5.setJdbcType(colmds[j].getJdbcType());
                            }
                        }
                        cols[j] = col5;
                    }
                    mapping = new MemberColumnMappingImpl(mmd, cols, typeConv);
                    for (int j = 0; j < colJavaTypes.length; ++j) {
                        ((ColumnImpl)cols[j]).setMemberColumnMapping(mapping);
                    }
                    if (this.schemaVerifier != null) {
                        this.schemaVerifier.attributeMember(mapping, mmd);
                    }
                    this.mappingByMember.put(mmd, mapping);
                    continue;
                }
                colName2 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
                col2 = this.addColumn(mmd, colName2);
                if (colmds != null && colmds.length == 1) {
                    ((ColumnImpl)col2).setColumnMetaData(colmds[0]);
                    if (colmds[0].getPosition() != null) {
                        ((ColumnImpl)col2).setPosition(colmds[0].getPosition());
                    }
                    if (colmds[0].getJdbcType() != null) {
                        ((ColumnImpl)col2).setJdbcType(colmds[0].getJdbcType());
                    }
                }
                mapping = new MemberColumnMappingImpl(mmd, col2);
                ((ColumnImpl)col2).setMemberColumnMapping(mapping);
                mapping.setTypeConverter(typeConv);
                if (this.schemaVerifier != null) {
                    this.schemaVerifier.attributeMember(mapping, mmd);
                }
                this.mappingByMember.put(mmd, mapping);
                continue;
            }
            colName2 = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0);
            col2 = this.addColumn(mmd, colName2);
            if (colmds != null && colmds.length == 1) {
                ((ColumnImpl)col2).setColumnMetaData(colmds[0]);
                if (colmds[0].getPosition() != null) {
                    ((ColumnImpl)col2).setPosition(colmds[0].getPosition());
                }
                if (colmds[0].getJdbcType() != null) {
                    ((ColumnImpl)col2).setJdbcType(colmds[0].getJdbcType());
                }
            }
            mapping = new MemberColumnMappingImpl(mmd, col2);
            if (mmd.hasCollection()) {
                if (mmd.getElementMetaData() != null && mmd.getElementMetaData().hasExtension("type-converter-name")) {
                    TypeConverter elemConv = typeMgr.getTypeConverterForName(mmd.getElementMetaData().getValueForExtension("type-converter-name"));
                    mapping.setTypeConverterForComponent(FieldRole.ROLE_COLLECTION_ELEMENT, elemConv);
                }
            } else if (mmd.hasMap()) {
                if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().hasExtension("type-converter-name")) {
                    TypeConverter keyConv = typeMgr.getTypeConverterForName(mmd.getKeyMetaData().getValueForExtension("type-converter-name"));
                    mapping.setTypeConverterForComponent(FieldRole.ROLE_MAP_KEY, keyConv);
                }
                if (mmd.getValueMetaData() != null && mmd.getValueMetaData().hasExtension("type-converter-name")) {
                    TypeConverter valConv = typeMgr.getTypeConverterForName(mmd.getValueMetaData().getValueForExtension("type-converter-name"));
                    mapping.setTypeConverterForComponent(FieldRole.ROLE_MAP_VALUE, valConv);
                }
            }
            ((ColumnImpl)col2).setMemberColumnMapping(mapping);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(mapping, mmd);
            }
            this.mappingByMember.put(mmd, mapping);
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            String colName6 = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
            ColumnImpl col6 = this.addColumn(null, colName6, ColumnType.DATASTOREID_COLUMN);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(new MemberColumnMappingImpl(null, col6));
            }
            if (cmd.getIdentityMetaData() != null && cmd.getIdentityMetaData().getColumnMetaData() != null) {
                if (cmd.getIdentityMetaData().getColumnMetaData().getPosition() != null) {
                    col6.setPosition(cmd.getIdentityMetaData().getColumnMetaData().getPosition());
                }
                if (cmd.getIdentityMetaData().getColumnMetaData().getJdbcType() != null) {
                    col6.setJdbcType(cmd.getIdentityMetaData().getColumnMetaData().getJdbcType());
                }
            }
            this.datastoreIdColumn = col6;
        }
        if ((vermd = cmd.getVersionMetaDataForClass()) != null && vermd.getFieldName() == null) {
            colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
            col = this.addColumn(null, colName, ColumnType.VERSION_COLUMN);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(new MemberColumnMappingImpl(null, col));
            }
            if (vermd.getColumnMetaData() != null) {
                if (vermd.getColumnMetaData().getPosition() != null) {
                    col.setPosition(vermd.getColumnMetaData().getPosition());
                }
                if (vermd.getColumnMetaData().getJdbcType() != null) {
                    col.setJdbcType(vermd.getColumnMetaData().getJdbcType());
                }
            }
            this.versionColumn = col;
        }
        if (cmd.hasDiscriminatorStrategy()) {
            Object dismd;
            colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            col = this.addColumn(null, colName, ColumnType.DISCRIMINATOR_COLUMN);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(new MemberColumnMappingImpl(null, col));
            }
            if ((dismd = cmd.getDiscriminatorMetaDataForTable()) != null && ((DiscriminatorMetaData)dismd).getColumnMetaData() != null) {
                if (((DiscriminatorMetaData)dismd).getColumnMetaData().getPosition() != null) {
                    col.setPosition(((DiscriminatorMetaData)dismd).getColumnMetaData().getPosition());
                }
                if (((DiscriminatorMetaData)dismd).getColumnMetaData().getJdbcType() != null) {
                    col.setJdbcType(((DiscriminatorMetaData)dismd).getColumnMetaData().getJdbcType());
                }
            }
            this.discriminatorColumn = col;
        }
        if (storeMgr.getNucleusContext().isClassMultiTenant(cmd)) {
            colName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN);
            col = this.addColumn(null, colName, ColumnType.MULTITENANCY_COLUMN);
            col.setJdbcType(JdbcType.VARCHAR);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeMember(new MemberColumnMappingImpl(null, col));
            }
            this.multitenancyColumn = col;
        }
        ArrayList<Column> unorderedCols = new ArrayList<Column>();
        Column[] cols = new Column[this.columns.size()];
        for (Column col7 : this.columns) {
            if (col7.getPosition() >= this.columns.size()) {
                NucleusLogger.DATASTORE_SCHEMA.warn("Column with name " + col7.getName() + " is specified with position=" + col7.getPosition() + " which is invalid." + " This table has " + this.columns.size() + " columns");
                unorderedCols.add(col7);
                continue;
            }
            if (col7.getPosition() >= 0) {
                if (cols[col7.getPosition()] != null) {
                    NucleusLogger.DATASTORE_SCHEMA.warn("Column with name " + col7.getName() + " defined for position=" + col7.getPosition() + " yet there is also " + cols[col7.getPosition()].getName() + " at that position! Ignoring");
                    unorderedCols.add(col7);
                    continue;
                }
                cols[col7.getPosition()] = col7;
                continue;
            }
            unorderedCols.add(col7);
        }
        if (!unorderedCols.isEmpty()) {
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i] != null) continue;
                cols[i] = (Column)unorderedCols.get(0);
                cols[i].setPosition(i);
                unorderedCols.remove(0);
            }
        }
        this.columns = new ArrayList<Column>();
        for (Column col2 : cols) {
            mapping = col2.getMemberColumnMapping();
            if (mapping != null) {
                if (!mapping.getMemberMetaData().isInsertable() && !mapping.getMemberMetaData().isUpdateable()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug("Not adding column " + col2.getName() + " for member=" + mapping.getMemberMetaData().getFullFieldName() + " since is not insertable/updateable");
                    continue;
                }
                if (this.columnByName.containsKey(col2.getName())) {
                    Column otherCol = this.columnByName.get(col2.getName());
                    if (!(((ColumnImpl)col2).isNested() || ((ColumnImpl)otherCol).isNested() || mapping.getMemberMetaData() instanceof PropertyMetaData && otherCol.getMemberColumnMapping().getMemberMetaData() instanceof PropertyMetaData)) {
                        NucleusLogger.DATASTORE_SCHEMA.error("Unable to add column with name=" + col2.getName() + " to table=" + this.getName() + " for class=" + cmd.getFullClassName() + " since one with same name already exists (superclass?).");
                        throw new NucleusUserException("Unable to add column with name=" + col2.getName() + " to table=" + this.getName() + " for class=" + cmd.getFullClassName() + " since one with same name already exists (superclass?).");
                    }
                }
                this.columns.add(col2);
                this.columnByName.put(col2.getName(), col2);
                continue;
            }
            this.columns.add(col2);
            this.columnByName.put(col2.getName(), col2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected TypeConverter getTypeConverterForMember(AbstractMemberMetaData mmd, ColumnMetaData[] colmds, TypeManager typeMgr) {
        TypeConverter typeConv;
        block9: {
            block11: {
                JdbcType jdbcType;
                block14: {
                    block13: {
                        block12: {
                            block10: {
                                typeConv = null;
                                String typeConvName = mmd.getTypeConverterName();
                                if (typeConvName != null) {
                                    typeConv = typeMgr.getTypeConverterForName(typeConvName);
                                    if (typeConv == null) {
                                        throw new NucleusUserException(Localiser.msg("044062", mmd.getFullFieldName(), typeConvName));
                                    }
                                } else {
                                    typeConv = typeMgr.getAutoApplyTypeConverterForType(mmd.getType());
                                }
                                if (typeConv != null) break block9;
                                if (colmds == null || colmds.length <= 1) break block10;
                                Collection<TypeConverter> converters = typeMgr.getTypeConvertersForType(mmd.getType());
                                if (converters != null && !converters.isEmpty()) {
                                    for (TypeConverter conv : converters) {
                                        if (!(conv instanceof MultiColumnConverter) || ((MultiColumnConverter)((Object)conv)).getDatastoreColumnTypes().length != colmds.length) continue;
                                        typeConv = conv;
                                        break;
                                    }
                                }
                                if (typeConv != null) {
                                    // empty if block
                                }
                                break block9;
                            }
                            JdbcType jdbcType2 = jdbcType = colmds != null && colmds.length > 0 ? colmds[0].getJdbcType() : null;
                            if (jdbcType == null) break block11;
                            if (!MetaDataUtils.isJdbcTypeString(jdbcType)) break block12;
                            typeConv = typeMgr.getTypeConverterForType(mmd.getType(), String.class);
                            break block9;
                        }
                        if (!MetaDataUtils.isJdbcTypeNumeric(jdbcType)) break block13;
                        typeConv = typeMgr.getTypeConverterForType(mmd.getType(), Long.class);
                        break block9;
                    }
                    if (jdbcType != JdbcType.TIMESTAMP) break block14;
                    typeConv = typeMgr.getTypeConverterForType(mmd.getType(), Timestamp.class);
                    break block9;
                }
                if (jdbcType == JdbcType.TIME) {
                    typeConv = typeMgr.getTypeConverterForType(mmd.getType(), Time.class);
                    break block9;
                } else if (jdbcType == JdbcType.DATE) {
                    typeConv = typeMgr.getTypeConverterForType(mmd.getType(), Date.class);
                }
                break block9;
            }
            typeConv = typeMgr.getDefaultTypeConverterForType(mmd.getType());
        }
        if (this.schemaVerifier == null) return typeConv;
        return this.schemaVerifier.verifyTypeConverterForMember(mmd, typeConv);
    }

    protected void processEmbeddedMember(List<AbstractMemberMetaData> mmds, ClassLoaderResolver clr, EmbeddedMetaData embmd, boolean ownerNested) {
        TypeManager typeMgr = this.storeMgr.getNucleusContext().getTypeManager();
        MetaDataManager mmgr = this.storeMgr.getMetaDataManager();
        NamingFactory namingFactory = this.storeMgr.getNamingFactory();
        AbstractMemberMetaData lastMmd = mmds.get(mmds.size() - 1);
        AbstractClassMetaData embCmd = null;
        embCmd = lastMmd.hasCollection() ? mmgr.getMetaDataForClass(lastMmd.getCollection().getElementType(), clr) : (lastMmd.hasArray() ? mmgr.getMetaDataForClass(lastMmd.getArray().getElementType(), clr) : mmgr.getMetaDataForClass(lastMmd.getType(), clr));
        int[] memberPositions = embCmd.getAllMemberPositions();
        for (int i = 0; i < memberPositions.length; ++i) {
            MemberColumnMappingImpl mapping;
            ColumnImpl col;
            String colName;
            RelationType relationType;
            AbstractMemberMetaData[] embmdMmds;
            AbstractMemberMetaData mmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
            if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) continue;
            AbstractMemberMetaData embmdMmd = null;
            if (embmd != null && (embmdMmds = embmd.getMemberMetaData()) != null) {
                for (AbstractMemberMetaData thisMmd : embmdMmds) {
                    if (!thisMmd.getName().equals(mmd.getName())) continue;
                    embmdMmd = thisMmd;
                    break;
                }
            }
            if ((relationType = mmd.getRelationType(clr)) != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(mmgr, clr, mmd, relationType, lastMmd)) {
                if (RelationType.isRelationSingleValued(relationType)) {
                    boolean nested = false;
                    if (this.storeMgr.getSupportedOptions().contains("ORM.EmbeddedPC.Nested")) {
                        nested = !this.storeMgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.embedded.flat");
                        String nestedStr = mmd.getValueForExtension("nested");
                        if (nestedStr != null && nestedStr.equalsIgnoreCase("" + !nested)) {
                            nested = !nested;
                        }
                    }
                    ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(mmds);
                    embMmds.add(mmd);
                    if (nested) {
                        ColumnMetaData[] colmds = mmd.getColumnMetaData();
                        colName = namingFactory.getColumnName(embMmds, 0);
                        col = this.addEmbeddedColumn(colName, null);
                        col.setNested(true);
                        if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getPosition() != null) {
                            col.setPosition(embmdMmd.getColumnMetaData()[0].getPosition());
                        } else if (colmds != null && colmds.length == 1 && colmds[0].getPosition() != null) {
                            col.setPosition(colmds[0].getPosition());
                        }
                        if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getJdbcType() != null) {
                            col.setJdbcType(embmdMmd.getColumnMetaData()[0].getJdbcType());
                        } else if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                            col.setJdbcType(colmds[0].getJdbcType());
                        }
                        mapping = new MemberColumnMappingImpl(mmd, col);
                        col.setMemberColumnMapping(mapping);
                        if (this.schemaVerifier != null) {
                            this.schemaVerifier.attributeEmbeddedMember(mapping, embMmds);
                        }
                        this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping);
                        this.processEmbeddedMember(embMmds, clr, embmdMmd != null ? embmdMmd.getEmbeddedMetaData() : null, true);
                        continue;
                    }
                    this.processEmbeddedMember(embMmds, clr, embmdMmd != null ? embmdMmd.getEmbeddedMetaData() : null, false);
                    continue;
                }
                if (mmd.hasCollection()) {
                    if (this.storeMgr.getSupportedOptions().contains("ORM.EmbeddedCollection.Nested")) {
                        // empty if block
                    }
                    NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded collection. Not yet supported. Ignoring");
                    continue;
                }
                if (mmd.hasMap()) {
                    if (this.storeMgr.getSupportedOptions().contains("ORM.EmbeddedMap.Nested")) {
                        // empty if block
                    }
                    NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded collection. Not yet supported. Ignoring");
                    continue;
                }
                if (!mmd.hasArray()) continue;
                if (this.storeMgr.getSupportedOptions().contains("ORM.EmbeddedArray.Nested")) {
                    // empty if block
                }
                NucleusLogger.DATASTORE_SCHEMA.warn("Member " + mmd.getFullFieldName() + " is an embedded array. Not yet supported. Ignoring");
                continue;
            }
            ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(mmds);
            embMmds.add(mmd);
            ColumnMetaData[] colmds = mmd.getColumnMetaData();
            if (relationType != RelationType.NONE) {
                String colName2 = namingFactory.getColumnName(embMmds, 0);
                ColumnImpl col2 = this.addEmbeddedColumn(colName2, null);
                col2.setNested(ownerNested);
                if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getPosition() != null) {
                    col2.setPosition(embmdMmd.getColumnMetaData()[0].getPosition());
                } else if (colmds != null && colmds.length == 1 && colmds[0].getPosition() != null) {
                    col2.setPosition(colmds[0].getPosition());
                }
                if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getJdbcType() != null) {
                    col2.setJdbcType(embmdMmd.getColumnMetaData()[0].getJdbcType());
                } else if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                    col2.setJdbcType(colmds[0].getJdbcType());
                }
                MemberColumnMappingImpl mapping2 = new MemberColumnMappingImpl(mmd, col2);
                col2.setMemberColumnMapping(mapping2);
                if (this.schemaVerifier != null) {
                    this.schemaVerifier.attributeEmbeddedMember(mapping2, embMmds);
                }
                this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping2);
                continue;
            }
            TypeConverter typeConv = this.getTypeConverterForMember(mmd, colmds, typeMgr);
            if (typeConv != null) {
                if (typeConv instanceof MultiColumnConverter) {
                    Class[] colJavaTypes = ((MultiColumnConverter)((Object)typeConv)).getDatastoreColumnTypes();
                    Column[] cols = new Column[colJavaTypes.length];
                    for (int j = 0; j < colJavaTypes.length; ++j) {
                        String colName3 = namingFactory.getColumnName(embMmds, j);
                        ColumnImpl col3 = this.addEmbeddedColumn(colName3, typeConv);
                        col3.setNested(ownerNested);
                        if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == colJavaTypes.length && embmdMmd.getColumnMetaData()[j].getPosition() != null) {
                            col3.setPosition(embmdMmd.getColumnMetaData()[j].getPosition());
                        } else if (colmds != null && colmds.length == colJavaTypes.length && colmds[j].getPosition() != null) {
                            col3.setPosition(colmds[j].getPosition());
                        }
                        if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == colJavaTypes.length && embmdMmd.getColumnMetaData()[j].getJdbcType() != null) {
                            col3.setJdbcType(embmdMmd.getColumnMetaData()[j].getJdbcType());
                        } else if (colmds != null && colmds.length == colJavaTypes.length && colmds[j].getJdbcType() != null) {
                            col3.setJdbcType(colmds[j].getJdbcType());
                        }
                        cols[j] = col3;
                    }
                    mapping = new MemberColumnMappingImpl(mmd, cols, typeConv);
                    for (int j = 0; j < colJavaTypes.length; ++j) {
                        ((ColumnImpl)cols[j]).setMemberColumnMapping(mapping);
                    }
                    if (this.schemaVerifier != null) {
                        this.schemaVerifier.attributeEmbeddedMember(mapping, embMmds);
                    }
                    this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping);
                    continue;
                }
                colName = namingFactory.getColumnName(embMmds, 0);
                col = this.addEmbeddedColumn(colName, typeConv);
                col.setNested(ownerNested);
                if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getPosition() != null) {
                    col.setPosition(embmdMmd.getColumnMetaData()[0].getPosition());
                } else if (colmds != null && colmds.length == 1 && colmds[0].getPosition() != null) {
                    col.setPosition(colmds[0].getPosition());
                }
                if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getJdbcType() != null) {
                    col.setJdbcType(embmdMmd.getColumnMetaData()[0].getJdbcType());
                } else if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                    col.setJdbcType(colmds[0].getJdbcType());
                }
                mapping = new MemberColumnMappingImpl(mmd, col);
                col.setMemberColumnMapping(mapping);
                mapping.setTypeConverter(typeConv);
                if (this.schemaVerifier != null) {
                    this.schemaVerifier.attributeEmbeddedMember(mapping, embMmds);
                }
                this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping);
                continue;
            }
            colName = namingFactory.getColumnName(embMmds, 0);
            col = this.addEmbeddedColumn(colName, null);
            col.setNested(ownerNested);
            AbstractMemberMetaData theMmd = (AbstractMemberMetaData)embMmds.get(0);
            if (theMmd.isPrimaryKey()) {
                col.setPrimaryKey();
            }
            if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getPosition() != null) {
                col.setPosition(embmdMmd.getColumnMetaData()[0].getPosition());
            } else if (colmds != null && colmds.length == 1 && colmds[0].getPosition() != null) {
                col.setPosition(colmds[0].getPosition());
            }
            if (embmdMmd != null && embmdMmd.getColumnMetaData() != null && embmdMmd.getColumnMetaData().length == 1 && embmdMmd.getColumnMetaData()[0].getJdbcType() != null) {
                col.setJdbcType(embmdMmd.getColumnMetaData()[0].getJdbcType());
            } else if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                col.setJdbcType(colmds[0].getJdbcType());
            }
            MemberColumnMappingImpl mapping3 = new MemberColumnMappingImpl(mmd, col);
            col.setMemberColumnMapping(mapping3);
            if (this.schemaVerifier != null) {
                this.schemaVerifier.attributeEmbeddedMember(mapping3, embMmds);
            }
            this.mappingByEmbeddedMember.put(this.getEmbeddedMemberNavigatedPath(embMmds), mapping3);
        }
    }

    protected ColumnImpl addColumn(AbstractMemberMetaData mmd, String colName) {
        return this.addColumn(mmd, colName, ColumnType.COLUMN);
    }

    protected ColumnImpl addColumn(AbstractMemberMetaData mmd, String colName, ColumnType colType) {
        ColumnImpl col = new ColumnImpl(this, colName, colType);
        if (mmd != null) {
            if (mmd.isPrimaryKey()) {
                col.setPrimaryKey();
            }
        } else if (colType == ColumnType.DATASTOREID_COLUMN) {
            col.setPrimaryKey();
        }
        this.columns.add(col);
        return col;
    }

    protected ColumnImpl addEmbeddedColumn(String colName, TypeConverter typeConv) {
        ColumnImpl col = new ColumnImpl(this, colName, ColumnType.COLUMN);
        this.columns.add(col);
        return col;
    }

    private String getEmbeddedMemberNavigatedPath(List<AbstractMemberMetaData> mmds) {
        Iterator<AbstractMemberMetaData> mmdIter = mmds.iterator();
        StringBuilder strBldr = new StringBuilder(mmdIter.next().getFullFieldName());
        while (mmdIter.hasNext()) {
            strBldr.append('.').append(mmdIter.next().getName());
        }
        return strBldr.toString();
    }

    @Override
    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    @Override
    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getName() {
        return this.identifier;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns.size();
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public Column getColumnForPosition(int pos) {
        if (pos < 0 || pos >= this.columns.size()) {
            throw new ArrayIndexOutOfBoundsException("There are " + this.columns.size() + " columns, so specify a value between 0 and " + (this.columns.size() - 1));
        }
        return this.columns.get(pos);
    }

    @Override
    public Column getDatastoreIdColumn() {
        return this.datastoreIdColumn;
    }

    @Override
    public Column getVersionColumn() {
        return this.versionColumn;
    }

    @Override
    public Column getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public Column getMultitenancyColumn() {
        return this.multitenancyColumn;
    }

    @Override
    public Column getColumnForName(String name) {
        Column col = this.columnByName.get(name);
        if (col != null) {
            return col;
        }
        if (!name.startsWith("\"")) {
            col = this.columnByName.get("\"" + name + "\"");
        }
        return col;
    }

    @Override
    public MemberColumnMapping getMemberColumnMappingForMember(AbstractMemberMetaData mmd) {
        return this.mappingByMember.get(mmd);
    }

    @Override
    public MemberColumnMapping getMemberColumnMappingForEmbeddedMember(List<AbstractMemberMetaData> mmds) {
        return this.mappingByEmbeddedMember.get(this.getEmbeddedMemberNavigatedPath(mmds));
    }

    @Override
    public Set<MemberColumnMapping> getMemberColumnMappings() {
        HashSet<MemberColumnMapping> mappings = new HashSet<MemberColumnMapping>(this.mappingByMember.values());
        mappings.addAll(this.mappingByEmbeddedMember.values());
        return mappings;
    }

    public String toString() {
        return "Table: " + this.identifier;
    }

    public String debugString() {
        StringBuilder str = new StringBuilder();
        str.append("Table: ");
        if (this.catalogName != null) {
            str.append(this.catalogName).append('.');
        }
        if (this.schemaName != null) {
            str.append(this.schemaName).append('.');
        }
        str.append(this.identifier).append("\n");
        str.append("{\n");
        for (Column col : this.columns) {
            str.append("  ").append(col.toString()).append("\n");
        }
        str.append("}");
        return str.toString();
    }
}

