/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.sql.Date;
import java.time.YearMonth;
import java.time.ZoneId;
import org.datanucleus.store.types.converters.TypeConverter;

public class YearMonthDateConverter
implements TypeConverter<YearMonth, Date> {
    private static final long serialVersionUID = 8087124973147837116L;

    @Override
    public YearMonth toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        return YearMonth.from(date.toLocalDate());
    }

    @Override
    public Date toDatastoreType(YearMonth ym) {
        if (ym == null) {
            return null;
        }
        return new Date(Date.from(ym.atDay(2).atStartOfDay(ZoneId.systemDefault()).toInstant()).getTime());
    }
}

