/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import org.datanucleus.FetchPlanForClass;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFetchDepthFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.types.ContainerAdapter;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.TypeManager;

public class MakeTransientFieldManager
extends AbstractFetchDepthFieldManager {
    public MakeTransientFieldManager(ObjectProvider sm, boolean[] secondClassMutableFields, FetchPlanForClass fpClass, FetchPlanState state) {
        super(sm, secondClassMutableFields, fpClass, state);
    }

    protected void processPersistable(Object pc) {
        if (this.op.getExecutionContext().getApiAdapter().isPersistent(pc)) {
            this.op.getExecutionContext().getApiAdapter().getExecutionContext(pc).makeObjectTransient(pc, this.state);
        }
    }

    @Override
    protected Object internalFetchObjectField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.op.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        if (value != null) {
            AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            RelationType relType = mmd.getRelationType(this.op.getExecutionContext().getClassLoaderResolver());
            if (relType != RelationType.NONE) {
                if (mmd.hasContainer()) {
                    value = SCOUtils.wrapSCOField(this.op, fieldNumber, value, true);
                    TypeManager typeManager = this.op.getExecutionContext().getTypeManager();
                    ContainerAdapter containerAdapter = typeManager.getContainerAdapter(value);
                    ApiAdapter api = this.op.getExecutionContext().getApiAdapter();
                    for (Object object : containerAdapter) {
                        if (!api.isPersistable(object)) continue;
                        this.processPersistable(object);
                    }
                } else {
                    this.processPersistable(value);
                }
            }
            if (value instanceof SCO) {
                ((SCO)value).unsetOwner();
            }
        }
        return value;
    }

    @Override
    protected Object endOfGraphOperation(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.op.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        if (value != null && this.secondClassMutableFields[fieldNumber] && value instanceof SCO) {
            SCO sco = (SCO)value;
            sco.unsetOwner();
        }
        return value;
    }
}

