/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class BigIntegerArrayByteBufferConverter
implements TypeConverter<BigInteger[], ByteBuffer> {
    private static final long serialVersionUID = 1225964406998563456L;

    @Override
    public ByteBuffer toDatastoreType(BigInteger[] memberValue) {
        byte[] bytes = TypeConversionHelper.getByteArrayFromBigIntegerArray(memberValue);
        ByteBuffer byteBuffer = ByteBuffer.allocate(memberValue.length);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    @Override
    public BigInteger[] toMemberType(ByteBuffer datastoreValue) {
        return TypeConversionHelper.getBigIntegerArrayFromByteArray(datastoreValue.array());
    }
}

