/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.PersistenceNucleusContextImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.enhancer.EnhancementNucleusContextImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataMerger;
import org.datanucleus.metadata.MetaDataScanner;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.MetadataFileType;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.StoredProcQueryMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.annotations.AnnotationManager;
import org.datanucleus.metadata.annotations.AnnotationManagerImpl;
import org.datanucleus.metadata.xml.MetaDataParser;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class MetaDataManagerImpl
implements Serializable,
MetaDataManager {
    private static final long serialVersionUID = 5223949693488111123L;
    protected final NucleusContext nucleusContext;
    protected final AnnotationManager annotationManager;
    protected MetaDataParser metaDataParser = null;
    protected boolean validateXML = true;
    protected boolean supportXMLNamespaces = true;
    protected boolean allowMetaDataLoad = true;
    protected boolean allowXML = true;
    protected boolean allowAnnotations = true;
    protected boolean allowORM = true;
    protected Lock updateLock = null;
    protected Collection<String> classesWithoutPersistenceInfo = new HashSet<String>();
    protected Map<String, AbstractClassMetaData> classMetaDataByClass = new ConcurrentHashMap<String, AbstractClassMetaData>();
    protected Map<String, AbstractClassMetaData> usableClassMetaDataByClass = new ConcurrentHashMap<String, AbstractClassMetaData>();
    protected Map<String, FileMetaData> fileMetaDataByURLString = new ConcurrentHashMap<String, FileMetaData>();
    protected Map<String, AbstractClassMetaData> classMetaDataByEntityName = new ConcurrentHashMap<String, AbstractClassMetaData>();
    protected Map<String, AbstractClassMetaData> classMetaDataByDiscriminatorName = new ConcurrentHashMap<String, AbstractClassMetaData>();
    protected Map<String, Set<String>> directSubclassesByClass = new ConcurrentHashMap<String, Set<String>>();
    protected Map<String, Set<String>> concreteSubclassNamesByClassName = new ConcurrentHashMap<String, Set<String>>();
    protected Map<String, QueryMetaData> queryMetaDataByName = null;
    protected Map<String, StoredProcQueryMetaData> storedProcQueryMetaDataByName = null;
    protected Map<String, FetchPlanMetaData> fetchPlanMetaDataByName = null;
    protected Map<String, SequenceMetaData> sequenceMetaDataByPackageSequence = null;
    protected Map<String, TableGeneratorMetaData> tableGeneratorMetaDataByPackageSequence = null;
    protected Map<String, QueryResultMetaData> queryResultMetaDataByName = null;
    protected MultiMap classMetaDataByAppIdClassName = new MultiMap();
    protected Set<MetaDataListener> listeners = null;
    private List<AbstractClassMetaData> listenersLoadedMetaData = null;
    protected int userMetaDataNumber = 0;
    protected Map<String, DiscriminatorLookup> discriminatorLookupByRootClassName = new ConcurrentHashMap<String, DiscriminatorLookup>();
    protected ArrayList<FileMetaData> utilisedFileMetaData = new ArrayList();

    public MetaDataManagerImpl(NucleusContext ctx) {
        Boolean configOrm;
        this.nucleusContext = ctx;
        this.updateLock = new ReentrantLock();
        this.validateXML = this.nucleusContext.getConfiguration().getBooleanProperty("datanucleus.metadata.xml.validate");
        this.supportXMLNamespaces = this.nucleusContext.getConfiguration().getBooleanProperty("datanucleus.metadata.xml.namespaceAware");
        this.allowXML = this.nucleusContext.getConfiguration().getBooleanProperty("datanucleus.metadata.allowXML");
        this.allowAnnotations = this.nucleusContext.getConfiguration().getBooleanProperty("datanucleus.metadata.allowAnnotations");
        this.annotationManager = new AnnotationManagerImpl(this);
        Set<String> supportedClasses = this.nucleusContext.getTypeManager().getSupportedSecondClassTypes();
        Iterator<String> iter = supportedClasses.iterator();
        while (iter.hasNext()) {
            this.classesWithoutPersistenceInfo.add(iter.next());
        }
        this.allowORM = this.nucleusContext.supportsORMMetaData();
        if (this.allowORM && (configOrm = this.nucleusContext.getConfiguration().getBooleanObjectProperty("datanucleus.metadata.supportORM")) != null && !configOrm.booleanValue()) {
            this.allowORM = false;
        }
    }

    @Override
    public void close() {
        this.classMetaDataByClass.clear();
        this.classMetaDataByClass = null;
        this.usableClassMetaDataByClass.clear();
        this.usableClassMetaDataByClass = null;
        this.fileMetaDataByURLString.clear();
        this.fileMetaDataByURLString = null;
        this.classesWithoutPersistenceInfo.clear();
        this.classesWithoutPersistenceInfo = null;
        this.directSubclassesByClass.clear();
        this.directSubclassesByClass = null;
        this.concreteSubclassNamesByClassName.clear();
        this.concreteSubclassNamesByClassName = null;
        if (this.classMetaDataByEntityName != null) {
            this.classMetaDataByEntityName.clear();
            this.classMetaDataByEntityName = null;
        }
        if (this.classMetaDataByDiscriminatorName != null) {
            this.classMetaDataByDiscriminatorName.clear();
            this.classMetaDataByDiscriminatorName = null;
        }
        if (this.queryMetaDataByName != null) {
            this.queryMetaDataByName.clear();
            this.queryMetaDataByName = null;
        }
        if (this.storedProcQueryMetaDataByName != null) {
            this.storedProcQueryMetaDataByName.clear();
            this.storedProcQueryMetaDataByName = null;
        }
        if (this.fetchPlanMetaDataByName != null) {
            this.fetchPlanMetaDataByName.clear();
            this.fetchPlanMetaDataByName = null;
        }
        if (this.sequenceMetaDataByPackageSequence != null) {
            this.sequenceMetaDataByPackageSequence.clear();
            this.sequenceMetaDataByPackageSequence = null;
        }
        if (this.tableGeneratorMetaDataByPackageSequence != null) {
            this.tableGeneratorMetaDataByPackageSequence.clear();
            this.tableGeneratorMetaDataByPackageSequence = null;
        }
        if (this.queryResultMetaDataByName != null) {
            this.queryResultMetaDataByName.clear();
            this.queryResultMetaDataByName = null;
        }
        if (this.classMetaDataByAppIdClassName != null) {
            this.classMetaDataByAppIdClassName.clear();
            this.classMetaDataByAppIdClassName = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    @Override
    public void registerListener(MetaDataListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<MetaDataListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void deregisterListener(MetaDataListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    @Override
    public void setAllowMetaDataLoad(boolean allow) {
        this.allowMetaDataLoad = allow;
    }

    @Override
    public void setAllowXML(boolean allow) {
        this.allowXML = allow;
    }

    @Override
    public void setAllowAnnotations(boolean allow) {
        this.allowAnnotations = allow;
    }

    @Override
    public boolean supportsORM() {
        return this.allowORM;
    }

    @Override
    public boolean isEnhancing() {
        return this.getNucleusContext() instanceof EnhancementNucleusContextImpl;
    }

    @Override
    public void setValidate(boolean validate) {
        this.validateXML = validate;
    }

    @Override
    public void setXmlNamespaceAware(boolean aware) {
        this.supportXMLNamespaces = aware;
    }

    @Override
    public NucleusContext getNucleusContext() {
        return this.nucleusContext;
    }

    @Override
    public ApiAdapter getApiAdapter() {
        return this.nucleusContext.getApiAdapter();
    }

    @Override
    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileMetaData[] loadMetadataFiles(String[] metadataFiles, ClassLoader loader) {
        if (!this.allowMetaDataLoad) {
            return null;
        }
        boolean originatingLoadCall = false;
        if (this.listenersLoadedMetaData == null && this.listeners != null) {
            originatingLoadCall = true;
            this.listenersLoadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        try {
            ClassLoaderResolver clr;
            Collection<FileMetaData> fileMetaData;
            if (originatingLoadCall) {
                this.updateLock.lock();
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044005", StringUtils.objectArrayToString(metadataFiles)));
            }
            if (!(fileMetaData = this.loadFiles(metadataFiles, clr = this.nucleusContext.getClassLoaderResolver(loader))).isEmpty()) {
                this.initialiseFileMetaDataForUse(fileMetaData, clr);
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044010"));
            }
            if (originatingLoadCall) {
                this.processListenerLoadingCall();
            }
            FileMetaData[] fileMetaDataArray = fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
            return fileMetaDataArray;
        }
        finally {
            if (originatingLoadCall) {
                this.updateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileMetaData[] loadClasses(String[] classNames, ClassLoader loader) {
        if (!this.allowMetaDataLoad) {
            return null;
        }
        boolean originatingLoadCall = false;
        if (this.listenersLoadedMetaData == null && this.listeners != null) {
            originatingLoadCall = true;
            this.listenersLoadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        try {
            if (originatingLoadCall) {
                this.updateLock.lock();
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044006", StringUtils.objectArrayToString(classNames)));
            }
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(loader);
            ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
            HashSet<Exception> exceptions = new HashSet<Exception>();
            for (int i = 0; i < classNames.length; ++i) {
                try {
                    Class cls = clr.classForName(classNames[i]);
                    AbstractClassMetaData cmd = this.classMetaDataByClass.get(classNames[i]);
                    if (cmd == null) {
                        FileMetaData filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                        if (filemd != null) {
                            this.registerFile("annotations:" + classNames[i], filemd, clr);
                            fileMetaData.add(filemd);
                            continue;
                        }
                        cmd = this.getMetaDataForClass(cls, clr);
                        if (cmd == null) {
                            NucleusLogger.METADATA.debug(Localiser.msg("044017", classNames[i]));
                            continue;
                        }
                        fileMetaData.add(cmd.getPackageMetaData().getFileMetaData());
                        continue;
                    }
                    fileMetaData.add(cmd.getPackageMetaData().getFileMetaData());
                    continue;
                }
                catch (ClassNotResolvedException e) {
                    NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                    continue;
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            if (!exceptions.isEmpty()) {
                throw new NucleusUserException(Localiser.msg("044016"), exceptions.toArray(new Throwable[exceptions.size()]), null);
            }
            if (!fileMetaData.isEmpty()) {
                this.initialiseFileMetaDataForUse(fileMetaData, clr);
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044010"));
            }
            if (originatingLoadCall) {
                this.processListenerLoadingCall();
            }
            FileMetaData[] fileMetaDataArray = fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
            return fileMetaDataArray;
        }
        finally {
            if (originatingLoadCall) {
                this.updateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileMetaData[] loadJar(String jarFileName, ClassLoader loader) {
        if (!this.allowMetaDataLoad) {
            return null;
        }
        boolean originatingLoadCall = false;
        if (this.listenersLoadedMetaData == null && this.listeners != null) {
            originatingLoadCall = true;
            this.listenersLoadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        try {
            FileMetaData filemd;
            String[] jarClassNames;
            String[] packageJdoFiles;
            if (originatingLoadCall) {
                this.updateLock.lock();
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044009", jarFileName));
            }
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(loader);
            ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
            HashSet<String> mappingFiles = new HashSet<String>();
            if (this.allowXML && (packageJdoFiles = ClassUtils.getPackageJdoFilesForJarFile(jarFileName)) != null) {
                for (int i = 0; i < packageJdoFiles.length; ++i) {
                    mappingFiles.add(packageJdoFiles[i]);
                }
            }
            HashSet<String> classNames = new HashSet<String>();
            if (this.allowAnnotations && (jarClassNames = ClassUtils.getClassNamesForJarFile(jarFileName)) != null) {
                for (int i = 0; i < jarClassNames.length; ++i) {
                    classNames.add(jarClassNames[i]);
                }
            }
            HashSet<Throwable> exceptions = new HashSet<Throwable>();
            if (this.allowXML && !mappingFiles.isEmpty()) {
                for (String mappingFileName : mappingFiles) {
                    try {
                        Enumeration<URL> files = clr.getResources(mappingFileName, Thread.currentThread().getContextClassLoader());
                        while (files.hasMoreElements()) {
                            URL url = files.nextElement();
                            if (url == null || this.fileMetaDataByURLString.get(url.toString()) != null || (filemd = this.parseFile(url)) == null) continue;
                            this.registerFile(url.toString(), filemd, clr);
                            fileMetaData.add(filemd);
                        }
                    }
                    catch (InvalidMetaDataException imde) {
                        NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(imde));
                        exceptions.add(imde);
                    }
                    catch (IOException ioe) {
                        NucleusLogger.METADATA.error(Localiser.msg("044027", jarFileName, mappingFileName, ioe.getMessage()), ioe);
                    }
                }
            }
            if (this.allowAnnotations && !classNames.isEmpty()) {
                for (String className : classNames) {
                    AbstractClassMetaData cmd = this.classMetaDataByClass.get(className);
                    if (cmd != null) continue;
                    try {
                        Class cls = clr.classForName(className);
                        filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                        if (filemd == null) continue;
                        fileMetaData.add(filemd);
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                    }
                    catch (Throwable e) {
                        exceptions.add(e);
                    }
                }
            }
            if (!exceptions.isEmpty()) {
                throw new NucleusUserException(Localiser.msg("044024", jarFileName), exceptions.toArray(new Throwable[exceptions.size()]));
            }
            if (!fileMetaData.isEmpty()) {
                this.initialiseFileMetaDataForUse(fileMetaData, clr);
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044010"));
            }
            if (originatingLoadCall) {
                this.processListenerLoadingCall();
            }
            FileMetaData[] fileMetaDataArray = fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
            return fileMetaDataArray;
        }
        finally {
            if (originatingLoadCall) {
                this.updateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileMetaData[] loadPersistenceUnit(PersistenceUnitMetaData pumd, ClassLoader loader) {
        if (!this.allowMetaDataLoad) {
            return null;
        }
        boolean originatingLoadCall = false;
        if (this.listenersLoadedMetaData == null && this.listeners != null) {
            originatingLoadCall = true;
            this.listenersLoadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        try {
            Properties puProps;
            if (originatingLoadCall) {
                this.updateLock.lock();
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044007", pumd.getName()));
            }
            if ((puProps = pumd.getProperties()) != null) {
                Boolean val;
                if (puProps.containsKey("datanucleus.metadata.xml.validate") && (val = Boolean.valueOf((String)puProps.get("datanucleus.metadata.xml.validate"))) != null) {
                    this.validateXML = val;
                }
                if (puProps.containsKey("datanucleus.metadata.xml.namespaceAware") && (val = Boolean.valueOf((String)puProps.get("datanucleus.metadata.xml.namespaceAware"))) != null) {
                    this.supportXMLNamespaces = val;
                }
            }
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(loader);
            HashSet<Throwable> exceptions = new HashSet<Throwable>();
            ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
            HashSet<String> mappingFiles = new HashSet<String>();
            if (this.allowXML) {
                Set jarFileNames;
                if (this.nucleusContext.getApiName().equalsIgnoreCase("JPA")) {
                    mappingFiles.add("META-INF/orm.xml");
                }
                if (pumd.getMappingFiles() != null) {
                    mappingFiles.addAll(pumd.getMappingFiles());
                }
                if (this.nucleusContext.getApiName().equalsIgnoreCase("JDO") && (jarFileNames = pumd.getJarFiles()) != null) {
                    for (Object jarFile : jarFileNames) {
                        int i;
                        String[] packageJdoFiles;
                        if (jarFile instanceof String) {
                            packageJdoFiles = ClassUtils.getPackageJdoFilesForJarFile((String)jarFile);
                            if (packageJdoFiles == null) continue;
                            for (i = 0; i < packageJdoFiles.length; ++i) {
                                mappingFiles.add(packageJdoFiles[i]);
                            }
                            continue;
                        }
                        if (jarFile instanceof URL) {
                            packageJdoFiles = ClassUtils.getPackageJdoFilesForJarFile((URL)jarFile);
                            if (packageJdoFiles == null) continue;
                            for (i = 0; i < packageJdoFiles.length; ++i) {
                                mappingFiles.add(packageJdoFiles[i]);
                            }
                            continue;
                        }
                        if (!(jarFile instanceof URI) || (packageJdoFiles = ClassUtils.getPackageJdoFilesForJarFile((URI)jarFile)) == null) continue;
                        for (i = 0; i < packageJdoFiles.length; ++i) {
                            mappingFiles.add(packageJdoFiles[i]);
                        }
                    }
                }
            }
            HashSet<String> classNames = new HashSet<String>();
            if (this.allowAnnotations) {
                Set jarFileNames;
                if (pumd.getClassNames() != null) {
                    classNames.addAll(pumd.getClassNames());
                }
                if (this.getNucleusContext() instanceof PersistenceNucleusContextImpl && (jarFileNames = pumd.getJarFiles()) != null) {
                    for (Object jarFile : jarFileNames) {
                        int i;
                        String[] jarClassNames;
                        if (jarFile instanceof String) {
                            jarClassNames = ClassUtils.getClassNamesForJarFile((String)jarFile);
                            if (jarClassNames == null) continue;
                            for (i = 0; i < jarClassNames.length; ++i) {
                                classNames.add(jarClassNames[i]);
                            }
                            continue;
                        }
                        if (jarFile instanceof URL) {
                            jarClassNames = ClassUtils.getClassNamesForJarFile((URL)jarFile);
                            if (jarClassNames == null) continue;
                            for (i = 0; i < jarClassNames.length; ++i) {
                                classNames.add(jarClassNames[i]);
                            }
                            continue;
                        }
                        if (!(jarFile instanceof URI) || (jarClassNames = ClassUtils.getClassNamesForJarFile((URI)jarFile)) == null) continue;
                        for (i = 0; i < jarClassNames.length; ++i) {
                            classNames.add(jarClassNames[i]);
                        }
                    }
                }
                if (!pumd.getExcludeUnlistedClasses()) {
                    MetaDataScanner scanner = this.getScanner(clr);
                    if (scanner != null) {
                        Set<String> scannedClassNames = scanner.scanForPersistableClasses(pumd);
                        if (scannedClassNames != null) {
                            classNames.addAll(scannedClassNames);
                        }
                    } else {
                        try {
                            File rootDir;
                            String[] scannedClassNames;
                            if (pumd.getRootURI() != null && pumd.getRootURI().getScheme().equals("file") && (scannedClassNames = ClassUtils.getClassNamesForDirectoryAndBelow(rootDir = new File(pumd.getRootURI()))) != null) {
                                for (int i = 0; i < scannedClassNames.length; ++i) {
                                    NucleusLogger.METADATA.debug(Localiser.msg("044026", scannedClassNames[i], pumd.getName()));
                                    classNames.add(scannedClassNames[i]);
                                }
                            }
                        }
                        catch (IllegalArgumentException iae) {
                            NucleusLogger.METADATA.debug("Ignoring scan of classes for this persistence-unit since the URI root is " + pumd.getRootURI() + " and is not hierarchical");
                        }
                    }
                }
            }
            if (this.allowXML && !mappingFiles.isEmpty()) {
                for (String mappingFileName : mappingFiles) {
                    try {
                        Enumeration<URL> files = clr.getResources(mappingFileName, Thread.currentThread().getContextClassLoader());
                        if (!files.hasMoreElements()) {
                            NucleusLogger.METADATA.debug("Not found any metadata mapping files for resource name " + mappingFileName + " in CLASSPATH");
                            continue;
                        }
                        while (files.hasMoreElements()) {
                            FileMetaData filemd;
                            URL url = files.nextElement();
                            if (url == null || this.fileMetaDataByURLString.get(url.toString()) != null || (filemd = this.parseFile(url)) == null) continue;
                            this.registerFile(url.toString(), filemd, clr);
                            fileMetaData.add(filemd);
                        }
                    }
                    catch (InvalidMetaDataException imde) {
                        NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(imde));
                        exceptions.add(imde);
                    }
                    catch (IOException ioe) {
                        NucleusLogger.METADATA.error(Localiser.msg("044027", pumd.getName(), mappingFileName, ioe.getMessage()), ioe);
                    }
                }
            }
            if (this.allowAnnotations && !classNames.isEmpty()) {
                for (String className : classNames) {
                    AbstractClassMetaData cmd = this.classMetaDataByClass.get(className);
                    if (cmd != null) continue;
                    try {
                        Class cls = clr.classForName(className);
                        FileMetaData filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                        if (filemd != null) {
                            fileMetaData.add(filemd);
                            continue;
                        }
                        NucleusLogger.METADATA.debug("Class " + className + " was specified in persistence-unit (maybe by not putting exclude-unlisted-classes) " + pumd.getName() + " but not annotated, so ignoring");
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                    }
                    catch (Throwable e) {
                        exceptions.add(e);
                    }
                }
            }
            if (!exceptions.isEmpty()) {
                throw new NucleusUserException(Localiser.msg("044023", pumd.getName()), exceptions.toArray(new Throwable[exceptions.size()]));
            }
            if (!fileMetaData.isEmpty()) {
                this.initialiseFileMetaDataForUse(fileMetaData, clr);
            }
            for (AbstractClassMetaData cmd : this.classMetaDataByClass.values()) {
                if (!cmd.isPopulated()) {
                    this.populateAbstractClassMetaData(cmd, clr, loader);
                }
                if (cmd.isInitialised()) continue;
                this.initialiseAbstractClassMetaData(cmd, clr);
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044010"));
            }
            if (originatingLoadCall) {
                this.processListenerLoadingCall();
            }
            FileMetaData[] fileMetaDataArray = fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
            return fileMetaDataArray;
        }
        finally {
            if (originatingLoadCall) {
                this.updateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUserMetaData(FileMetaData fileMetaData, ClassLoader loader) {
        if (fileMetaData == null) {
            return;
        }
        if (!this.allowMetaDataLoad) {
            return;
        }
        boolean originatingLoadCall = false;
        if (this.listenersLoadedMetaData == null && this.listeners != null) {
            originatingLoadCall = true;
            this.listenersLoadedMetaData = new ArrayList<AbstractClassMetaData>();
        }
        try {
            if (originatingLoadCall) {
                this.updateLock.lock();
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044008"));
            }
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(loader);
            fileMetaData.setFilename("User_Metadata_" + this.userMetaDataNumber);
            ++this.userMetaDataNumber;
            this.registerFile(fileMetaData.getFilename(), fileMetaData, clr);
            ArrayList<FileMetaData> filemds = new ArrayList<FileMetaData>();
            filemds.add(fileMetaData);
            this.initialiseFileMetaDataForUse(filemds, clr);
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044010"));
            }
            if (originatingLoadCall) {
                this.processListenerLoadingCall();
            }
        }
        finally {
            if (originatingLoadCall) {
                this.updateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadMetaDataForClass(String className) {
        try {
            Map.Entry<String, AbstractClassMetaData> entry;
            this.updateLock.lock();
            this.usableClassMetaDataByClass.remove(className);
            AbstractClassMetaData cmd = this.classMetaDataByClass.remove(className);
            Iterator<Map.Entry<String, AbstractClassMetaData>> iter = this.classMetaDataByDiscriminatorName.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                if (entry.getValue() != cmd) continue;
                iter.remove();
            }
            iter = this.classMetaDataByEntityName.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                if (entry.getValue() != cmd) continue;
                iter.remove();
            }
            for (Map.Entry entry2 : this.classMetaDataByAppIdClassName.entrySet()) {
                Collection collCmds = (Collection)entry2.getValue();
                if (collCmds.isEmpty()) continue;
                collCmds.remove(cmd);
            }
            this.concreteSubclassNamesByClassName.remove(className);
            this.directSubclassesByClass.remove(className);
            this.discriminatorLookupByRootClassName.remove(className);
            this.classesWithoutPersistenceInfo.remove(className);
        }
        finally {
            this.updateLock.unlock();
        }
    }

    protected MetaDataScanner getScanner(ClassLoaderResolver clr) {
        Object so = this.nucleusContext.getConfiguration().getProperty("datanucleus.metadata.scanner");
        if (so == null) {
            return null;
        }
        if (so instanceof MetaDataScanner) {
            return (MetaDataScanner)so;
        }
        if (so instanceof String) {
            try {
                Class clazz = clr.classForName((String)so);
                return (MetaDataScanner)clazz.newInstance();
            }
            catch (Throwable t) {
                throw new NucleusUserException(Localiser.msg("044012", so), t);
            }
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(Localiser.msg("044011", so));
        }
        return null;
    }

    protected void initialiseFileMetaDataForUse(Collection fileMetaData, ClassLoaderResolver clr) {
        HashSet<Exception> exceptions = new HashSet<Exception>();
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(Localiser.msg("044018"));
        }
        for (FileMetaData filemd : fileMetaData) {
            if (filemd.isInitialised()) continue;
            this.populateFileMetaData(filemd, clr, null);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(Localiser.msg("044019"));
        }
        for (FileMetaData filemd : fileMetaData) {
            if (filemd.isInitialised()) continue;
            try {
                this.initialiseFileMetaData(filemd, clr, null);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new NucleusUserException(Localiser.msg("044020"), exceptions.toArray(new Throwable[exceptions.size()]));
        }
    }

    @Override
    public Collection<FileMetaData> loadFiles(String[] metadataFiles, ClassLoaderResolver clr) {
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        HashSet<Exception> exceptions = new HashSet<Exception>();
        if (this.allowXML) {
            for (int i = 0; i < metadataFiles.length; ++i) {
                try {
                    URL fileURL = null;
                    try {
                        File file = new File(metadataFiles[i]);
                        fileURL = file.toURI().toURL();
                        if (!file.exists()) {
                            fileURL = clr.getResource(metadataFiles[i], null);
                        }
                    }
                    catch (Exception mue) {
                        fileURL = clr.getResource(metadataFiles[i], null);
                    }
                    if (fileURL == null) {
                        NucleusLogger.METADATA.warn("Metadata file " + metadataFiles[i] + " not found in CLASSPATH");
                        continue;
                    }
                    FileMetaData filemd = this.fileMetaDataByURLString.get(fileURL.toString());
                    if (filemd == null) {
                        filemd = this.parseFile(fileURL);
                        if (filemd != null) {
                            this.registerFile(fileURL.toString(), filemd, clr);
                            fileMetaData.add(filemd);
                            continue;
                        }
                        throw new NucleusUserException(Localiser.msg("044015", metadataFiles[i]));
                    }
                    fileMetaData.add(filemd);
                    continue;
                }
                catch (Exception e) {
                    NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                    exceptions.add(e);
                }
            }
        }
        if (!exceptions.isEmpty()) {
            throw new NucleusUserException(Localiser.msg("044016"), exceptions.toArray(new Throwable[exceptions.size()]), null);
        }
        return fileMetaData;
    }

    @Override
    public boolean isClassPersistable(String className) {
        AbstractClassMetaData acmd = this.readMetaDataForClass(className);
        if (acmd == null) {
            return false;
        }
        return acmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE;
    }

    @Override
    public FileMetaData[] getFileMetaData() {
        Collection<FileMetaData> filemds = this.fileMetaDataByURLString.values();
        return filemds.toArray(new FileMetaData[filemds.size()]);
    }

    @Override
    public Collection<String> getClassesWithMetaData() {
        return Collections.unmodifiableCollection(this.classMetaDataByClass.keySet());
    }

    @Override
    public boolean hasMetaDataForClass(String className) {
        if (className == null) {
            return false;
        }
        if (this.isClassWithoutPersistenceInfo(className)) {
            return false;
        }
        return this.classMetaDataByClass.get(className) != null;
    }

    protected boolean isClassWithoutPersistenceInfo(String className) {
        if (className == null) {
            return true;
        }
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            return true;
        }
        return this.classesWithoutPersistenceInfo.contains(className);
    }

    @Override
    public Collection<AbstractClassMetaData> getClassMetaDataWithApplicationId(String objectIdClassName) {
        return (Collection)this.classMetaDataByAppIdClassName.get(objectIdClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractClassMetaData getMetaDataForClass(String className, ClassLoaderResolver clr) {
        if (className == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.usableClassMetaDataByClass.get(className);
        if (cmd != null) {
            return cmd;
        }
        if (this.isClassWithoutPersistenceInfo(className)) {
            return null;
        }
        MetaDataManagerImpl metaDataManagerImpl = this;
        synchronized (metaDataManagerImpl) {
            cmd = this.classMetaDataByClass.get(className);
            if (cmd != null && cmd.isPopulated() && cmd.isInitialised() && cmd instanceof ClassMetaData) {
                return cmd;
            }
            Class c = null;
            try {
                c = clr == null ? Class.forName(className) : clr.classForName(className, null, false);
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (c == null) {
                if (cmd != null && cmd.isPopulated() && cmd.isInitialised()) {
                    return cmd;
                }
                return null;
            }
            cmd = this.getMetaDataForClass(c, clr);
            if (cmd != null) {
                this.usableClassMetaDataByClass.put(className, cmd);
            }
            return cmd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractClassMetaData getMetaDataForClass(Class c, ClassLoaderResolver clr) {
        if (c == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.usableClassMetaDataByClass.get(c.getName());
        if (cmd != null) {
            return cmd;
        }
        if (this.isClassWithoutPersistenceInfo(c.getName())) {
            return null;
        }
        MetaDataManagerImpl metaDataManagerImpl = this;
        synchronized (metaDataManagerImpl) {
            boolean originatingLoadCall = false;
            if (this.listenersLoadedMetaData == null && this.listeners != null) {
                originatingLoadCall = true;
                this.listenersLoadedMetaData = new ArrayList<AbstractClassMetaData>();
            }
            cmd = null;
            cmd = c.isInterface() ? this.getClassMetaDataForImplementationOfPersistentInterface(c.getName()) : this.getMetaDataForClassInternal(c, clr);
            if (cmd != null) {
                this.populateAbstractClassMetaData(cmd, clr, c.getClassLoader());
                this.initialiseAbstractClassMetaData(cmd, clr);
                if (!this.utilisedFileMetaData.isEmpty()) {
                    ArrayList utilisedFileMetaData1 = (ArrayList)this.utilisedFileMetaData.clone();
                    this.utilisedFileMetaData.clear();
                    for (FileMetaData filemd : utilisedFileMetaData1) {
                        this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                    }
                    if (!this.utilisedFileMetaData.isEmpty()) {
                        ArrayList utilisedFileMetaData2 = (ArrayList)this.utilisedFileMetaData.clone();
                        this.utilisedFileMetaData.clear();
                        for (FileMetaData filemd : utilisedFileMetaData2) {
                            this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                        }
                    }
                }
            } else if (!c.isInterface()) {
                this.classesWithoutPersistenceInfo.add(c.getName());
            }
            this.utilisedFileMetaData.clear();
            if (originatingLoadCall) {
                this.processListenerLoadingCall();
            }
            if (cmd != null) {
                this.usableClassMetaDataByClass.put(c.getName(), cmd);
            }
            return cmd;
        }
    }

    protected void processListenerLoadingCall() {
        if (!this.listenersLoadedMetaData.isEmpty() && this.listeners != null) {
            for (AbstractClassMetaData acmd : new ArrayList<AbstractClassMetaData>(this.listenersLoadedMetaData)) {
                for (MetaDataListener listener : this.listeners) {
                    listener.loaded(acmd);
                }
            }
        }
        this.listenersLoadedMetaData = null;
    }

    @Override
    public AbstractClassMetaData getMetaDataForEntityName(String entityName) {
        return this.classMetaDataByEntityName.get(entityName);
    }

    @Override
    public AbstractClassMetaData getMetaDataForDiscriminator(String discriminator) {
        return this.classMetaDataByDiscriminatorName.get(discriminator);
    }

    @Override
    public AbstractClassMetaData readMetaDataForClass(String className) {
        return this.classMetaDataByClass.get(className);
    }

    @Override
    public AbstractMemberMetaData readMetaDataForMember(String className, String memberName) {
        AbstractClassMetaData cmd = this.readMetaDataForClass(className);
        return cmd != null ? cmd.getMetaDataForMember(memberName) : null;
    }

    @Override
    public abstract AbstractClassMetaData getMetaDataForClassInternal(Class var1, ClassLoaderResolver var2);

    protected void registerMetaDataForClass(String fullClassName, AbstractClassMetaData cmd) {
        this.classMetaDataByClass.put(fullClassName, cmd);
    }

    @Override
    public String[] getClassesImplementingInterface(String interfaceName, ClassLoaderResolver clr) {
        HashSet classes = new HashSet();
        Class intfClass = clr.classForName(interfaceName);
        HashSet<String> generatedClassNames = new HashSet<String>();
        Collection<AbstractClassMetaData> cmds = this.classMetaDataByClass.values();
        Iterator<AbstractClassMetaData> cmdIter = cmds.iterator();
        boolean isPersistentInterface = false;
        while (cmdIter.hasNext()) {
            AbstractClassMetaData acmd = cmdIter.next();
            Class implClass = null;
            try {
                implClass = clr.classForName(acmd.getFullClassName());
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (implClass != null) {
                if (acmd instanceof ClassMetaData) {
                    this.initialiseAbstractClassMetaData(acmd, clr);
                    if (!intfClass.isAssignableFrom(implClass) || ((ClassMetaData)acmd).isAbstract()) continue;
                    classes.add(implClass);
                    continue;
                }
                if (!(acmd instanceof InterfaceMetaData) || !intfClass.isAssignableFrom(implClass)) continue;
                isPersistentInterface = true;
                continue;
            }
            if (!this.isPersistentInterfaceImplementation(interfaceName, acmd.getFullClassName())) continue;
            isPersistentInterface = true;
            generatedClassNames.add(acmd.getFullClassName());
        }
        if (isPersistentInterface && this.nucleusContext instanceof PersistenceNucleusContext && ((PersistenceNucleusContext)this.nucleusContext).getImplementationCreator() != null) {
            classes.add(((PersistenceNucleusContext)this.nucleusContext).getImplementationCreator().newInstance(intfClass, clr).getClass());
            int numClasses = classes.size() + generatedClassNames.size();
            String[] classNames = new String[numClasses];
            Iterator iter = classes.iterator();
            int i = 0;
            while (iter.hasNext()) {
                classNames[i++] = ((Class)iter.next()).getName();
            }
            iter = generatedClassNames.iterator();
            while (iter.hasNext()) {
                classNames[i++] = (String)iter.next();
            }
            return classNames;
        }
        if (!classes.isEmpty()) {
            TreeSet classesSorted = new TreeSet(new InterfaceClassComparator());
            Iterator classesIter = classes.iterator();
            while (classesIter.hasNext()) {
                classesSorted.add(classesIter.next());
            }
            String[] classNames = new String[classesSorted.size()];
            Iterator iter = classesSorted.iterator();
            int i = 0;
            while (iter.hasNext()) {
                classNames[i++] = ((Class)iter.next()).getName();
            }
            return classNames;
        }
        return null;
    }

    @Override
    public void addORMDataToClass(Class c, ClassLoaderResolver clr) {
    }

    @Override
    public void addAnnotationsDataToClass(Class c, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (this.allowAnnotations) {
            ClassMetaData annotCmd;
            if (cmd.getPackageMetaData() != null && cmd.getPackageMetaData().getFileMetaData() != null && cmd.getPackageMetaData().getFileMetaData().getType() == MetadataFileType.ANNOTATIONS) {
                return;
            }
            FileMetaData filemd = this.loadAnnotationsForClass(c, clr, false, false);
            if (filemd != null && (annotCmd = filemd.getPackage(0).getClass(0)) != null) {
                this.postProcessClassMetaData(annotCmd, clr);
                MetaDataMerger.mergeClassAnnotationsData(cmd, annotCmd, this);
            }
        }
    }

    @Override
    public ClassMetaData getMetaDataForImplementationOfReference(Class referenceClass, Object implValue, ClassLoaderResolver clr) {
        if (referenceClass == null || !referenceClass.isInterface() && referenceClass != Object.class) {
            return null;
        }
        ClassMetaData intfMetaData = this.getClassMetaDataForImplementationOfPersistentInterface(referenceClass.getName());
        if (intfMetaData != null) {
            return intfMetaData;
        }
        ClassMetaData cmd = null;
        Set<String> classMetaDataClasses = this.classMetaDataByClass.keySet();
        block2: for (String class_name : classMetaDataClasses) {
            AbstractClassMetaData cmd_cls = this.classMetaDataByClass.get(class_name);
            if (!(cmd_cls instanceof ClassMetaData)) continue;
            try {
                if (referenceClass != Object.class && !clr.isAssignableFrom(referenceClass, class_name)) continue;
                cmd = (ClassMetaData)cmd_cls;
                if (implValue != null && cmd.getFullClassName().equals(implValue.getClass().getName())) {
                    return cmd;
                }
                cmd_cls = cmd.getSuperAbstractClassMetaData();
                while (cmd_cls != null && (referenceClass == Object.class || clr.isAssignableFrom(referenceClass, ((ClassMetaData)cmd_cls).getFullClassName()))) {
                    cmd = (ClassMetaData)cmd_cls;
                    if (implValue != null && cmd.getFullClassName().equals(implValue.getClass().getName())) continue block2;
                    if ((cmd_cls = cmd_cls.getSuperAbstractClassMetaData()) != null) continue;
                }
            }
            catch (Exception e) {}
        }
        return cmd;
    }

    @Override
    public QueryMetaData getMetaDataForQuery(Class cls, ClassLoaderResolver clr, String queryName) {
        if (queryName == null || this.queryMetaDataByName == null) {
            return null;
        }
        String query_key = queryName;
        if (cls != null) {
            query_key = cls.getName() + "_" + queryName;
        }
        return this.queryMetaDataByName.get(query_key);
    }

    @Override
    public Set<String> getNamedQueryNames() {
        if (this.queryMetaDataByName == null || this.queryMetaDataByName.isEmpty()) {
            return null;
        }
        return this.queryMetaDataByName.keySet();
    }

    @Override
    public StoredProcQueryMetaData getMetaDataForStoredProcQuery(Class cls, ClassLoaderResolver clr, String queryName) {
        if (queryName == null || this.storedProcQueryMetaDataByName == null) {
            return null;
        }
        String query_key = queryName;
        if (cls != null) {
            query_key = cls.getName() + "_" + queryName;
        }
        return this.storedProcQueryMetaDataByName.get(query_key);
    }

    @Override
    public FetchPlanMetaData getMetaDataForFetchPlan(String name) {
        if (name == null || this.fetchPlanMetaDataByName == null) {
            return null;
        }
        return this.fetchPlanMetaDataByName.get(name);
    }

    @Override
    public SequenceMetaData getMetaDataForSequence(ClassLoaderResolver clr, String seqName) {
        if (seqName == null || this.sequenceMetaDataByPackageSequence == null) {
            return null;
        }
        return this.sequenceMetaDataByPackageSequence.get(seqName);
    }

    @Override
    public TableGeneratorMetaData getMetaDataForTableGenerator(ClassLoaderResolver clr, String genName) {
        if (genName == null || this.tableGeneratorMetaDataByPackageSequence == null) {
            return null;
        }
        return this.tableGeneratorMetaDataByPackageSequence.get(genName);
    }

    @Override
    public QueryResultMetaData getMetaDataForQueryResult(String name) {
        if (name == null || this.queryResultMetaDataByName == null) {
            return null;
        }
        return this.queryResultMetaDataByName.get(name);
    }

    @Override
    public InterfaceMetaData getMetaDataForInterface(Class c, ClassLoaderResolver clr) {
        return null;
    }

    @Override
    public boolean isPersistentInterface(String name) {
        return false;
    }

    @Override
    public boolean isPersistentInterfaceImplementation(String interfaceName, String implName) {
        return false;
    }

    @Override
    public boolean isPersistentDefinitionImplementation(String implName) {
        return false;
    }

    @Override
    public String getImplementationNameForPersistentInterface(String interfaceName) {
        return null;
    }

    @Override
    public ClassMetaData getClassMetaDataForImplementationOfPersistentInterface(String interfaceName) {
        return null;
    }

    @Override
    public void registerPersistentInterface(InterfaceMetaData imd, Class implClass, ClassLoaderResolver clr) {
    }

    @Override
    public void registerImplementationOfAbstractClass(ClassMetaData cmd, Class implClass, ClassLoaderResolver clr) {
    }

    @Override
    public PersistenceUnitMetaData getMetaDataForPersistenceUnit(String unitName) {
        String filename = this.nucleusContext.getConfiguration().getStringProperty("datanucleus.persistenceXmlFilename");
        PersistenceFileMetaData[] files = MetaDataUtils.parsePersistenceFiles(this.nucleusContext.getPluginManager(), filename, this.validateXML, this.nucleusContext.getClassLoaderResolver(null));
        if (files == null) {
            throw new NucleusUserException(Localiser.msg("044046"));
        }
        for (int i = 0; i < files.length; ++i) {
            PersistenceUnitMetaData[] unitmds = files[i].getPersistenceUnits();
            if (unitmds == null) continue;
            for (int j = 0; j < unitmds.length; ++j) {
                if (!unitmds[j].getName().equals(unitName)) continue;
                return unitmds[j];
            }
        }
        return null;
    }

    protected abstract FileMetaData parseFile(URL var1);

    @Override
    public abstract void registerFile(String var1, FileMetaData var2, ClassLoaderResolver var3);

    @Override
    public void registerDiscriminatorValueForClass(AbstractClassMetaData cmd, String discrimValue) {
        AbstractClassMetaData rootCmd = cmd.getBaseAbstractClassMetaData();
        DiscriminatorLookup lookup = this.discriminatorLookupByRootClassName.get(rootCmd.getFullClassName());
        if (lookup == null) {
            lookup = new DiscriminatorLookup();
            this.discriminatorLookupByRootClassName.put(rootCmd.getFullClassName(), lookup);
        }
        lookup.addValue(cmd.getFullClassName(), discrimValue);
    }

    @Override
    public String getClassNameForDiscriminatorValueWithRoot(AbstractClassMetaData rootCmd, String discrimValue) {
        DiscriminatorLookup lookup = this.discriminatorLookupByRootClassName.get(rootCmd.getFullClassName());
        if (lookup != null) {
            return lookup.getClassForValue(discrimValue);
        }
        return null;
    }

    @Override
    public String getDiscriminatorValueForClass(AbstractClassMetaData cmd, String discrimValue) {
        AbstractClassMetaData rootCmd = cmd.getBaseAbstractClassMetaData();
        DiscriminatorLookup lookup = this.discriminatorLookupByRootClassName.get(rootCmd.getFullClassName());
        if (lookup != null) {
            return lookup.getValueForClass(cmd.getFullClassName());
        }
        return null;
    }

    @Override
    public String getClassNameFromDiscriminatorValue(String discrimValue, DiscriminatorMetaData dismd) {
        if (discrimValue == null) {
            return null;
        }
        if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
            return discrimValue;
        }
        if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            AbstractClassMetaData baseCmd = (AbstractClassMetaData)((InheritanceMetaData)dismd.getParent()).getParent();
            AbstractClassMetaData rootCmd = baseCmd.getBaseAbstractClassMetaData();
            return this.getClassNameForDiscriminatorValueWithRoot(rootCmd, discrimValue);
        }
        return null;
    }

    @Override
    public void registerSequencesForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            SequenceMetaData[] seqmds = pmd.getSequences();
            if (seqmds == null) continue;
            if (this.sequenceMetaDataByPackageSequence == null) {
                this.sequenceMetaDataByPackageSequence = new ConcurrentHashMap<String, SequenceMetaData>();
            }
            for (int j = 0; j < seqmds.length; ++j) {
                this.sequenceMetaDataByPackageSequence.put(seqmds[j].getFullyQualifiedName(), seqmds[j]);
                this.sequenceMetaDataByPackageSequence.put(seqmds[j].getName(), seqmds[j]);
            }
        }
    }

    @Override
    public void registerTableGeneratorsForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            TableGeneratorMetaData[] tgmds = pmd.getTableGenerators();
            if (tgmds == null) continue;
            if (this.tableGeneratorMetaDataByPackageSequence == null) {
                this.tableGeneratorMetaDataByPackageSequence = new ConcurrentHashMap<String, TableGeneratorMetaData>();
            }
            for (int j = 0; j < tgmds.length; ++j) {
                this.tableGeneratorMetaDataByPackageSequence.put(tgmds[j].getFullyQualifiedName(), tgmds[j]);
                this.tableGeneratorMetaDataByPackageSequence.put(tgmds[j].getName(), tgmds[j]);
            }
        }
    }

    protected void registerQueryResultMetaDataForFile(FileMetaData filemd) {
        int i;
        QueryResultMetaData[] fqrmds = filemd.getQueryResultMetaData();
        if (fqrmds != null) {
            if (this.queryResultMetaDataByName == null) {
                this.queryResultMetaDataByName = new ConcurrentHashMap<String, QueryResultMetaData>();
            }
            for (i = 0; i < fqrmds.length; ++i) {
                this.queryResultMetaDataByName.put(fqrmds[i].getName(), fqrmds[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                QueryResultMetaData[] qrmds = cmd.getQueryResultMetaData();
                if (qrmds == null) continue;
                if (this.queryResultMetaDataByName == null) {
                    this.queryResultMetaDataByName = new ConcurrentHashMap<String, QueryResultMetaData>();
                }
                for (int k = 0; k < qrmds.length; ++k) {
                    this.queryResultMetaDataByName.put(qrmds[k].getName(), qrmds[k]);
                }
            }
        }
    }

    protected void registerQueriesForFile(FileMetaData filemd) {
        int i;
        QueryMetaData[] queries = filemd.getQueries();
        if (queries != null) {
            if (this.queryMetaDataByName == null) {
                this.queryMetaDataByName = new ConcurrentHashMap<String, QueryMetaData>();
            }
            for (i = 0; i < queries.length; ++i) {
                String scope = queries[i].getScope();
                String key = queries[i].getName();
                if (scope != null) {
                    key = scope + "_" + key;
                }
                this.queryMetaDataByName.put(key, queries[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            String key;
            String scope;
            int k;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                QueryMetaData[] classQueries = cmd.getQueries();
                if (classQueries == null) continue;
                if (this.queryMetaDataByName == null) {
                    this.queryMetaDataByName = new ConcurrentHashMap<String, QueryMetaData>();
                }
                for (k = 0; k < classQueries.length; ++k) {
                    scope = classQueries[k].getScope();
                    key = classQueries[k].getName();
                    if (scope != null) {
                        key = scope + "_" + key;
                    }
                    this.queryMetaDataByName.put(key, classQueries[k]);
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData intfmd = pmd.getInterface(j);
                QueryMetaData[] interfaceQueries = intfmd.getQueries();
                if (interfaceQueries == null) continue;
                if (this.queryMetaDataByName == null) {
                    this.queryMetaDataByName = new ConcurrentHashMap<String, QueryMetaData>();
                }
                for (k = 0; k < interfaceQueries.length; ++k) {
                    scope = interfaceQueries[k].getScope();
                    key = interfaceQueries[k].getName();
                    if (scope != null) {
                        key = scope + "_" + key;
                    }
                    this.queryMetaDataByName.put(key, interfaceQueries[k]);
                }
            }
        }
    }

    protected void registerStoredProcQueriesForFile(FileMetaData filemd) {
        int i;
        StoredProcQueryMetaData[] queries = filemd.getStoredProcQueries();
        if (queries != null) {
            if (this.storedProcQueryMetaDataByName == null) {
                this.storedProcQueryMetaDataByName = new ConcurrentHashMap<String, StoredProcQueryMetaData>();
            }
            for (i = 0; i < queries.length; ++i) {
                String key = queries[i].getName();
                this.storedProcQueryMetaDataByName.put(key, queries[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            String key;
            int k;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                StoredProcQueryMetaData[] classStoredProcQueries = cmd.getStoredProcQueries();
                if (classStoredProcQueries == null) continue;
                if (this.storedProcQueryMetaDataByName == null) {
                    this.storedProcQueryMetaDataByName = new ConcurrentHashMap<String, StoredProcQueryMetaData>();
                }
                for (k = 0; k < classStoredProcQueries.length; ++k) {
                    key = classStoredProcQueries[k].getName();
                    this.storedProcQueryMetaDataByName.put(key, classStoredProcQueries[k]);
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData intfmd = pmd.getInterface(j);
                StoredProcQueryMetaData[] interfaceStoredProcQueries = intfmd.getStoredProcQueries();
                if (interfaceStoredProcQueries == null) continue;
                if (this.storedProcQueryMetaDataByName == null) {
                    this.storedProcQueryMetaDataByName = new ConcurrentHashMap<String, StoredProcQueryMetaData>();
                }
                for (k = 0; k < interfaceStoredProcQueries.length; ++k) {
                    key = interfaceStoredProcQueries[k].getName();
                    this.storedProcQueryMetaDataByName.put(key, interfaceStoredProcQueries[k]);
                }
            }
        }
    }

    protected void registerFetchPlansForFile(FileMetaData filemd) {
        FetchPlanMetaData[] fetchPlans = filemd.getFetchPlans();
        if (fetchPlans != null) {
            if (this.fetchPlanMetaDataByName == null) {
                this.fetchPlanMetaDataByName = new ConcurrentHashMap<String, FetchPlanMetaData>();
            }
            for (int i = 0; i < fetchPlans.length; ++i) {
                this.fetchPlanMetaDataByName.put(fetchPlans[i].getName(), fetchPlans[i]);
            }
        }
    }

    protected void populateFileMetaData(FileMetaData filemd, ClassLoaderResolver clr, ClassLoader primary) {
        filemd.setMetaDataManager(this);
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            AbstractClassMetaData cmd;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                cmd = pmd.getClass(j);
                this.populateAbstractClassMetaData(cmd, clr, primary);
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                cmd = pmd.getInterface(j);
                this.populateAbstractClassMetaData(cmd, clr, primary);
            }
        }
    }

    protected void initialiseFileMetaData(FileMetaData filemd, ClassLoaderResolver clr, ClassLoader primary) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            pmd.initialise(clr, this);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                try {
                    this.initialiseClassMetaData(cmd, clr.classForName(cmd.getFullClassName(), primary), clr);
                    continue;
                }
                catch (NucleusException ne) {
                    throw ne;
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData imd = pmd.getInterface(j);
                try {
                    this.initialiseInterfaceMetaData(imd, clr, primary);
                    continue;
                }
                catch (NucleusException jpex) {
                    throw jpex;
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseClassMetaData(ClassMetaData cmd, Class cls, ClassLoaderResolver clr) {
        ClassMetaData classMetaData = cmd;
        synchronized (classMetaData) {
            if (this.getNucleusContext() instanceof PersistenceNucleusContextImpl && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE && !this.getNucleusContext().getApiAdapter().isPersistable(cls)) {
                throw new NucleusUserException(Localiser.msg("044059", cls.getName()));
            }
            this.populateAbstractClassMetaData(cmd, clr, cls.getClassLoader());
            this.initialiseAbstractClassMetaData(cmd, clr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseInterfaceMetaData(InterfaceMetaData imd, ClassLoaderResolver clr, ClassLoader primary) {
        InterfaceMetaData interfaceMetaData = imd;
        synchronized (interfaceMetaData) {
            this.populateAbstractClassMetaData(imd, clr, primary);
            this.initialiseAbstractClassMetaData(imd, clr);
        }
    }

    protected FileMetaData loadAnnotationsForClass(Class cls, ClassLoaderResolver clr, boolean register, boolean populate) {
        if (!this.allowAnnotations) {
            return null;
        }
        if (this.isClassWithoutPersistenceInfo(cls.getName())) {
            return null;
        }
        String clsPackageName = ClassUtils.getPackageNameForClass(cls);
        if (clsPackageName == null) {
            clsPackageName = "";
        }
        FileMetaData filemd = new FileMetaData();
        filemd.setType(MetadataFileType.ANNOTATIONS);
        filemd.setMetaDataManager(this);
        PackageMetaData pmd = filemd.newPackageMetadata(clsPackageName);
        AbstractClassMetaData cmd = this.annotationManager.getMetaDataForClass(cls, pmd, clr);
        if (cmd != null) {
            if (register) {
                this.registerFile("annotations:" + cls.getName(), filemd, clr);
                if (populate) {
                    this.populateFileMetaData(filemd, clr, cls.getClassLoader());
                }
            }
            return filemd;
        }
        return null;
    }

    protected void postProcessClassMetaData(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
    }

    protected void populateAbstractClassMetaData(final AbstractClassMetaData cmd, final ClassLoaderResolver clr, final ClassLoader loader) {
        if (!cmd.isPopulated() && !cmd.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        cmd.populate(clr, loader, MetaDataManagerImpl.this);
                    }
                    catch (NucleusException ne) {
                        throw ne;
                    }
                    catch (Exception e) {
                        throw new NucleusUserException("Exception during population of metadata for " + cmd.getFullClassName(), e);
                    }
                    return null;
                }
            });
        }
    }

    protected void initialiseAbstractClassMetaData(final AbstractClassMetaData cmd, final ClassLoaderResolver clr) {
        if (!cmd.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        cmd.initialise(clr, MetaDataManagerImpl.this);
                    }
                    catch (NucleusException ne) {
                        throw ne;
                    }
                    catch (Exception e) {
                        throw new NucleusUserException("Exception during initialisation of metadata for " + cmd.getFullClassName(), e);
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void abstractClassMetaDataInitialised(AbstractClassMetaData cmd) {
        if (cmd.getIdentityType() == IdentityType.APPLICATION && !cmd.usesSingleFieldIdentityClass()) {
            this.classMetaDataByAppIdClassName.put(cmd.getObjectidClass(), cmd);
        }
        if (cmd instanceof ClassMetaData && cmd.getPersistableSuperclass() != null) {
            Set<String> directSubclasses = this.directSubclassesByClass.get(cmd.getPersistableSuperclass());
            if (directSubclasses == null) {
                directSubclasses = new HashSet<String>();
                this.directSubclassesByClass.put(cmd.getPersistableSuperclass(), directSubclasses);
            }
            directSubclasses.add(cmd.getFullClassName());
            if (!((ClassMetaData)cmd).isAbstract()) {
                AbstractClassMetaData theCmd = cmd;
                while (theCmd.getPersistableSuperclass() != null) {
                    Set<String> subclassNames = this.concreteSubclassNamesByClassName.get((theCmd = theCmd.getSuperAbstractClassMetaData()).getFullClassName());
                    if (subclassNames == null) {
                        subclassNames = new HashSet<String>();
                        this.concreteSubclassNamesByClassName.put(theCmd.getFullClassName(), subclassNames);
                    }
                    subclassNames.add(cmd.getFullClassName());
                }
            }
        }
        if (this.listeners != null && this.listenersLoadedMetaData != null) {
            this.listenersLoadedMetaData.add(cmd);
        }
    }

    @Override
    public String[] getConcreteSubclassesForClass(String className) {
        Set<String> concreteSubclasses = this.concreteSubclassNamesByClassName.get(className);
        return concreteSubclasses == null ? null : concreteSubclasses.toArray(new String[concreteSubclasses.size()]);
    }

    @Override
    public String[] getSubclassesForClass(String className, boolean includeDescendents) {
        HashSet subclassNames2 = new HashSet();
        this.provideSubclassesForClass(className, includeDescendents, subclassNames2);
        if (!subclassNames2.isEmpty()) {
            return subclassNames2.toArray(new String[subclassNames2.size()]);
        }
        return null;
    }

    private void provideSubclassesForClass(String className, boolean includeDescendents, Collection consumer) {
        Set<String> subclasses = this.directSubclassesByClass.get(className);
        if (subclasses != null) {
            consumer.addAll(subclasses);
            if (includeDescendents) {
                Iterator<String> subClassNameIter = subclasses.iterator();
                while (subClassNameIter.hasNext()) {
                    this.provideSubclassesForClass(subClassNameIter.next(), includeDescendents, consumer);
                }
            }
        }
    }

    @Override
    public List<AbstractClassMetaData> getReferencedClasses(String[] classNames, ClassLoaderResolver clr) {
        ArrayList<AbstractClassMetaData> cmds = new ArrayList<AbstractClassMetaData>();
        for (int i = 0; i < classNames.length; ++i) {
            Class cls = null;
            try {
                cls = clr.classForName(classNames[i]);
                if (cls.isInterface()) continue;
                AbstractClassMetaData cmd = this.getMetaDataForClass(classNames[i], clr);
                if (cmd == null) {
                    NucleusLogger.DATASTORE.warn("Class Invalid " + classNames[i]);
                    throw new NoPersistenceInformationException(classNames[i]);
                }
                cmds.addAll(this.getReferencedClassMetaData(cmd, clr));
                continue;
            }
            catch (ClassNotResolvedException cnre) {
                NucleusLogger.DATASTORE.warn("Class " + classNames[i] + " not found so being ignored");
            }
        }
        return cmds;
    }

    protected List<AbstractClassMetaData> getReferencedClassMetaData(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        ArrayList<AbstractClassMetaData> orderedCMDs = new ArrayList<AbstractClassMetaData>();
        HashSet referencedCMDs = new HashSet();
        cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr, this);
        return orderedCMDs;
    }

    @Override
    public boolean isFieldTypePersistable(Class type) {
        AbstractClassMetaData cmd;
        if (this.isEnhancing() && (cmd = this.readMetaDataForClass(type.getName())) != null && cmd instanceof ClassMetaData && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return true;
        }
        return this.getApiAdapter().isPersistable(type);
    }

    private static class InterfaceClassComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -8114305773358090763L;

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null || o2 == null) {
                return Integer.MIN_VALUE;
            }
            Class cls1 = (Class)o1;
            Class cls2 = (Class)o2;
            return cls1.hashCode() - cls2.hashCode();
        }
    }

    private class DiscriminatorLookup {
        Map<String, String> discrimValueByClass = new HashMap<String, String>();
        Map<String, String> discrimClassByValue = new HashMap<String, String>();

        private DiscriminatorLookup() {
        }

        public void addValue(String className, String value) {
            this.discrimValueByClass.put(className, value);
            this.discrimClassByValue.put(value, className);
        }

        public String getValueForClass(String className) {
            return this.discrimValueByClass.get(className);
        }

        public String getClassForValue(String value) {
            return this.discrimClassByValue.get(value);
        }

        public String toString() {
            return StringUtils.mapToString(this.discrimValueByClass);
        }
    }
}

