/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class LongArrayByteBufferConverter
implements TypeConverter<long[], ByteBuffer> {
    @Override
    public ByteBuffer toDatastoreType(long[] memberValue) {
        byte[] bytes = TypeConversionHelper.getByteArrayFromLongArray(memberValue);
        ByteBuffer byteBuffer = ByteBuffer.allocate(memberValue.length);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    @Override
    public long[] toMemberType(ByteBuffer datastoreValue) {
        return TypeConversionHelper.getLongArrayFromByteArray(datastoreValue.array());
    }
}

