/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class BooleanYNConverter
implements TypeConverter<Boolean, Character> {
    @Override
    public Boolean toMemberType(Character chr) {
        if (chr == null) {
            return null;
        }
        try {
            return chr.equals(Character.valueOf('Y'));
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", chr, Boolean.class.getName()), nfe);
        }
    }

    @Override
    public Character toDatastoreType(Boolean bool) {
        return bool != null ? Character.valueOf(bool != false ? (char)'Y' : 'N') : null;
    }
}

