/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class BigDecimalArrayByteBufferConverter
implements TypeConverter<BigDecimal[], ByteBuffer> {
    @Override
    public ByteBuffer toDatastoreType(BigDecimal[] memberValue) {
        byte[] bytes = TypeConversionHelper.getByteArrayFromBigDecimalArray(memberValue);
        ByteBuffer byteBuffer = ByteBuffer.allocate(memberValue.length);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    @Override
    public BigDecimal[] toMemberType(ByteBuffer datastoreValue) {
        return TypeConversionHelper.getBigDecimalArrayFromByteArray(datastoreValue.array());
    }
}

