/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigInteger;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class BigIntegerLongConverter
implements TypeConverter<BigInteger, Long> {
    @Override
    public BigInteger toMemberType(Long val) {
        if (val == null) {
            return null;
        }
        try {
            return BigInteger.valueOf(val);
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", val, (Object)BigInteger.class.getName()), nfe);
        }
    }

    @Override
    public Long toDatastoreType(BigInteger bi) {
        return bi.longValue();
    }
}

