/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ReachabilityFieldManager
extends AbstractFieldManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private final ObjectProvider op;
    private Set reachables = null;

    public ReachabilityFieldManager(ObjectProvider op, Set reachables) {
        this.op = op;
        this.reachables = reachables;
    }

    protected void processPersistable(Object obj, AbstractMemberMetaData mmd) {
        ExecutionContext ec = this.op.getExecutionContext();
        ObjectProvider objOP = ec.findObjectProvider(obj);
        if (objOP != null) {
            Object objID = objOP.getInternalObjectId();
            if (!this.reachables.contains(objID) && !objOP.isDeleted()) {
                if (ec.isEnlistedInTransaction(objID)) {
                    objOP.loadUnloadedRelationFields();
                }
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007000", (Object)StringUtils.toJVMIDString(obj), objID, (Object)objOP.getLifecycleState()));
                }
                this.reachables.add(objID);
                ReachabilityFieldManager pcFM = new ReachabilityFieldManager(objOP, this.reachables);
                int[] relationFieldNums = objOP.getClassMetaData().getRelationMemberPositions(ec.getClassLoaderResolver(), ec.getMetaDataManager());
                int[] loadedFieldNumbers = ClassUtils.getFlagsSetTo(objOP.getLoadedFields(), relationFieldNums, true);
                if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
                    objOP.provideFields(loadedFieldNumbers, pcFM);
                }
            }
        } else if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007005", this.op.getExecutionContext().getApiAdapter().getIdForObject(obj), (Object)mmd.getFullFieldName()));
        }
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        block17: {
            AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (value == null) break block17;
            boolean persistCascade = mmd.isCascadePersist();
            RelationType relType = mmd.getRelationType(this.op.getExecutionContext().getClassLoaderResolver());
            ApiAdapter api = this.op.getExecutionContext().getApiAdapter();
            if (persistCascade) {
                if (RelationType.isRelationSingleValued(relType)) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007004", (Object)mmd.getFullFieldName()));
                    }
                    this.processPersistable(value, mmd);
                } else if (RelationType.isRelationMultiValued(relType)) {
                    if (value instanceof Collection) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007002", (Object)mmd.getFullFieldName()));
                        }
                        Collection coll = (Collection)value;
                        for (Object element : coll) {
                            if (!api.isPersistable(element)) continue;
                            this.processPersistable(element, mmd);
                        }
                    } else if (value instanceof Map) {
                        Map map = (Map)value;
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007002", (Object)mmd.getFullFieldName()));
                        }
                        Set keys = map.keySet();
                        for (Object mapKey : keys) {
                            if (!api.isPersistable(mapKey)) continue;
                            this.processPersistable(mapKey, mmd);
                        }
                        Collection values = map.values();
                        for (Object mapValue : values) {
                            if (!api.isPersistable(mapValue)) continue;
                            this.processPersistable(mapValue, mmd);
                        }
                    } else if (value instanceof Object[]) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007003", (Object)mmd.getFullFieldName()));
                        }
                        Object[] array = (Object[])value;
                        for (int i = 0; i < array.length; ++i) {
                            Object element = array[i];
                            if (!api.isPersistable(element)) continue;
                            this.processPersistable(element, mmd);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
    }
}

