/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.AbstractExtent;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;

public class DefaultCandidateExtent<T>
extends AbstractExtent<T> {
    private FetchPlan fetchPlan = null;
    private Query query;
    protected Map<Iterator, QueryResult> queryResultsByIterator = new HashMap<Iterator, QueryResult>();

    public DefaultCandidateExtent(ExecutionContext ec, Class<T> cls, boolean subclasses, AbstractClassMetaData cmd) {
        super(ec, cls, subclasses, cmd);
        this.query = ec.newQuery();
        this.fetchPlan = this.query.getFetchPlan();
        this.query.setCandidateClass(cls);
        this.query.setSubclasses(subclasses);
    }

    @Override
    public Iterator<T> iterator() {
        Object results = this.query.execute();
        Iterator iter = null;
        if (results instanceof QueryResult) {
            QueryResult qr = (QueryResult)results;
            iter = qr.iterator();
            this.queryResultsByIterator.put(iter, qr);
        } else {
            iter = ((Collection)results).iterator();
        }
        return iter;
    }

    @Override
    public boolean hasSubclasses() {
        return this.subclasses;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.ec;
    }

    @Override
    public FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    @Override
    public void closeAll() {
        this.queryResultsByIterator.clear();
        this.query.closeAll();
        this.fetchPlan.clearGroups().addGroup("default");
    }

    @Override
    public void close(Iterator<T> iterator) {
        QueryResult qr = this.queryResultsByIterator.remove(iterator);
        if (qr != null) {
            this.query.close(qr);
        }
    }
}

